/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.search;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.utilsplugin2.selection.NodeWayUtils;

public class IntersectingMatch
extends SearchCompiler.UnaryMatch {
    private Set<Way> intersecting = null;
    boolean all;

    public IntersectingMatch(SearchCompiler.Match match, boolean all) {
        super(match);
        this.all = all;
    }

    private void init(boolean all) {
        HashSet<Way> matchedWays = new HashSet<Way>();
        Collection allWays = MainApplication.getLayerManager().getActiveDataSet().getWays();
        for (Way way : allWays) {
            if (!this.match.match((OsmPrimitive)way)) continue;
            matchedWays.add(way);
        }
        HashSet<Way> newWays = new HashSet<Way>();
        if (all) {
            NodeWayUtils.addWaysIntersectingWaysRecursively(allWays, matchedWays, newWays);
        } else {
            NodeWayUtils.addWaysIntersectingWays(allWays, matchedWays, newWays);
        }
        this.intersecting = newWays;
    }

    public boolean match(OsmPrimitive osm) {
        if (this.intersecting == null) {
            this.init(this.all);
        }
        if (osm instanceof Way) {
            return this.intersecting.contains(osm);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.all ? 1231 : 1237);
        result = 31 * result + (this.intersecting == null ? 0 : this.intersecting.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj) || !(obj instanceof IntersectingMatch)) {
            return false;
        }
        IntersectingMatch other = (IntersectingMatch)((Object)obj);
        if (this.all != other.all) {
            return false;
        }
        return !(this.intersecting == null ? other.intersecting != null : !this.intersecting.equals(other.intersecting));
    }
}

