/*
 * Decompiled with CFR 0.152.
 */
package edu.princeton.cs.algs4;

import edu.princeton.cs.algs4.Bag;
import edu.princeton.cs.algs4.DirectedEdge;
import edu.princeton.cs.algs4.Stack;

public class EdgeWeightedDigraph {
    private final int V;
    private int E;
    private Bag<DirectedEdge>[] adj;

    public EdgeWeightedDigraph(int V) {
        if (V < 0) {
            throw new RuntimeException("Number of vertices must be nonnegative");
        }
        this.V = V;
        this.E = 0;
        this.adj = new Bag[V];
        for (int v = 0; v < V; ++v) {
            this.adj[v] = new Bag();
        }
    }

    public EdgeWeightedDigraph(int V, int E) {
        this(V);
        if (E < 0) {
            throw new RuntimeException("Number of edges must be nonnegative");
        }
        for (int i = 0; i < E; ++i) {
            int v = (int)(Math.random() * (double)V);
            int w = (int)(Math.random() * (double)V);
            double weight = (double)Math.round(100.0 * Math.random()) / 100.0;
            DirectedEdge e = new DirectedEdge(v, w, weight);
            this.addEdge(e);
        }
    }

    public EdgeWeightedDigraph(EdgeWeightedDigraph G) {
        this(G.V());
        this.E = G.E();
        for (int v = 0; v < G.V(); ++v) {
            Stack<DirectedEdge> reverse = new Stack<DirectedEdge>();
            for (DirectedEdge e : G.adj[v]) {
                reverse.push(e);
            }
            for (DirectedEdge e : reverse) {
                this.adj[v].add(e);
            }
        }
    }

    public int V() {
        return this.V;
    }

    public int E() {
        return this.E;
    }

    public void addEdge(DirectedEdge ed) {
        int v = ed.from();
        this.adj[v].add(ed);
        ++this.E;
    }

    public Iterable<DirectedEdge> adj(int ve) {
        return this.adj[ve];
    }

    public Iterable<DirectedEdge> edges() {
        Bag<DirectedEdge> list = new Bag<DirectedEdge>();
        for (int ve = 0; ve < this.V; ++ve) {
            for (DirectedEdge ed : this.adj(ve)) {
                list.add(ed);
            }
        }
        return list;
    }

    public int outdegree(int ve) {
        return this.adj[ve].size();
    }

    public String toString() {
        String NEWLINE = System.getProperty("line.separator");
        StringBuilder s = new StringBuilder();
        s.append(this.V + " " + this.E + NEWLINE);
        for (int v = 0; v < this.V; ++v) {
            s.append(v + ": ");
            for (DirectedEdge e : this.adj[v]) {
                s.append(String.valueOf(e) + "  ");
            }
            s.append(NEWLINE);
        }
        return s.toString();
    }
}

