/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png.chunks;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.InflaterInputStream;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.formats.png.AbstractPngText;
import org.apache.commons.imaging.formats.png.chunks.AbstractPngTextChunk;
import org.apache.commons.io.IOUtils;

public class PngChunkZtxt
extends AbstractPngTextChunk {
    private final String keyword;
    private final String text;

    public PngChunkZtxt(int length, int chunkType, int crc, byte[] bytes) throws ImagingException, IOException {
        super(length, chunkType, crc, bytes);
        int index = BinaryFunctions.findNull(bytes, "PNG zTXt chunk keyword is unterminated.");
        this.keyword = new String(bytes, 0, index, StandardCharsets.ISO_8859_1);
        int n = ++index;
        ++index;
        byte compressionMethod = bytes[n];
        if (compressionMethod != 0) {
            throw new ImagingException("PNG zTXt chunk has unexpected compression method: " + compressionMethod);
        }
        int compressedTextLength = bytes.length - index;
        byte[] compressedText = Allocator.byteArray(compressedTextLength);
        System.arraycopy(bytes, index, compressedText, 0, compressedTextLength);
        this.text = new String(IOUtils.toByteArray(new InflaterInputStream(new ByteArrayInputStream(compressedText))), StandardCharsets.ISO_8859_1);
    }

    @Override
    public AbstractPngText getContents() {
        return new AbstractPngText.Ztxt(this.keyword, this.text);
    }

    @Override
    public String getKeyword() {
        return this.keyword;
    }

    @Override
    public String getText() {
        return this.text;
    }
}

