/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery_offset_db;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.UserIdentityManager;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.plugins.imagery_offset_db.CalibrationObject;
import org.openstreetmap.josm.plugins.imagery_offset_db.ImageryOffset;
import org.openstreetmap.josm.plugins.imagery_offset_db.ImageryOffsetBase;
import org.openstreetmap.josm.plugins.imagery_offset_db.ImageryOffsetTools;
import org.openstreetmap.josm.plugins.imagery_offset_db.SimpleOffsetQueryTask;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class StoreImageryOffsetAction
extends JosmAction {
    public StoreImageryOffsetAction() {
        super(I18n.tr((String)"Store Imagery Offset...", (Object[])new Object[0]), "storeoffset", I18n.tr((String)"Upload an offset for current imagery (or calibration object geometry) to a server", (Object[])new Object[0]), null, true);
    }

    public void actionPerformed(ActionEvent e) {
        String message;
        ImageryOffsetBase offsetObj;
        OsmPrimitive selection;
        Collection selectedObjects;
        if (!MainApplication.isDisplayingMapView()) {
            return;
        }
        AbstractTileSourceLayer<?> layer = ImageryOffsetTools.getTopImageryLayer();
        if (layer == null) {
            return;
        }
        String userName = UserIdentityManager.getInstance().getUserName();
        if (userName == null || userName.length() == 0) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"To store imagery offsets you must be a registered OSM user.", (Object[])new Object[0]), ImageryOffsetTools.DIALOG_TITLE, 0);
            return;
        }
        if (userName.indexOf(64) > 0) {
            userName = userName.replace('@', ',');
        }
        OsmPrimitive calibration = null;
        if (this.getLayerManager().getEditDataSet() != null && (selectedObjects = this.getLayerManager().getEditDataSet().getSelected()).size() == 1 && !(selection = (OsmPrimitive)selectedObjects.iterator().next()).isIncomplete() && (selection instanceof Way || selection instanceof Node && !((Node)selection).isReferredByWays(1))) {
            Object[] options = new String[]{I18n.tr((String)"Store calibration geometry", (Object[])new Object[0]), I18n.tr((String)"Store imagery offset", (Object[])new Object[0])};
            int result = JOptionPane.showOptionDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"The selected object can be used as a calibration geometry. What do you intend to do?", (Object[])new Object[0]), ImageryOffsetTools.DIALOG_TITLE, -1, 3, null, options, options[0]);
            if (result == 2 || result == -1) {
                return;
            }
            if (result == 0) {
                calibration = selection;
            }
        }
        LatLon center = ImageryOffsetTools.getMapCenter();
        if (calibration == null) {
            if (Math.abs(layer.getDisplaySettings().getDx()) < 1.0E-8 && Math.abs(layer.getDisplaySettings().getDy()) < 1.0E-8 && JOptionPane.showConfirmDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"The topmost imagery layer has no offset. Are you sure you want to upload this?", (Object[])new Object[0]), ImageryOffsetTools.DIALOG_TITLE, 0) != 0) {
                return;
            }
            LatLon offset = ImageryOffsetTools.getLayerOffset(layer, center);
            offsetObj = new ImageryOffset(ImageryOffsetTools.getImageryID(layer), offset);
            message = I18n.tr((String)"You are registering an imagery offset. Other users in this area will be able to use it for mapping.\nPlease make sure it is as precise as possible, and describe a region this offset is applicable to.", (Object[])new Object[0]);
        } else {
            offsetObj = new CalibrationObject(calibration);
            message = I18n.tr((String)"You are registering a calibration geometry. It should be the most precisely positioned object, with\nclearly visible boundaries on various satellite imagery. Please describe this object and its whereabouts.", (Object[])new Object[0]);
        }
        String description = StoreImageryOffsetAction.queryDescription(message);
        if (description == null) {
            return;
        }
        offsetObj.setBasicInfo(center, userName, null, null);
        offsetObj.setDescription(description);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            offsetObj.putServerParams(params);
            StringBuilder query = null;
            for (String key : params.keySet()) {
                if (query == null) {
                    query = new StringBuilder("store?");
                } else {
                    query.append('&');
                }
                query.append(key).append('=').append(URLEncoder.encode((String)params.get(key), "UTF8"));
            }
            MainApplication.worker.submit((Runnable)((Object)new SimpleOffsetQueryTask(query.toString(), I18n.tr((String)"Uploading a new offset...", (Object[])new Object[0]))));
        }
        catch (UnsupportedEncodingException ex) {
            Logging.error((Throwable)ex);
        }
    }

    public static String queryDescription(Object message) {
        String reason = null;
        boolean iterated = false;
        boolean ok = false;
        while (!ok) {
            Object result = JOptionPane.showInputDialog((Component)MainApplication.getMainFrame(), message, ImageryOffsetTools.DIALOG_TITLE, -1, null, null, reason);
            if (result == null || result.toString().length() == 0) {
                return null;
            }
            reason = result.toString();
            if (reason.length() < 3 || reason.length() > 200) {
                if (iterated) continue;
                message = String.valueOf(message) + "\n" + I18n.tr((String)"This string should be 3 to 200 letters long.", (Object[])new Object[0]);
                iterated = true;
                continue;
            }
            ok = true;
        }
        return reason;
    }

    protected void updateEnabledState() {
        boolean state = true;
        if (!MainApplication.isDisplayingMapView() || !MainApplication.getMap().isVisible()) {
            state = false;
        }
        if (ImageryOffsetTools.getTopImageryLayer() == null) {
            state = false;
        }
        this.setEnabled(state);
    }
}

