/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery_offset_db;

import java.awt.Component;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.plugins.imagery_offset_db.ImageryOffsetTools;
import org.openstreetmap.josm.plugins.imagery_offset_db.QuerySuccessListener;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;

class SimpleOffsetQueryTask
extends PleaseWaitRunnable {
    private String query;
    private String errorMessage;
    private String title;
    protected boolean cancelled;
    private QuerySuccessListener listener;

    SimpleOffsetQueryTask(String query, String title) {
        super(ImageryOffsetTools.DIALOG_TITLE);
        this.query = query;
        this.title = title;
        this.cancelled = false;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setListener(QuerySuccessListener listener) {
        this.listener = listener;
    }

    public void removeListener() {
        this.listener = null;
    }

    protected void realRun() {
        this.getProgressMonitor().indeterminateSubTask(this.title);
        try {
            this.errorMessage = null;
            this.doQuery(this.query);
        }
        catch (UploadException e) {
            this.errorMessage = I18n.tr((String)"Server has rejected the request", (Object[])new Object[0]) + ":\n" + e.getMessage();
        }
        catch (IOException e) {
            this.errorMessage = I18n.tr((String)"Unable to connect to the server", (Object[])new Object[0]) + "\n" + e.getMessage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQuery(String query) throws UploadException, IOException {
        try {
            String serverURL = Config.getPref().get("iodb.server.url", "https://offsets.textual.ru/");
            URL url = new URL(serverURL + query);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.connect();
            if (connection.getResponseCode() != 200) {
                throw new IOException("HTTP Response code " + connection.getResponseCode() + " (" + connection.getResponseMessage() + ")");
            }
            InputStream inp = connection.getInputStream();
            if (inp == null) {
                throw new IOException("Empty response");
            }
            try {
                if (!this.cancelled) {
                    this.processResponse(inp);
                }
            }
            finally {
                connection.disconnect();
            }
        }
        catch (MalformedURLException ex) {
            throw new IOException("Malformed URL: " + ex.getMessage());
        }
    }

    protected void cancel() {
        this.cancelled = true;
    }

    protected void finish() {
        if (this.errorMessage != null) {
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), this.errorMessage, ImageryOffsetTools.DIALOG_TITLE, 0);
        } else if (this.listener != null) {
            this.listener.queryPassed();
        }
    }

    protected void processResponse(InputStream inp) throws UploadException {
        Pattern p;
        Matcher m;
        String response = "";
        if (inp != null) {
            Scanner sc = new Scanner(inp, StandardCharsets.UTF_8.name()).useDelimiter("\\A");
            String string = response = sc.hasNext() ? sc.next() : "";
        }
        if ((m = (p = Pattern.compile("<(\\w+)>([^<]+)</\\1>")).matcher(response)).find()) {
            if (m.group(1).equals("error")) {
                throw new UploadException(m.group(2));
            }
        } else {
            throw new UploadException("No response");
        }
    }

    public static class UploadException
    extends Exception {
        UploadException(String message) {
            super(message);
        }
    }
}

