/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fit.lib.global;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.List;
import org.openstreetmap.josm.plugins.fit.lib.global.FitData;
import org.openstreetmap.josm.plugins.fit.lib.global.FitDevDataRecord;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDeveloperField;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDeveloperFieldDescriptionMessage;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitField;
import org.openstreetmap.josm.plugins.fit.lib.utils.DevDataUtils;
import org.openstreetmap.josm.plugins.fit.lib.utils.NumberUtils;

public record FitDeveloperDataIdMessage(BigInteger applicationId, short developerDataIndex, FitDevDataRecord devData) implements FitData
{
    public static FitDeveloperDataIdMessage parse(boolean littleEndian, List<FitField> fieldList, List<FitDeveloperField> developerFieldList, FitDeveloperFieldDescriptionMessage[] devFields, InputStream inputStream) throws IOException {
        BigInteger applicationId = null;
        short developerDataIndex = 255;
        block4: for (FitField fitField : fieldList) {
            short size = fitField.size();
            switch (fitField.fieldDefinitionNumber()) {
                case 1: {
                    applicationId = new BigInteger(inputStream.readNBytes(size));
                    continue block4;
                }
                case 3: {
                    developerDataIndex = NumberUtils.decodeShort(size, littleEndian, inputStream);
                    continue block4;
                }
            }
            inputStream.readNBytes(size);
        }
        return new FitDeveloperDataIdMessage(applicationId, developerDataIndex, DevDataUtils.parseDevFields(littleEndian, developerFieldList, devFields, inputStream));
    }
}

