/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fit.lib.global;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.plugins.fit.lib.FitBaseType;
import org.openstreetmap.josm.plugins.fit.lib.global.FitData;
import org.openstreetmap.josm.plugins.fit.lib.global.FitDevDataRecord;
import org.openstreetmap.josm.plugins.fit.lib.global.HeartRateCadenceDistanceSpeed;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDeveloperField;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitDeveloperFieldDescriptionMessage;
import org.openstreetmap.josm.plugins.fit.lib.records.internal.FitField;
import org.openstreetmap.josm.plugins.fit.lib.utils.DevDataUtils;
import org.openstreetmap.josm.plugins.fit.lib.utils.NumberUtils;

public record FileCreator(short softwareVersion, short hardwareVersion, long[][] unknown, FitDevDataRecord devData) implements FitData
{
    public static FileCreator parse(boolean littleEndian, List<FitField> fieldList, List<FitDeveloperField> developerFieldList, FitDeveloperFieldDescriptionMessage[] developerFields, InputStream inputStream) throws IOException {
        long hardwareVersion = FitBaseType.uint8.invalidValue();
        long softwareVersion = FitBaseType.uint8.invalidValue();
        long[][] unknowns = HeartRateCadenceDistanceSpeed.NO_UNKNOWNS;
        block4: for (FitField fitField : fieldList) {
            short size = fitField.size();
            switch (fitField.fieldDefinitionNumber()) {
                case 0: {
                    softwareVersion = NumberUtils.decodeShort(size, littleEndian, inputStream);
                    continue block4;
                }
                case 1: {
                    hardwareVersion = NumberUtils.decodeShort(size, littleEndian, inputStream);
                    continue block4;
                }
            }
            unknowns = (long[][])Arrays.copyOf(unknowns, unknowns.length + 1);
            unknowns[unknowns.length - 1] = new long[]{fitField.fieldDefinitionNumber(), NumberUtils.decodeLong(size, littleEndian, inputStream)};
        }
        return new FileCreator((short)hardwareVersion, (short)softwareVersion, unknowns, DevDataUtils.parseDevFields(littleEndian, developerFieldList, developerFields, inputStream));
    }
}

