/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.geographic;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.io.ProjectionPatterns;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.date.DateUtils;

public class KmlReader
extends AbstractReader {
    public static final String KML_PLACEMARK = "Placemark";
    public static final String KML_NAME = "name";
    public static final String KML_COLOR = "color";
    public static final String KML_SIMPLE_DATA = "SimpleData";
    public static final String KML_LINE_STRING = "LineString";
    public static final String KML_POINT = "Point";
    public static final String KML_POLYGON = "Polygon";
    public static final String KML_OUTER_BOUND = "outerBoundaryIs";
    public static final String KML_INNER_BOUND = "innerBoundaryIs";
    public static final String KML_LINEAR_RING = "LinearRing";
    public static final String KML_COORDINATES = "coordinates";
    public static final String KML_WHEN = "when";
    public static final String KML_EXT_TRACK = "Track";
    public static final String KML_EXT_COORD = "coord";
    public static final String KML_EXT_LANG = "lang";
    public static final Pattern COLOR_PATTERN = Pattern.compile("\\p{XDigit}{8}");
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s", 256);
    private final XMLStreamReader parser;
    private final Map<LatLon, Node> nodes = new HashMap<LatLon, Node>();

    public KmlReader(XMLStreamReader parser) {
        this.parser = parser;
    }

    public static DataSet parseDataSet(InputStream in, ProgressMonitor instance) throws IOException, XMLStreamException, FactoryConfigurationError {
        try (UTFInputStreamReader ir = UTFInputStreamReader.create((InputStream)in);){
            XMLStreamReader parser = XMLInputFactory.newInstance().createXMLStreamReader((Reader)ir);
            DataSet dataSet = new KmlReader(parser).parseDoc();
            return dataSet;
        }
    }

    protected DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return null;
    }

    private DataSet parseDoc() throws XMLStreamException {
        DataSet ds = new DataSet();
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event != 1 || !this.parser.getLocalName().equals(KML_PLACEMARK)) continue;
            this.parsePlaceMark(ds);
        }
        return ds;
    }

    private static boolean keyIsIgnored(String key) {
        for (ProjectionPatterns pp : OdConstants.PROJECTIONS) {
            if (!pp.getXPattern().matcher(key).matches() && !pp.getYPattern().matcher(key).matches()) continue;
            return true;
        }
        return false;
    }

    private void parsePlaceMark(DataSet ds) throws XMLStreamException {
        ArrayList<Object> list = new ArrayList<Object>();
        long when = 0L;
        Way way = null;
        ArrayList<Node> wayNodes = null;
        Node node = null;
        Relation relation = null;
        String role = "";
        String previousName = null;
        HashMap<String, Object> tags = new HashMap<String, Object>();
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            if (event == 1) {
                if (this.parser.getLocalName().equals(KML_COLOR)) {
                    String s = this.parser.getElementText();
                    if (COLOR_PATTERN.matcher(s).matches()) {
                        tags.put(KML_COLOR, "#" + s.substring(6, 8) + s.substring(4, 6) + s.substring(2, 4));
                    }
                } else if (this.parser.getLocalName().equals(KML_NAME)) {
                    try {
                        tags.put(KML_NAME, this.parser.getElementText());
                    }
                    catch (XMLStreamException e) {
                        Logging.trace((Throwable)e);
                    }
                } else if (this.parser.getLocalName().equals(KML_SIMPLE_DATA)) {
                    String key = this.parser.getAttributeValue(null, KML_NAME);
                    if (!KmlReader.keyIsIgnored(key)) {
                        tags.put(key, this.parser.getElementText());
                    }
                } else if (this.parser.getLocalName().equals(KML_POLYGON)) {
                    relation = new Relation();
                    ds.addPrimitive((OsmPrimitive)relation);
                    relation.put("type", "multipolygon");
                    list.add(relation);
                } else if (this.parser.getLocalName().equals(KML_OUTER_BOUND)) {
                    role = "outer";
                } else if (this.parser.getLocalName().equals(KML_INNER_BOUND)) {
                    role = "inner";
                } else if (this.parser.getLocalName().equals(KML_LINEAR_RING)) {
                    if (relation != null) {
                        way = new Way();
                        ds.addPrimitive((OsmPrimitive)way);
                        wayNodes = new ArrayList();
                        relation.addMember(new RelationMember(role, (OsmPrimitive)way));
                    }
                } else if (this.parser.getLocalName().equals(KML_LINE_STRING) || this.parser.getLocalName().equals(KML_EXT_TRACK)) {
                    way = new Way();
                    ds.addPrimitive((OsmPrimitive)way);
                    wayNodes = new ArrayList();
                    list.add(way);
                } else if (this.parser.getLocalName().equals(KML_COORDINATES)) {
                    String[] tab;
                    for (String s : tab = SPACE_PATTERN.split(this.parser.getElementText().trim())) {
                        node = this.parseNode(ds, wayNodes, node, s.split(","));
                    }
                } else if (this.parser.getLocalName().equals(KML_EXT_COORD)) {
                    if ((node = this.parseNode(ds, wayNodes, node, SPACE_PATTERN.split(this.parser.getElementText().trim()))) != null && when > 0L) {
                        node.setRawTimestamp((int)when);
                    }
                } else if (this.parser.getLocalName().equals(KML_WHEN)) {
                    when = DateUtils.tsFromString((String)this.parser.getElementText().trim());
                } else if (this.parser.getLocalName().equals(KML_EXT_LANG) && KML_NAME.equals(previousName)) {
                    tags.put(KML_NAME, this.parser.getElementText());
                }
                previousName = this.parser.getLocalName();
                continue;
            }
            if (event != 2) continue;
            if (this.parser.getLocalName().equals(KML_PLACEMARK)) break;
            if (this.parser.getLocalName().equals(KML_POINT)) {
                list.add(node);
                continue;
            }
            if (!this.parser.getLocalName().equals(KML_LINE_STRING) && !this.parser.getLocalName().equals(KML_EXT_TRACK) && !this.parser.getLocalName().equals(KML_LINEAR_RING)) continue;
            if (way != null && wayNodes != null) {
                way.setNodes(wayNodes);
            }
            wayNodes = new ArrayList<Node>();
        }
        ds.update(() -> {
            for (OsmPrimitive p : list) {
                p.putAll(tags);
            }
        });
    }

    private Node parseNode(DataSet ds, List<Node> wayNodes, Node node, String[] values) {
        if (values.length >= 2) {
            LatLon ll = new LatLon(Double.parseDouble(values[1]), Double.parseDouble(values[0])).getRoundedToOsmPrecision();
            node = this.nodes.computeIfAbsent(ll, latLon -> {
                Node tNode = new Node(latLon);
                ds.addPrimitive((OsmPrimitive)tNode);
                if (values.length > 2 && !"0".equals(values[2])) {
                    tNode.put("ele", values[2]);
                }
                return tNode;
            });
            if (wayNodes != null) {
                wayNodes.add(node);
            }
        }
        return node;
    }
}

