/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.util;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FormatGroup
extends Format {
    private final List<? extends Format> formats;
    private int formatIndex;

    public FormatGroup(Format ... formatArray) {
        this(Arrays.asList(formatArray));
    }

    public FormatGroup(List<? extends Format> list) {
        if (list.size() == 0) {
            throw new IllegalArgumentException("formats must not be empty");
        }
        this.formats = list;
        this.formatIndex = 0;
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        return this.formats.get(this.formatIndex).format(object, stringBuffer, fieldPosition);
    }

    @Override
    public Object parseObject(String string, ParsePosition parsePosition) {
        Object object;
        if (parsePosition.getErrorIndex() >= 0) {
            throw new IllegalArgumentException(String.valueOf(parsePosition) + " has en error at " + parsePosition.getErrorIndex());
        }
        boolean bl = false;
        Object object2 = null;
        ParsePosition parsePosition2 = new ParsePosition(parsePosition.getIndex());
        Iterator<? extends Format> iterator = this.formats.iterator();
        while (iterator.hasNext() && !bl) {
            object = iterator.next();
            this.mutateTo(parsePosition2, parsePosition);
            object2 = ((Format)object).parseObject(string, parsePosition2);
            bl = parsePosition2.getIndex() != parsePosition.getIndex() && parsePosition2.getErrorIndex() < 0;
        }
        if (!bl) {
            object = this.formats.get(this.formatIndex).parseObject(string, parsePosition);
        } else {
            object = object2;
            this.mutateTo(parsePosition, parsePosition2);
        }
        return object;
    }

    private void mutateTo(ParsePosition parsePosition, ParsePosition parsePosition2) {
        parsePosition.setIndex(parsePosition2.getIndex());
        parsePosition.setErrorIndex(parsePosition2.getErrorIndex());
    }
}

