/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.io;

import java.util.Stack;
import org.jopendocument.model.office.OfficeBody;
import org.jopendocument.model.office.OfficeSpreadsheet;
import org.jopendocument.model.table.TableTable;
import org.jopendocument.model.table.TableTableCell;
import org.jopendocument.model.table.TableTableColumn;
import org.jopendocument.model.table.TableTableRow;
import org.jopendocument.model.text.TextP;
import org.jopendocument.model.text.TextSpan;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SaxContentUnmarshaller
extends DefaultHandler {
    private OfficeBody body;
    private Object current;
    private final Stack<Object> stack = new Stack();

    private void assertParsed(Attributes attributes, int n) {
        if (attributes.getLength() > n) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                System.err.println(attributes.getQName(i) + "  -> " + attributes.getValue(i));
            }
            throw new IllegalStateException("Somme attributes are not parsed");
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cArray, n, n2);
        if (this.current instanceof TextP) {
            ((TextP)this.current).addToLastTextSpan(stringBuffer.toString());
        } else if (this.current instanceof TextSpan) {
            ((TextSpan)this.current).concantValue(stringBuffer.toString());
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        this.pop();
    }

    public OfficeBody getBody() {
        return this.body;
    }

    private void pop() {
        if (!this.stack.isEmpty()) {
            this.stack.pop();
        }
        if (!this.stack.isEmpty()) {
            this.current = this.stack.peek();
        }
    }

    private void push(Object object) {
        this.current = object;
        this.stack.push(object);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if (string3.equals("office:automatic-styles")) {
            this.push(new Object());
        } else if (string3.equals("style:style")) {
            Object object = new Object();
            this.push(object);
        } else if (string3.equals("number:number-style")) {
            Object object = new Object();
            this.push(object);
        } else if (string3.equals("style:table-row-properties")) {
            Object object = new Object();
            this.push(object);
        } else if (string3.equals("style:table-properties")) {
            Object object = new Object();
            this.push(object);
        } else if (string3.equals("style:table-cell-properties")) {
            Object object = new Object();
            this.push(object);
        } else if (string3.equals("style:text-properties")) {
            Object object = new Object();
            this.push(object);
        } else if (string3.equals("style:table-column-properties")) {
            Object object = new Object();
            this.push(object);
        } else if (string3.equals("style:paragraph-properties")) {
            Object object = new Object();
            this.push(object);
        } else if (string3.equals("office:body")) {
            this.body = new OfficeBody();
            this.push(this.body);
        } else if (string3.equals("office:spreadsheet")) {
            OfficeSpreadsheet officeSpreadsheet = new OfficeSpreadsheet();
            if (this.current instanceof OfficeBody) {
                ((OfficeBody)this.current).addOfficeSpreadsheet(officeSpreadsheet);
            } else {
                System.err.println("Not StyleStyle:" + String.valueOf(this.current));
                Thread.dumpStack();
            }
            this.push(officeSpreadsheet);
        } else if (string3.equals("table:table")) {
            TableTable tableTable = new TableTable();
            String string4 = attributes.getValue("table:print-ranges");
            if (string4 != null) {
                tableTable.setTablePrintRanges(string4);
            }
            this.assertParsed(attributes, 3);
            if (this.current instanceof OfficeSpreadsheet) {
                ((OfficeSpreadsheet)this.current).addTable(tableTable);
            } else {
                System.err.println("Not OfficeSpreadsheet:" + String.valueOf(this.current));
                Thread.dumpStack();
            }
            this.push(tableTable);
        } else if (string3.equals("table:table-column")) {
            TableTableColumn tableTableColumn = new TableTableColumn();
            tableTableColumn.setTableStyleName(attributes.getValue("table:style-name"));
            tableTableColumn.setTableDefaultCellStyleName(attributes.getValue("table:default-cell-style-name"));
            tableTableColumn.setTableNumberColumnsRepeated(attributes.getValue("table:number-columns-repeated"));
            this.assertParsed(attributes, 3);
            if (this.current instanceof TableTable) {
                ((TableTable)this.current).addColumn(tableTableColumn);
            } else {
                System.err.println("Not TableTable:" + String.valueOf(this.current));
                Thread.dumpStack();
            }
            this.push(tableTableColumn);
        } else if (string3.equals("table:table-row")) {
            TableTableRow tableTableRow = new TableTableRow();
            tableTableRow.setTableNumberRowsRepeated(attributes.getValue("table:number-rows-repeated"));
            if (this.current instanceof TableTable) {
                ((TableTable)this.current).addRow(tableTableRow);
            } else {
                System.err.println("Not TableTable:" + String.valueOf(this.current));
            }
            this.push(tableTableRow);
        } else if (string3.equals("table:table-cell") || string3.equals("table:covered-table-cell")) {
            TableTableCell tableTableCell = new TableTableCell();
            tableTableCell.setTableStyleName(attributes.getValue("table:style-name"));
            tableTableCell.setTableNumberColumnsRepeated(attributes.getValue("table:number-columns-repeated"));
            if (this.current instanceof TableTableRow) {
                ((TableTableRow)this.current).addCell(tableTableCell);
            } else {
                System.err.println("Not TableTableRow:" + String.valueOf(this.current));
                Thread.dumpStack();
            }
            this.push(tableTableCell);
        } else if (string3.equals("text:p")) {
            TextP textP = new TextP();
            if (this.current instanceof TableTableCell) {
                ((TableTableCell)this.current).setTextP(textP);
            } else {
                System.err.println("Not TableTableCell:" + String.valueOf(this.current) + " classe:" + String.valueOf(this.current.getClass()));
                Thread.dumpStack();
            }
            this.push(textP);
        } else if (string3.equals("text:span")) {
            TextSpan textSpan = new TextSpan();
            if (this.current instanceof TextP) {
                ((TextP)this.current).addTextSpan(textSpan);
            } else {
                System.err.println("Not TextP:" + String.valueOf(this.current));
                Thread.dumpStack();
            }
            this.push(textSpan);
        } else {
            this.push(string);
        }
    }
}

