/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import org.jdom2.Element;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODNode;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.StyleStyle;
import org.jopendocument.dom.XMLVersion;

public abstract class StyledNode<S extends StyleStyle, D extends ODDocument>
extends ODNode {
    private final StyleDesc<S> styleClass;

    public StyledNode(Element element, Class<S> clazz) {
        super(element);
        if (clazz == null) {
            throw new NullPointerException("null style class");
        }
        this.styleClass = StyleStyle.getStyleDesc(clazz, XMLVersion.getVersion(this.getElement()));
        assert (this.styleClass.getRefElements().contains(this.getElement().getQualifiedName())) : this.getElement().getQualifiedName() + " not in " + String.valueOf(this.styleClass);
    }

    public abstract D getODDocument();

    protected String getStyleName() {
        return this.getElement().getAttributeValue("style-name", this.getElement().getNamespace());
    }
}

