/*
 * Decompiled with CFR 0.152.
 */
package org.j7zip.SevenZip.Archive;

public class SevenZipEntry {
    long LastWriteTime;
    long UnPackSize;
    long PackSize;
    int Attributes;
    long FileCRC;
    boolean IsDirectory;
    String Name;
    String Methods;
    long Position;
    static final String kEmptyAttributeChar = ".";
    static final String kDirectoryAttributeChar = "D";
    static final String kReadonlyAttributeChar = "R";
    static final String kHiddenAttributeChar = "H";
    static final String kSystemAttributeChar = "S";
    static final String kArchiveAttributeChar = "A";
    public static final int FILE_ATTRIBUTE_READONLY = 1;
    public static final int FILE_ATTRIBUTE_HIDDEN = 2;
    public static final int FILE_ATTRIBUTE_SYSTEM = 4;
    public static final int FILE_ATTRIBUTE_DIRECTORY = 16;
    public static final int FILE_ATTRIBUTE_ARCHIVE = 32;

    public SevenZipEntry(String name, long packSize, long unPackSize, long crc, long lastWriteTime, long position, boolean isDir, int att, String methods) {
        this.Name = name;
        this.PackSize = packSize;
        this.UnPackSize = unPackSize;
        this.FileCRC = crc;
        this.LastWriteTime = lastWriteTime;
        this.Position = position;
        this.IsDirectory = isDir;
        this.Attributes = att;
        this.Methods = methods;
    }

    public long getCompressedSize() {
        return this.PackSize;
    }

    public long getSize() {
        return this.UnPackSize;
    }

    public long getCrc() {
        return this.FileCRC;
    }

    public String getName() {
        return this.Name;
    }

    public long getTime() {
        return this.LastWriteTime;
    }

    public long getPosition() {
        return this.Position;
    }

    public boolean isDirectory() {
        return this.IsDirectory;
    }

    public String getAttributesString() {
        Object ret = "";
        ret = (String)ret + ((this.Attributes & 0x10) != 0 || this.IsDirectory ? kDirectoryAttributeChar : kEmptyAttributeChar);
        ret = (String)ret + ((this.Attributes & 1) != 0 ? kReadonlyAttributeChar : kEmptyAttributeChar);
        ret = (String)ret + ((this.Attributes & 2) != 0 ? kHiddenAttributeChar : kEmptyAttributeChar);
        ret = (String)ret + ((this.Attributes & 4) != 0 ? kSystemAttributeChar : kEmptyAttributeChar);
        ret = (String)ret + ((this.Attributes & 0x20) != 0 ? kArchiveAttributeChar : kEmptyAttributeChar);
        return ret;
    }

    public String getMethods() {
        return this.Methods;
    }
}

