/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.CellRecord;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.util.RKUtil;
import org.apache.poi.util.LittleEndianOutput;

public final class RKRecord
extends CellRecord {
    public static final short sid = 638;
    private int field_4_rk_number;

    private RKRecord() {
    }

    public RKRecord(RecordInputStream recordInputStream) {
        super(recordInputStream);
        this.field_4_rk_number = recordInputStream.readInt();
    }

    public double getRKNumber() {
        return RKUtil.decodeNumber(this.field_4_rk_number);
    }

    @Override
    protected String getRecordName() {
        return "RK";
    }

    @Override
    protected void appendValueText(StringBuilder stringBuilder) {
        stringBuilder.append("  .value= ").append(this.getRKNumber());
    }

    @Override
    protected void serializeValue(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeInt(this.field_4_rk_number);
    }

    @Override
    protected int getValueDataSize() {
        return 4;
    }

    @Override
    public short getSid() {
        return 638;
    }

    @Override
    public Object clone() {
        RKRecord rKRecord = new RKRecord();
        this.copyBaseFields(rKRecord);
        rKRecord.field_4_rk_number = this.field_4_rk_number;
        return rKRecord;
    }
}

