/*
 * Decompiled with CFR 0.152.
 */
package org.kaintoch.gps.globalsat.dg100;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.kaintoch.gps.globalsat.dg100.Dg100Config;
import org.kaintoch.gps.globalsat.dg100.FileInfoRec;
import org.kaintoch.gps.globalsat.dg100.GpsRec;

public class Response<E> {
    public static final byte typeFileInfo = -69;
    public static final byte typeId = -65;
    public static final byte typeGpsRec = -75;
    public static final byte typeConfig = -73;
    private int typeOfResponse = 0;
    private int cntDataCur = 0;
    private int nextIdx = 0;
    private Dg100Config config = null;
    private List<E> data = new ArrayList(100);
    private long id = 0L;

    private Response(int typeOfResponse) {
        this.typeOfResponse = typeOfResponse;
    }

    public static Response<?> parseResponse(byte[] resp, int len) {
        ByteBuffer buf = ByteBuffer.wrap(resp);
        byte respType = buf.get(4);
        buf.position(5);
        if (respType == -69) {
            Response<FileInfoRec> response = new Response<FileInfoRec>(respType);
            int cntInfoCur = buf.getShort();
            short nextIdx = buf.getShort();
            response.cntDataCur = cntInfoCur;
            response.nextIdx = nextIdx;
            for (int ii = 0; ii < cntInfoCur; ++ii) {
                FileInfoRec fileInfoRec = new FileInfoRec(buf);
                response.addRec(fileInfoRec);
            }
            return response;
        }
        if (respType == -75) {
            GpsRec gpsRec;
            Response<GpsRec> response = new Response<GpsRec>(respType);
            int recType = 2;
            while (buf.position() <= len && (gpsRec = new GpsRec(buf, recType)).isValid() && buf.position() <= len) {
                response.addRec(gpsRec);
                recType = gpsRec.getDg100TypeOfNextRec();
            }
            buf.position(1042);
            while (buf.position() <= len && (gpsRec = new GpsRec(buf, recType)).isValid() && buf.position() <= len) {
                response.addRec(gpsRec);
                recType = gpsRec.getDg100TypeOfNextRec();
            }
            return response;
        }
        if (respType == -73) {
            Dg100Config config;
            Response response = new Response(respType);
            response.config = config = new Dg100Config(buf);
            return response;
        }
        if (respType == -65) {
            Response response = new Response(respType);
            response.id = 0L;
            for (int ii = 0; ii < 8; ++ii) {
                byte digit = buf.get();
                response.id = response.id * 10L + (long)digit;
            }
            return response;
        }
        return new Response(respType);
    }

    private void addRec(E obj) {
        this.data.add(obj);
    }

    public List<E> getRecs() {
        return this.data;
    }

    public int getCntDataCur() {
        return this.cntDataCur;
    }

    public int getNextIdx() {
        return this.nextIdx;
    }

    public int getTypeOfResponse() {
        return this.typeOfResponse;
    }

    public Dg100Config getConfig() {
        return this.config;
    }

    public long getId() {
        return this.id;
    }
}

