/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.editgpx;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.editgpx.EditGpxLayer;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxData;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxTrack;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxTrackSegment;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxWayPoint;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class EditGpxMode
extends MapMode
implements LayerManager.LayerChangeListener {
    private static final long serialVersionUID = 7940589057093872411L;
    Point pointPressed;
    private final MapFrame mapFrame;
    Rectangle oldRect;
    transient EditGpxLayer currentEditLayer;

    public EditGpxMode(MapFrame mapFrame) {
        super("editgpx", "editgpx_mode", I18n.tr((String)"edit gpx tracks", (Object[])new Object[0]), Shortcut.registerShortcut((String)"editgpx:editgpx_mode", (String)I18n.tr((String)"EditGPX Mode", (Object[])new Object[0]), (int)65535, (int)5000), Cursor.getPredefinedCursor(1));
        this.mapFrame = mapFrame;
    }

    public void enterMode() {
        super.enterMode();
        MainApplication.getMap().mapView.addMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.addMouseMotionListener((MouseMotionListener)((Object)this));
        MainApplication.getMap().mapView.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
        this.updateLayer();
    }

    public void exitMode() {
        super.exitMode();
        MainApplication.getMap().mapView.removeMouseListener((MouseListener)((Object)this));
        MainApplication.getMap().mapView.removeMouseMotionListener((MouseMotionListener)((Object)this));
        MainApplication.getMap().mapView.getLayerManager().removeLayerChangeListener((LayerManager.LayerChangeListener)this);
    }

    public void mousePressed(MouseEvent e) {
        this.pointPressed = new Point(e.getPoint());
    }

    public void mouseDragged(MouseEvent e) {
        if ((e.getModifiersEx() & 0x400) == 1024) {
            this.paintRect(this.pointPressed, e.getPoint());
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.getButton() != 1) {
            return;
        }
        this.requestFocusInMapView();
        Rectangle r = this.createRect(e.getPoint(), this.pointPressed);
        if (this.currentEditLayer != null) {
            Projection projection = ProjectionRegistry.getProjection();
            for (EditGpxTrack track : this.currentEditLayer.data.getTracks()) {
                for (EditGpxTrackSegment segment : track.getSegments()) {
                    for (EditGpxWayPoint wayPoint : segment.getWayPoints()) {
                        Point p = MainApplication.getMap().mapView.getPoint(wayPoint.getCoor().getEastNorth((Projecting)projection));
                        if (!r.contains(p)) continue;
                        wayPoint.setDeleted(true);
                    }
                }
            }
            this.currentEditLayer.invalidate();
        }
        this.oldRect = null;
    }

    public Rectangle createRect(Point p1, Point p2) {
        int h;
        int w;
        int y;
        int x;
        if (p1.x == p2.x && p1.y == p2.y) {
            x = p1.x - 1;
            y = p1.y - 1;
            w = 3;
            h = 3;
        } else {
            if (p1.x < p2.x) {
                x = p1.x;
                w = p2.x - p1.x;
            } else {
                x = p2.x;
                w = p1.x - p2.x;
            }
            if (p1.y < p2.y) {
                y = p1.y;
                h = p2.y - p1.y;
            } else {
                y = p2.y;
                h = p1.y - p2.y;
            }
        }
        return new Rectangle(x, y, w, h);
    }

    private void paintRect(Point p1, Point p2) {
        if (this.mapFrame != null) {
            Graphics g = this.mapFrame.getGraphics();
            Rectangle r = this.oldRect;
            if (r != null) {
                g.setXORMode(Color.BLACK);
                g.setColor(Color.WHITE);
                g.drawRect(r.x, r.y, r.width, r.height);
            }
            g.setXORMode(Color.BLACK);
            g.setColor(Color.WHITE);
            r = this.createRect(p1, p2);
            g.drawRect(r.x, r.y, r.width, r.height);
            this.oldRect = r;
        }
    }

    private void updateLayer() {
        List layers = MainApplication.getMap().mapView.getLayerManager().getLayersOfType(EditGpxLayer.class);
        EditGpxLayer editGpxLayer = this.currentEditLayer = layers.isEmpty() ? null : (EditGpxLayer)((Object)layers.get(0));
        if (this.currentEditLayer == null) {
            this.currentEditLayer = new EditGpxLayer(new EditGpxData());
            MainApplication.getLayerManager().addLayer((Layer)this.currentEditLayer);
            this.currentEditLayer.initializeImport();
        }
        this.currentEditLayer.invalidate();
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        if (e.getRemovedLayer() instanceof EditGpxLayer) {
            this.currentEditLayer = null;
            if (MainApplication.getMap().mapMode instanceof EditGpxMode) {
                if (MainApplication.getMap().mapView.getLayerManager().getActiveLayer() instanceof OsmDataLayer) {
                    MainApplication.getMap().selectSelectTool(false);
                } else {
                    MainApplication.getMap().selectZoomTool(false);
                }
            }
        }
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }
}

