/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoEncodeH265SliceSegmentHeaderFlags;
import org.lwjgl.vulkan.video.StdVideoEncodeH265WeightTable;

public class StdVideoEncodeH265SliceSegmentHeader
extends Struct<StdVideoEncodeH265SliceSegmentHeader>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int SLICE_TYPE;
    public static final int SLICE_SEGMENT_ADDRESS;
    public static final int COLLOCATED_REF_IDX;
    public static final int MAXNUMMERGECAND;
    public static final int SLICE_CB_QP_OFFSET;
    public static final int SLICE_CR_QP_OFFSET;
    public static final int SLICE_BETA_OFFSET_DIV2;
    public static final int SLICE_TC_OFFSET_DIV2;
    public static final int SLICE_ACT_Y_QP_OFFSET;
    public static final int SLICE_ACT_CB_QP_OFFSET;
    public static final int SLICE_ACT_CR_QP_OFFSET;
    public static final int SLICE_QP_DELTA;
    public static final int RESERVED1;
    public static final int PWEIGHTTABLE;

    protected StdVideoEncodeH265SliceSegmentHeader(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected StdVideoEncodeH265SliceSegmentHeader create(long address, @Nullable ByteBuffer container) {
        return new StdVideoEncodeH265SliceSegmentHeader(address, container);
    }

    public StdVideoEncodeH265SliceSegmentHeader(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoEncodeH265SliceSegmentHeader.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoEncodeH265SliceSegmentHeaderFlags flags() {
        return StdVideoEncodeH265SliceSegmentHeader.nflags(this.address());
    }

    @NativeType(value="StdVideoH265SliceType")
    public int slice_type() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_type(this.address());
    }

    @NativeType(value="uint32_t")
    public int slice_segment_address() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_segment_address(this.address());
    }

    @NativeType(value="uint8_t")
    public byte collocated_ref_idx() {
        return StdVideoEncodeH265SliceSegmentHeader.ncollocated_ref_idx(this.address());
    }

    @NativeType(value="uint8_t")
    public byte MaxNumMergeCand() {
        return StdVideoEncodeH265SliceSegmentHeader.nMaxNumMergeCand(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_cb_qp_offset() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_cb_qp_offset(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_cr_qp_offset() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_cr_qp_offset(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_beta_offset_div2() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_beta_offset_div2(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_tc_offset_div2() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_tc_offset_div2(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_act_y_qp_offset() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_act_y_qp_offset(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_act_cb_qp_offset() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_act_cb_qp_offset(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_act_cr_qp_offset() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_act_cr_qp_offset(this.address());
    }

    @NativeType(value="int8_t")
    public byte slice_qp_delta() {
        return StdVideoEncodeH265SliceSegmentHeader.nslice_qp_delta(this.address());
    }

    @NativeType(value="StdVideoEncodeH265WeightTable const *")
    public StdVideoEncodeH265WeightTable pWeightTable() {
        return StdVideoEncodeH265SliceSegmentHeader.npWeightTable(this.address());
    }

    public StdVideoEncodeH265SliceSegmentHeader flags(StdVideoEncodeH265SliceSegmentHeaderFlags value) {
        StdVideoEncodeH265SliceSegmentHeader.nflags(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader flags(Consumer<StdVideoEncodeH265SliceSegmentHeaderFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_type(@NativeType(value="StdVideoH265SliceType") int value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_type(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_segment_address(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_segment_address(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader collocated_ref_idx(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.ncollocated_ref_idx(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader MaxNumMergeCand(@NativeType(value="uint8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nMaxNumMergeCand(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_cb_qp_offset(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_cb_qp_offset(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_cr_qp_offset(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_cr_qp_offset(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_beta_offset_div2(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_beta_offset_div2(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_tc_offset_div2(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_tc_offset_div2(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_act_y_qp_offset(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_act_y_qp_offset(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_act_cb_qp_offset(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_act_cb_qp_offset(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_act_cr_qp_offset(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_act_cr_qp_offset(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader slice_qp_delta(@NativeType(value="int8_t") byte value) {
        StdVideoEncodeH265SliceSegmentHeader.nslice_qp_delta(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader pWeightTable(@NativeType(value="StdVideoEncodeH265WeightTable const *") StdVideoEncodeH265WeightTable value) {
        StdVideoEncodeH265SliceSegmentHeader.npWeightTable(this.address(), value);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader set(StdVideoEncodeH265SliceSegmentHeaderFlags flags, int slice_type, int slice_segment_address, byte collocated_ref_idx, byte MaxNumMergeCand, byte slice_cb_qp_offset, byte slice_cr_qp_offset, byte slice_beta_offset_div2, byte slice_tc_offset_div2, byte slice_act_y_qp_offset, byte slice_act_cb_qp_offset, byte slice_act_cr_qp_offset, byte slice_qp_delta, StdVideoEncodeH265WeightTable pWeightTable) {
        this.flags(flags);
        this.slice_type(slice_type);
        this.slice_segment_address(slice_segment_address);
        this.collocated_ref_idx(collocated_ref_idx);
        this.MaxNumMergeCand(MaxNumMergeCand);
        this.slice_cb_qp_offset(slice_cb_qp_offset);
        this.slice_cr_qp_offset(slice_cr_qp_offset);
        this.slice_beta_offset_div2(slice_beta_offset_div2);
        this.slice_tc_offset_div2(slice_tc_offset_div2);
        this.slice_act_y_qp_offset(slice_act_y_qp_offset);
        this.slice_act_cb_qp_offset(slice_act_cb_qp_offset);
        this.slice_act_cr_qp_offset(slice_act_cr_qp_offset);
        this.slice_qp_delta(slice_qp_delta);
        this.pWeightTable(pWeightTable);
        return this;
    }

    public StdVideoEncodeH265SliceSegmentHeader set(StdVideoEncodeH265SliceSegmentHeader src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoEncodeH265SliceSegmentHeader malloc() {
        return new StdVideoEncodeH265SliceSegmentHeader(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StdVideoEncodeH265SliceSegmentHeader calloc() {
        return new StdVideoEncodeH265SliceSegmentHeader(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StdVideoEncodeH265SliceSegmentHeader create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new StdVideoEncodeH265SliceSegmentHeader(MemoryUtil.memAddress(container), container);
    }

    public static StdVideoEncodeH265SliceSegmentHeader create(long address) {
        return new StdVideoEncodeH265SliceSegmentHeader(address, null);
    }

    @Nullable
    public static StdVideoEncodeH265SliceSegmentHeader createSafe(long address) {
        return address == 0L ? null : new StdVideoEncodeH265SliceSegmentHeader(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StdVideoEncodeH265SliceSegmentHeader.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH265SliceSegmentHeader.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoEncodeH265SliceSegmentHeader malloc(MemoryStack stack) {
        return new StdVideoEncodeH265SliceSegmentHeader(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoEncodeH265SliceSegmentHeader calloc(MemoryStack stack) {
        return new StdVideoEncodeH265SliceSegmentHeader(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoEncodeH265SliceSegmentHeaderFlags nflags(long struct) {
        return StdVideoEncodeH265SliceSegmentHeaderFlags.create(struct + (long)FLAGS);
    }

    public static int nslice_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)SLICE_TYPE);
    }

    public static int nslice_segment_address(long struct) {
        return UNSAFE.getInt(null, struct + (long)SLICE_SEGMENT_ADDRESS);
    }

    public static byte ncollocated_ref_idx(long struct) {
        return UNSAFE.getByte(null, struct + (long)COLLOCATED_REF_IDX);
    }

    public static byte nMaxNumMergeCand(long struct) {
        return UNSAFE.getByte(null, struct + (long)MAXNUMMERGECAND);
    }

    public static byte nslice_cb_qp_offset(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_CB_QP_OFFSET);
    }

    public static byte nslice_cr_qp_offset(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_CR_QP_OFFSET);
    }

    public static byte nslice_beta_offset_div2(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_BETA_OFFSET_DIV2);
    }

    public static byte nslice_tc_offset_div2(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_TC_OFFSET_DIV2);
    }

    public static byte nslice_act_y_qp_offset(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_ACT_Y_QP_OFFSET);
    }

    public static byte nslice_act_cb_qp_offset(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_ACT_CB_QP_OFFSET);
    }

    public static byte nslice_act_cr_qp_offset(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_ACT_CR_QP_OFFSET);
    }

    public static byte nslice_qp_delta(long struct) {
        return UNSAFE.getByte(null, struct + (long)SLICE_QP_DELTA);
    }

    public static short nreserved1(long struct) {
        return UNSAFE.getShort(null, struct + (long)RESERVED1);
    }

    public static StdVideoEncodeH265WeightTable npWeightTable(long struct) {
        return StdVideoEncodeH265WeightTable.create(MemoryUtil.memGetAddress(struct + (long)PWEIGHTTABLE));
    }

    public static void nflags(long struct, StdVideoEncodeH265SliceSegmentHeaderFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoEncodeH265SliceSegmentHeaderFlags.SIZEOF);
    }

    public static void nslice_type(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SLICE_TYPE, value);
    }

    public static void nslice_segment_address(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SLICE_SEGMENT_ADDRESS, value);
    }

    public static void ncollocated_ref_idx(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)COLLOCATED_REF_IDX, value);
    }

    public static void nMaxNumMergeCand(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)MAXNUMMERGECAND, value);
    }

    public static void nslice_cb_qp_offset(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_CB_QP_OFFSET, value);
    }

    public static void nslice_cr_qp_offset(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_CR_QP_OFFSET, value);
    }

    public static void nslice_beta_offset_div2(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_BETA_OFFSET_DIV2, value);
    }

    public static void nslice_tc_offset_div2(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_TC_OFFSET_DIV2, value);
    }

    public static void nslice_act_y_qp_offset(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_ACT_Y_QP_OFFSET, value);
    }

    public static void nslice_act_cb_qp_offset(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_ACT_CB_QP_OFFSET, value);
    }

    public static void nslice_act_cr_qp_offset(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_ACT_CR_QP_OFFSET, value);
    }

    public static void nslice_qp_delta(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)SLICE_QP_DELTA, value);
    }

    public static void nreserved1(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)RESERVED1, value);
    }

    public static void npWeightTable(long struct, StdVideoEncodeH265WeightTable value) {
        MemoryUtil.memPutAddress(struct + (long)PWEIGHTTABLE, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PWEIGHTTABLE));
    }

    static {
        Struct.Layout layout = StdVideoEncodeH265SliceSegmentHeader.__struct(StdVideoEncodeH265SliceSegmentHeader.__member(StdVideoEncodeH265SliceSegmentHeaderFlags.SIZEOF, StdVideoEncodeH265SliceSegmentHeaderFlags.ALIGNOF), StdVideoEncodeH265SliceSegmentHeader.__member(4), StdVideoEncodeH265SliceSegmentHeader.__member(4), StdVideoEncodeH265SliceSegmentHeader.__member(1), StdVideoEncodeH265SliceSegmentHeader.__member(1), StdVideoEncodeH265SliceSegmentHeader.__member(1), StdVideoEncodeH265SliceSegmentHeader.__member(1), StdVideoEncodeH265SliceSegmentHeader.__member(1), StdVideoEncodeH265SliceSegmentHeader.__member(1), StdVideoEncodeH265SliceSegmentHeader.__member(1), StdVideoEncodeH265SliceSegmentHeader.__member(1), StdVideoEncodeH265SliceSegmentHeader.__member(1), StdVideoEncodeH265SliceSegmentHeader.__member(1), StdVideoEncodeH265SliceSegmentHeader.__member(2), StdVideoEncodeH265SliceSegmentHeader.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        SLICE_TYPE = layout.offsetof(1);
        SLICE_SEGMENT_ADDRESS = layout.offsetof(2);
        COLLOCATED_REF_IDX = layout.offsetof(3);
        MAXNUMMERGECAND = layout.offsetof(4);
        SLICE_CB_QP_OFFSET = layout.offsetof(5);
        SLICE_CR_QP_OFFSET = layout.offsetof(6);
        SLICE_BETA_OFFSET_DIV2 = layout.offsetof(7);
        SLICE_TC_OFFSET_DIV2 = layout.offsetof(8);
        SLICE_ACT_Y_QP_OFFSET = layout.offsetof(9);
        SLICE_ACT_CB_QP_OFFSET = layout.offsetof(10);
        SLICE_ACT_CR_QP_OFFSET = layout.offsetof(11);
        SLICE_QP_DELTA = layout.offsetof(12);
        RESERVED1 = layout.offsetof(13);
        PWEIGHTTABLE = layout.offsetof(14);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH265SliceSegmentHeader, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH265SliceSegmentHeader ELEMENT_FACTORY = StdVideoEncodeH265SliceSegmentHeader.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoEncodeH265SliceSegmentHeader getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoEncodeH265SliceSegmentHeaderFlags flags() {
            return StdVideoEncodeH265SliceSegmentHeader.nflags(this.address());
        }

        @NativeType(value="StdVideoH265SliceType")
        public int slice_type() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_type(this.address());
        }

        @NativeType(value="uint32_t")
        public int slice_segment_address() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_segment_address(this.address());
        }

        @NativeType(value="uint8_t")
        public byte collocated_ref_idx() {
            return StdVideoEncodeH265SliceSegmentHeader.ncollocated_ref_idx(this.address());
        }

        @NativeType(value="uint8_t")
        public byte MaxNumMergeCand() {
            return StdVideoEncodeH265SliceSegmentHeader.nMaxNumMergeCand(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_cb_qp_offset() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_cb_qp_offset(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_cr_qp_offset() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_cr_qp_offset(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_beta_offset_div2() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_beta_offset_div2(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_tc_offset_div2() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_tc_offset_div2(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_act_y_qp_offset() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_act_y_qp_offset(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_act_cb_qp_offset() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_act_cb_qp_offset(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_act_cr_qp_offset() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_act_cr_qp_offset(this.address());
        }

        @NativeType(value="int8_t")
        public byte slice_qp_delta() {
            return StdVideoEncodeH265SliceSegmentHeader.nslice_qp_delta(this.address());
        }

        @NativeType(value="StdVideoEncodeH265WeightTable const *")
        public StdVideoEncodeH265WeightTable pWeightTable() {
            return StdVideoEncodeH265SliceSegmentHeader.npWeightTable(this.address());
        }

        public Buffer flags(StdVideoEncodeH265SliceSegmentHeaderFlags value) {
            StdVideoEncodeH265SliceSegmentHeader.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoEncodeH265SliceSegmentHeaderFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer slice_type(@NativeType(value="StdVideoH265SliceType") int value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_type(this.address(), value);
            return this;
        }

        public Buffer slice_segment_address(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_segment_address(this.address(), value);
            return this;
        }

        public Buffer collocated_ref_idx(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.ncollocated_ref_idx(this.address(), value);
            return this;
        }

        public Buffer MaxNumMergeCand(@NativeType(value="uint8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nMaxNumMergeCand(this.address(), value);
            return this;
        }

        public Buffer slice_cb_qp_offset(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_cb_qp_offset(this.address(), value);
            return this;
        }

        public Buffer slice_cr_qp_offset(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_cr_qp_offset(this.address(), value);
            return this;
        }

        public Buffer slice_beta_offset_div2(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_beta_offset_div2(this.address(), value);
            return this;
        }

        public Buffer slice_tc_offset_div2(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_tc_offset_div2(this.address(), value);
            return this;
        }

        public Buffer slice_act_y_qp_offset(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_act_y_qp_offset(this.address(), value);
            return this;
        }

        public Buffer slice_act_cb_qp_offset(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_act_cb_qp_offset(this.address(), value);
            return this;
        }

        public Buffer slice_act_cr_qp_offset(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_act_cr_qp_offset(this.address(), value);
            return this;
        }

        public Buffer slice_qp_delta(@NativeType(value="int8_t") byte value) {
            StdVideoEncodeH265SliceSegmentHeader.nslice_qp_delta(this.address(), value);
            return this;
        }

        public Buffer pWeightTable(@NativeType(value="StdVideoEncodeH265WeightTable const *") StdVideoEncodeH265WeightTable value) {
            StdVideoEncodeH265SliceSegmentHeader.npWeightTable(this.address(), value);
            return this;
        }
    }
}

