/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class StdVideoEncodeH264WeightTableFlags
extends Struct<StdVideoEncodeH264WeightTableFlags>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int LUMA_WEIGHT_L0_FLAG;
    public static final int CHROMA_WEIGHT_L0_FLAG;
    public static final int LUMA_WEIGHT_L1_FLAG;
    public static final int CHROMA_WEIGHT_L1_FLAG;

    protected StdVideoEncodeH264WeightTableFlags(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected StdVideoEncodeH264WeightTableFlags create(long address, @Nullable ByteBuffer container) {
        return new StdVideoEncodeH264WeightTableFlags(address, container);
    }

    public StdVideoEncodeH264WeightTableFlags(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoEncodeH264WeightTableFlags.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int luma_weight_l0_flag() {
        return StdVideoEncodeH264WeightTableFlags.nluma_weight_l0_flag(this.address());
    }

    @NativeType(value="uint32_t")
    public int chroma_weight_l0_flag() {
        return StdVideoEncodeH264WeightTableFlags.nchroma_weight_l0_flag(this.address());
    }

    @NativeType(value="uint32_t")
    public int luma_weight_l1_flag() {
        return StdVideoEncodeH264WeightTableFlags.nluma_weight_l1_flag(this.address());
    }

    @NativeType(value="uint32_t")
    public int chroma_weight_l1_flag() {
        return StdVideoEncodeH264WeightTableFlags.nchroma_weight_l1_flag(this.address());
    }

    public StdVideoEncodeH264WeightTableFlags luma_weight_l0_flag(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeH264WeightTableFlags.nluma_weight_l0_flag(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264WeightTableFlags chroma_weight_l0_flag(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeH264WeightTableFlags.nchroma_weight_l0_flag(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264WeightTableFlags luma_weight_l1_flag(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeH264WeightTableFlags.nluma_weight_l1_flag(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264WeightTableFlags chroma_weight_l1_flag(@NativeType(value="uint32_t") int value) {
        StdVideoEncodeH264WeightTableFlags.nchroma_weight_l1_flag(this.address(), value);
        return this;
    }

    public StdVideoEncodeH264WeightTableFlags set(int luma_weight_l0_flag, int chroma_weight_l0_flag, int luma_weight_l1_flag, int chroma_weight_l1_flag) {
        this.luma_weight_l0_flag(luma_weight_l0_flag);
        this.chroma_weight_l0_flag(chroma_weight_l0_flag);
        this.luma_weight_l1_flag(luma_weight_l1_flag);
        this.chroma_weight_l1_flag(chroma_weight_l1_flag);
        return this;
    }

    public StdVideoEncodeH264WeightTableFlags set(StdVideoEncodeH264WeightTableFlags src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoEncodeH264WeightTableFlags malloc() {
        return new StdVideoEncodeH264WeightTableFlags(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StdVideoEncodeH264WeightTableFlags calloc() {
        return new StdVideoEncodeH264WeightTableFlags(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StdVideoEncodeH264WeightTableFlags create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new StdVideoEncodeH264WeightTableFlags(MemoryUtil.memAddress(container), container);
    }

    public static StdVideoEncodeH264WeightTableFlags create(long address) {
        return new StdVideoEncodeH264WeightTableFlags(address, null);
    }

    @Nullable
    public static StdVideoEncodeH264WeightTableFlags createSafe(long address) {
        return address == 0L ? null : new StdVideoEncodeH264WeightTableFlags(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StdVideoEncodeH264WeightTableFlags.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoEncodeH264WeightTableFlags.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoEncodeH264WeightTableFlags malloc(MemoryStack stack) {
        return new StdVideoEncodeH264WeightTableFlags(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoEncodeH264WeightTableFlags calloc(MemoryStack stack) {
        return new StdVideoEncodeH264WeightTableFlags(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nluma_weight_l0_flag(long struct) {
        return UNSAFE.getInt(null, struct + (long)LUMA_WEIGHT_L0_FLAG);
    }

    public static int nchroma_weight_l0_flag(long struct) {
        return UNSAFE.getInt(null, struct + (long)CHROMA_WEIGHT_L0_FLAG);
    }

    public static int nluma_weight_l1_flag(long struct) {
        return UNSAFE.getInt(null, struct + (long)LUMA_WEIGHT_L1_FLAG);
    }

    public static int nchroma_weight_l1_flag(long struct) {
        return UNSAFE.getInt(null, struct + (long)CHROMA_WEIGHT_L1_FLAG);
    }

    public static void nluma_weight_l0_flag(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LUMA_WEIGHT_L0_FLAG, value);
    }

    public static void nchroma_weight_l0_flag(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CHROMA_WEIGHT_L0_FLAG, value);
    }

    public static void nluma_weight_l1_flag(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LUMA_WEIGHT_L1_FLAG, value);
    }

    public static void nchroma_weight_l1_flag(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CHROMA_WEIGHT_L1_FLAG, value);
    }

    static {
        Struct.Layout layout = StdVideoEncodeH264WeightTableFlags.__struct(StdVideoEncodeH264WeightTableFlags.__member(4), StdVideoEncodeH264WeightTableFlags.__member(4), StdVideoEncodeH264WeightTableFlags.__member(4), StdVideoEncodeH264WeightTableFlags.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        LUMA_WEIGHT_L0_FLAG = layout.offsetof(0);
        CHROMA_WEIGHT_L0_FLAG = layout.offsetof(1);
        LUMA_WEIGHT_L1_FLAG = layout.offsetof(2);
        CHROMA_WEIGHT_L1_FLAG = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<StdVideoEncodeH264WeightTableFlags, Buffer>
    implements NativeResource {
        private static final StdVideoEncodeH264WeightTableFlags ELEMENT_FACTORY = StdVideoEncodeH264WeightTableFlags.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoEncodeH264WeightTableFlags getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int luma_weight_l0_flag() {
            return StdVideoEncodeH264WeightTableFlags.nluma_weight_l0_flag(this.address());
        }

        @NativeType(value="uint32_t")
        public int chroma_weight_l0_flag() {
            return StdVideoEncodeH264WeightTableFlags.nchroma_weight_l0_flag(this.address());
        }

        @NativeType(value="uint32_t")
        public int luma_weight_l1_flag() {
            return StdVideoEncodeH264WeightTableFlags.nluma_weight_l1_flag(this.address());
        }

        @NativeType(value="uint32_t")
        public int chroma_weight_l1_flag() {
            return StdVideoEncodeH264WeightTableFlags.nchroma_weight_l1_flag(this.address());
        }

        public Buffer luma_weight_l0_flag(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeH264WeightTableFlags.nluma_weight_l0_flag(this.address(), value);
            return this;
        }

        public Buffer chroma_weight_l0_flag(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeH264WeightTableFlags.nchroma_weight_l0_flag(this.address(), value);
            return this;
        }

        public Buffer luma_weight_l1_flag(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeH264WeightTableFlags.nluma_weight_l1_flag(this.address(), value);
            return this;
        }

        public Buffer chroma_weight_l1_flag(@NativeType(value="uint32_t") int value) {
            StdVideoEncodeH264WeightTableFlags.nchroma_weight_l1_flag(this.address(), value);
            return this;
        }
    }
}

