/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan.video;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.video.StdVideoAV1CDEF;
import org.lwjgl.vulkan.video.StdVideoAV1FilmGrain;
import org.lwjgl.vulkan.video.StdVideoAV1GlobalMotion;
import org.lwjgl.vulkan.video.StdVideoAV1LoopFilter;
import org.lwjgl.vulkan.video.StdVideoAV1LoopRestoration;
import org.lwjgl.vulkan.video.StdVideoAV1Quantization;
import org.lwjgl.vulkan.video.StdVideoAV1Segmentation;
import org.lwjgl.vulkan.video.StdVideoAV1TileInfo;
import org.lwjgl.vulkan.video.StdVideoDecodeAV1PictureInfoFlags;

public class StdVideoDecodeAV1PictureInfo
extends Struct<StdVideoDecodeAV1PictureInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int FLAGS;
    public static final int FRAME_TYPE;
    public static final int CURRENT_FRAME_ID;
    public static final int ORDERHINT;
    public static final int PRIMARY_REF_FRAME;
    public static final int REFRESH_FRAME_FLAGS;
    public static final int RESERVED1;
    public static final int INTERPOLATION_FILTER;
    public static final int TXMODE;
    public static final int DELTA_Q_RES;
    public static final int DELTA_LF_RES;
    public static final int SKIPMODEFRAME;
    public static final int CODED_DENOM;
    public static final int RESERVED2;
    public static final int ORDERHINTS;
    public static final int EXPECTEDFRAMEID;
    public static final int PTILEINFO;
    public static final int PQUANTIZATION;
    public static final int PSEGMENTATION;
    public static final int PLOOPFILTER;
    public static final int PCDEF;
    public static final int PLOOPRESTORATION;
    public static final int PGLOBALMOTION;
    public static final int PFILMGRAIN;

    protected StdVideoDecodeAV1PictureInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected StdVideoDecodeAV1PictureInfo create(long address, @Nullable ByteBuffer container) {
        return new StdVideoDecodeAV1PictureInfo(address, container);
    }

    public StdVideoDecodeAV1PictureInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), StdVideoDecodeAV1PictureInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public StdVideoDecodeAV1PictureInfoFlags flags() {
        return StdVideoDecodeAV1PictureInfo.nflags(this.address());
    }

    @NativeType(value="StdVideoAV1FrameType")
    public int frame_type() {
        return StdVideoDecodeAV1PictureInfo.nframe_type(this.address());
    }

    @NativeType(value="uint32_t")
    public int current_frame_id() {
        return StdVideoDecodeAV1PictureInfo.ncurrent_frame_id(this.address());
    }

    @NativeType(value="uint8_t")
    public byte OrderHint() {
        return StdVideoDecodeAV1PictureInfo.nOrderHint(this.address());
    }

    @NativeType(value="uint8_t")
    public byte primary_ref_frame() {
        return StdVideoDecodeAV1PictureInfo.nprimary_ref_frame(this.address());
    }

    @NativeType(value="uint8_t")
    public byte refresh_frame_flags() {
        return StdVideoDecodeAV1PictureInfo.nrefresh_frame_flags(this.address());
    }

    @NativeType(value="StdVideoAV1InterpolationFilter")
    public int interpolation_filter() {
        return StdVideoDecodeAV1PictureInfo.ninterpolation_filter(this.address());
    }

    @NativeType(value="StdVideoAV1TxMode")
    public int TxMode() {
        return StdVideoDecodeAV1PictureInfo.nTxMode(this.address());
    }

    @NativeType(value="uint8_t")
    public byte delta_q_res() {
        return StdVideoDecodeAV1PictureInfo.ndelta_q_res(this.address());
    }

    @NativeType(value="uint8_t")
    public byte delta_lf_res() {
        return StdVideoDecodeAV1PictureInfo.ndelta_lf_res(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_AV1_SKIP_MODE_FRAMES]")
    public ByteBuffer SkipModeFrame() {
        return StdVideoDecodeAV1PictureInfo.nSkipModeFrame(this.address());
    }

    @NativeType(value="uint8_t")
    public byte SkipModeFrame(int index) {
        return StdVideoDecodeAV1PictureInfo.nSkipModeFrame(this.address(), index);
    }

    @NativeType(value="uint8_t")
    public byte coded_denom() {
        return StdVideoDecodeAV1PictureInfo.ncoded_denom(this.address());
    }

    @NativeType(value="uint8_t[STD_VIDEO_AV1_NUM_REF_FRAMES]")
    public ByteBuffer OrderHints() {
        return StdVideoDecodeAV1PictureInfo.nOrderHints(this.address());
    }

    @NativeType(value="uint8_t")
    public byte OrderHints(int index) {
        return StdVideoDecodeAV1PictureInfo.nOrderHints(this.address(), index);
    }

    @NativeType(value="uint32_t[STD_VIDEO_AV1_NUM_REF_FRAMES]")
    public IntBuffer expectedFrameId() {
        return StdVideoDecodeAV1PictureInfo.nexpectedFrameId(this.address());
    }

    @NativeType(value="uint32_t")
    public int expectedFrameId(int index) {
        return StdVideoDecodeAV1PictureInfo.nexpectedFrameId(this.address(), index);
    }

    @NativeType(value="StdVideoAV1TileInfo const *")
    public StdVideoAV1TileInfo pTileInfo() {
        return StdVideoDecodeAV1PictureInfo.npTileInfo(this.address());
    }

    @NativeType(value="StdVideoAV1Quantization const *")
    public StdVideoAV1Quantization pQuantization() {
        return StdVideoDecodeAV1PictureInfo.npQuantization(this.address());
    }

    @NativeType(value="StdVideoAV1Segmentation const *")
    public StdVideoAV1Segmentation pSegmentation() {
        return StdVideoDecodeAV1PictureInfo.npSegmentation(this.address());
    }

    @NativeType(value="StdVideoAV1LoopFilter const *")
    public StdVideoAV1LoopFilter pLoopFilter() {
        return StdVideoDecodeAV1PictureInfo.npLoopFilter(this.address());
    }

    @NativeType(value="StdVideoAV1CDEF const *")
    public StdVideoAV1CDEF pCDEF() {
        return StdVideoDecodeAV1PictureInfo.npCDEF(this.address());
    }

    @NativeType(value="StdVideoAV1LoopRestoration const *")
    public StdVideoAV1LoopRestoration pLoopRestoration() {
        return StdVideoDecodeAV1PictureInfo.npLoopRestoration(this.address());
    }

    @NativeType(value="StdVideoAV1GlobalMotion const *")
    public StdVideoAV1GlobalMotion pGlobalMotion() {
        return StdVideoDecodeAV1PictureInfo.npGlobalMotion(this.address());
    }

    @NativeType(value="StdVideoAV1FilmGrain const *")
    public StdVideoAV1FilmGrain pFilmGrain() {
        return StdVideoDecodeAV1PictureInfo.npFilmGrain(this.address());
    }

    public StdVideoDecodeAV1PictureInfo flags(StdVideoDecodeAV1PictureInfoFlags value) {
        StdVideoDecodeAV1PictureInfo.nflags(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo flags(Consumer<StdVideoDecodeAV1PictureInfoFlags> consumer) {
        consumer.accept(this.flags());
        return this;
    }

    public StdVideoDecodeAV1PictureInfo frame_type(@NativeType(value="StdVideoAV1FrameType") int value) {
        StdVideoDecodeAV1PictureInfo.nframe_type(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo current_frame_id(@NativeType(value="uint32_t") int value) {
        StdVideoDecodeAV1PictureInfo.ncurrent_frame_id(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo OrderHint(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeAV1PictureInfo.nOrderHint(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo primary_ref_frame(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeAV1PictureInfo.nprimary_ref_frame(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo refresh_frame_flags(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeAV1PictureInfo.nrefresh_frame_flags(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo interpolation_filter(@NativeType(value="StdVideoAV1InterpolationFilter") int value) {
        StdVideoDecodeAV1PictureInfo.ninterpolation_filter(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo TxMode(@NativeType(value="StdVideoAV1TxMode") int value) {
        StdVideoDecodeAV1PictureInfo.nTxMode(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo delta_q_res(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeAV1PictureInfo.ndelta_q_res(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo delta_lf_res(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeAV1PictureInfo.ndelta_lf_res(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo SkipModeFrame(@NativeType(value="uint8_t[STD_VIDEO_AV1_SKIP_MODE_FRAMES]") ByteBuffer value) {
        StdVideoDecodeAV1PictureInfo.nSkipModeFrame(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo SkipModeFrame(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoDecodeAV1PictureInfo.nSkipModeFrame(this.address(), index, value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo coded_denom(@NativeType(value="uint8_t") byte value) {
        StdVideoDecodeAV1PictureInfo.ncoded_denom(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo OrderHints(@NativeType(value="uint8_t[STD_VIDEO_AV1_NUM_REF_FRAMES]") ByteBuffer value) {
        StdVideoDecodeAV1PictureInfo.nOrderHints(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo OrderHints(int index, @NativeType(value="uint8_t") byte value) {
        StdVideoDecodeAV1PictureInfo.nOrderHints(this.address(), index, value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo expectedFrameId(@NativeType(value="uint32_t[STD_VIDEO_AV1_NUM_REF_FRAMES]") IntBuffer value) {
        StdVideoDecodeAV1PictureInfo.nexpectedFrameId(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo expectedFrameId(int index, @NativeType(value="uint32_t") int value) {
        StdVideoDecodeAV1PictureInfo.nexpectedFrameId(this.address(), index, value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo pTileInfo(@NativeType(value="StdVideoAV1TileInfo const *") StdVideoAV1TileInfo value) {
        StdVideoDecodeAV1PictureInfo.npTileInfo(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo pQuantization(@NativeType(value="StdVideoAV1Quantization const *") StdVideoAV1Quantization value) {
        StdVideoDecodeAV1PictureInfo.npQuantization(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo pSegmentation(@NativeType(value="StdVideoAV1Segmentation const *") StdVideoAV1Segmentation value) {
        StdVideoDecodeAV1PictureInfo.npSegmentation(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo pLoopFilter(@NativeType(value="StdVideoAV1LoopFilter const *") StdVideoAV1LoopFilter value) {
        StdVideoDecodeAV1PictureInfo.npLoopFilter(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo pCDEF(@NativeType(value="StdVideoAV1CDEF const *") StdVideoAV1CDEF value) {
        StdVideoDecodeAV1PictureInfo.npCDEF(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo pLoopRestoration(@NativeType(value="StdVideoAV1LoopRestoration const *") StdVideoAV1LoopRestoration value) {
        StdVideoDecodeAV1PictureInfo.npLoopRestoration(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo pGlobalMotion(@NativeType(value="StdVideoAV1GlobalMotion const *") StdVideoAV1GlobalMotion value) {
        StdVideoDecodeAV1PictureInfo.npGlobalMotion(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo pFilmGrain(@NativeType(value="StdVideoAV1FilmGrain const *") StdVideoAV1FilmGrain value) {
        StdVideoDecodeAV1PictureInfo.npFilmGrain(this.address(), value);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo set(StdVideoDecodeAV1PictureInfoFlags flags, int frame_type, int current_frame_id, byte OrderHint, byte primary_ref_frame, byte refresh_frame_flags, int interpolation_filter, int TxMode, byte delta_q_res, byte delta_lf_res, ByteBuffer SkipModeFrame, byte coded_denom, ByteBuffer OrderHints, IntBuffer expectedFrameId, StdVideoAV1TileInfo pTileInfo, StdVideoAV1Quantization pQuantization, StdVideoAV1Segmentation pSegmentation, StdVideoAV1LoopFilter pLoopFilter, StdVideoAV1CDEF pCDEF, StdVideoAV1LoopRestoration pLoopRestoration, StdVideoAV1GlobalMotion pGlobalMotion, StdVideoAV1FilmGrain pFilmGrain) {
        this.flags(flags);
        this.frame_type(frame_type);
        this.current_frame_id(current_frame_id);
        this.OrderHint(OrderHint);
        this.primary_ref_frame(primary_ref_frame);
        this.refresh_frame_flags(refresh_frame_flags);
        this.interpolation_filter(interpolation_filter);
        this.TxMode(TxMode);
        this.delta_q_res(delta_q_res);
        this.delta_lf_res(delta_lf_res);
        this.SkipModeFrame(SkipModeFrame);
        this.coded_denom(coded_denom);
        this.OrderHints(OrderHints);
        this.expectedFrameId(expectedFrameId);
        this.pTileInfo(pTileInfo);
        this.pQuantization(pQuantization);
        this.pSegmentation(pSegmentation);
        this.pLoopFilter(pLoopFilter);
        this.pCDEF(pCDEF);
        this.pLoopRestoration(pLoopRestoration);
        this.pGlobalMotion(pGlobalMotion);
        this.pFilmGrain(pFilmGrain);
        return this;
    }

    public StdVideoDecodeAV1PictureInfo set(StdVideoDecodeAV1PictureInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static StdVideoDecodeAV1PictureInfo malloc() {
        return new StdVideoDecodeAV1PictureInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static StdVideoDecodeAV1PictureInfo calloc() {
        return new StdVideoDecodeAV1PictureInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static StdVideoDecodeAV1PictureInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new StdVideoDecodeAV1PictureInfo(MemoryUtil.memAddress(container), container);
    }

    public static StdVideoDecodeAV1PictureInfo create(long address) {
        return new StdVideoDecodeAV1PictureInfo(address, null);
    }

    @Nullable
    public static StdVideoDecodeAV1PictureInfo createSafe(long address) {
        return address == 0L ? null : new StdVideoDecodeAV1PictureInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(StdVideoDecodeAV1PictureInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = StdVideoDecodeAV1PictureInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static StdVideoDecodeAV1PictureInfo malloc(MemoryStack stack) {
        return new StdVideoDecodeAV1PictureInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static StdVideoDecodeAV1PictureInfo calloc(MemoryStack stack) {
        return new StdVideoDecodeAV1PictureInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static StdVideoDecodeAV1PictureInfoFlags nflags(long struct) {
        return StdVideoDecodeAV1PictureInfoFlags.create(struct + (long)FLAGS);
    }

    public static int nframe_type(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAME_TYPE);
    }

    public static int ncurrent_frame_id(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURRENT_FRAME_ID);
    }

    public static byte nOrderHint(long struct) {
        return UNSAFE.getByte(null, struct + (long)ORDERHINT);
    }

    public static byte nprimary_ref_frame(long struct) {
        return UNSAFE.getByte(null, struct + (long)PRIMARY_REF_FRAME);
    }

    public static byte nrefresh_frame_flags(long struct) {
        return UNSAFE.getByte(null, struct + (long)REFRESH_FRAME_FLAGS);
    }

    public static byte nreserved1(long struct) {
        return UNSAFE.getByte(null, struct + (long)RESERVED1);
    }

    public static int ninterpolation_filter(long struct) {
        return UNSAFE.getInt(null, struct + (long)INTERPOLATION_FILTER);
    }

    public static int nTxMode(long struct) {
        return UNSAFE.getInt(null, struct + (long)TXMODE);
    }

    public static byte ndelta_q_res(long struct) {
        return UNSAFE.getByte(null, struct + (long)DELTA_Q_RES);
    }

    public static byte ndelta_lf_res(long struct) {
        return UNSAFE.getByte(null, struct + (long)DELTA_LF_RES);
    }

    public static ByteBuffer nSkipModeFrame(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)SKIPMODEFRAME, 2);
    }

    public static byte nSkipModeFrame(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)SKIPMODEFRAME + Checks.check(index, 2) * 1L);
    }

    public static byte ncoded_denom(long struct) {
        return UNSAFE.getByte(null, struct + (long)CODED_DENOM);
    }

    public static ByteBuffer nreserved2(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)RESERVED2, 3);
    }

    public static byte nreserved2(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)RESERVED2 + Checks.check(index, 3) * 1L);
    }

    public static ByteBuffer nOrderHints(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)ORDERHINTS, 8);
    }

    public static byte nOrderHints(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)ORDERHINTS + Checks.check(index, 8) * 1L);
    }

    public static IntBuffer nexpectedFrameId(long struct) {
        return MemoryUtil.memIntBuffer(struct + (long)EXPECTEDFRAMEID, 8);
    }

    public static int nexpectedFrameId(long struct, int index) {
        return UNSAFE.getInt(null, struct + (long)EXPECTEDFRAMEID + Checks.check(index, 8) * 4L);
    }

    public static StdVideoAV1TileInfo npTileInfo(long struct) {
        return StdVideoAV1TileInfo.create(MemoryUtil.memGetAddress(struct + (long)PTILEINFO));
    }

    public static StdVideoAV1Quantization npQuantization(long struct) {
        return StdVideoAV1Quantization.create(MemoryUtil.memGetAddress(struct + (long)PQUANTIZATION));
    }

    public static StdVideoAV1Segmentation npSegmentation(long struct) {
        return StdVideoAV1Segmentation.create(MemoryUtil.memGetAddress(struct + (long)PSEGMENTATION));
    }

    public static StdVideoAV1LoopFilter npLoopFilter(long struct) {
        return StdVideoAV1LoopFilter.create(MemoryUtil.memGetAddress(struct + (long)PLOOPFILTER));
    }

    public static StdVideoAV1CDEF npCDEF(long struct) {
        return StdVideoAV1CDEF.create(MemoryUtil.memGetAddress(struct + (long)PCDEF));
    }

    public static StdVideoAV1LoopRestoration npLoopRestoration(long struct) {
        return StdVideoAV1LoopRestoration.create(MemoryUtil.memGetAddress(struct + (long)PLOOPRESTORATION));
    }

    public static StdVideoAV1GlobalMotion npGlobalMotion(long struct) {
        return StdVideoAV1GlobalMotion.create(MemoryUtil.memGetAddress(struct + (long)PGLOBALMOTION));
    }

    public static StdVideoAV1FilmGrain npFilmGrain(long struct) {
        return StdVideoAV1FilmGrain.create(MemoryUtil.memGetAddress(struct + (long)PFILMGRAIN));
    }

    public static void nflags(long struct, StdVideoDecodeAV1PictureInfoFlags value) {
        MemoryUtil.memCopy(value.address(), struct + (long)FLAGS, StdVideoDecodeAV1PictureInfoFlags.SIZEOF);
    }

    public static void nframe_type(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAME_TYPE, value);
    }

    public static void ncurrent_frame_id(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)CURRENT_FRAME_ID, value);
    }

    public static void nOrderHint(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)ORDERHINT, value);
    }

    public static void nprimary_ref_frame(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)PRIMARY_REF_FRAME, value);
    }

    public static void nrefresh_frame_flags(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)REFRESH_FRAME_FLAGS, value);
    }

    public static void nreserved1(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED1, value);
    }

    public static void ninterpolation_filter(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INTERPOLATION_FILTER, value);
    }

    public static void nTxMode(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TXMODE, value);
    }

    public static void ndelta_q_res(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)DELTA_Q_RES, value);
    }

    public static void ndelta_lf_res(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)DELTA_LF_RES, value);
    }

    public static void nSkipModeFrame(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 2);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)SKIPMODEFRAME, value.remaining() * 1);
    }

    public static void nSkipModeFrame(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)SKIPMODEFRAME + Checks.check(index, 2) * 1L, value);
    }

    public static void ncoded_denom(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)CODED_DENOM, value);
    }

    public static void nreserved2(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 3);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)RESERVED2, value.remaining() * 1);
    }

    public static void nreserved2(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)RESERVED2 + Checks.check(index, 3) * 1L, value);
    }

    public static void nOrderHints(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 8);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)ORDERHINTS, value.remaining() * 1);
    }

    public static void nOrderHints(long struct, int index, byte value) {
        UNSAFE.putByte(null, struct + (long)ORDERHINTS + Checks.check(index, 8) * 1L, value);
    }

    public static void nexpectedFrameId(long struct, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT(value, 8);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)EXPECTEDFRAMEID, value.remaining() * 4);
    }

    public static void nexpectedFrameId(long struct, int index, int value) {
        UNSAFE.putInt(null, struct + (long)EXPECTEDFRAMEID + Checks.check(index, 8) * 4L, value);
    }

    public static void npTileInfo(long struct, StdVideoAV1TileInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PTILEINFO, value.address());
    }

    public static void npQuantization(long struct, StdVideoAV1Quantization value) {
        MemoryUtil.memPutAddress(struct + (long)PQUANTIZATION, value.address());
    }

    public static void npSegmentation(long struct, StdVideoAV1Segmentation value) {
        MemoryUtil.memPutAddress(struct + (long)PSEGMENTATION, value.address());
    }

    public static void npLoopFilter(long struct, StdVideoAV1LoopFilter value) {
        MemoryUtil.memPutAddress(struct + (long)PLOOPFILTER, value.address());
    }

    public static void npCDEF(long struct, StdVideoAV1CDEF value) {
        MemoryUtil.memPutAddress(struct + (long)PCDEF, value.address());
    }

    public static void npLoopRestoration(long struct, StdVideoAV1LoopRestoration value) {
        MemoryUtil.memPutAddress(struct + (long)PLOOPRESTORATION, value.address());
    }

    public static void npGlobalMotion(long struct, StdVideoAV1GlobalMotion value) {
        MemoryUtil.memPutAddress(struct + (long)PGLOBALMOTION, value.address());
    }

    public static void npFilmGrain(long struct, StdVideoAV1FilmGrain value) {
        MemoryUtil.memPutAddress(struct + (long)PFILMGRAIN, value.address());
    }

    public static void validate(long struct) {
        long pTileInfo = MemoryUtil.memGetAddress(struct + (long)PTILEINFO);
        Checks.check(pTileInfo);
        StdVideoAV1TileInfo.validate(pTileInfo);
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PQUANTIZATION));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSEGMENTATION));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PLOOPFILTER));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PCDEF));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PLOOPRESTORATION));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PGLOBALMOTION));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PFILMGRAIN));
    }

    static {
        Struct.Layout layout = StdVideoDecodeAV1PictureInfo.__struct(StdVideoDecodeAV1PictureInfo.__member(StdVideoDecodeAV1PictureInfoFlags.SIZEOF, StdVideoDecodeAV1PictureInfoFlags.ALIGNOF), StdVideoDecodeAV1PictureInfo.__member(4), StdVideoDecodeAV1PictureInfo.__member(4), StdVideoDecodeAV1PictureInfo.__member(1), StdVideoDecodeAV1PictureInfo.__member(1), StdVideoDecodeAV1PictureInfo.__member(1), StdVideoDecodeAV1PictureInfo.__member(1), StdVideoDecodeAV1PictureInfo.__member(4), StdVideoDecodeAV1PictureInfo.__member(4), StdVideoDecodeAV1PictureInfo.__member(1), StdVideoDecodeAV1PictureInfo.__member(1), StdVideoDecodeAV1PictureInfo.__array(1, 2), StdVideoDecodeAV1PictureInfo.__member(1), StdVideoDecodeAV1PictureInfo.__array(1, 3), StdVideoDecodeAV1PictureInfo.__array(1, 8), StdVideoDecodeAV1PictureInfo.__array(4, 8), StdVideoDecodeAV1PictureInfo.__member(POINTER_SIZE), StdVideoDecodeAV1PictureInfo.__member(POINTER_SIZE), StdVideoDecodeAV1PictureInfo.__member(POINTER_SIZE), StdVideoDecodeAV1PictureInfo.__member(POINTER_SIZE), StdVideoDecodeAV1PictureInfo.__member(POINTER_SIZE), StdVideoDecodeAV1PictureInfo.__member(POINTER_SIZE), StdVideoDecodeAV1PictureInfo.__member(POINTER_SIZE), StdVideoDecodeAV1PictureInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        FLAGS = layout.offsetof(0);
        FRAME_TYPE = layout.offsetof(1);
        CURRENT_FRAME_ID = layout.offsetof(2);
        ORDERHINT = layout.offsetof(3);
        PRIMARY_REF_FRAME = layout.offsetof(4);
        REFRESH_FRAME_FLAGS = layout.offsetof(5);
        RESERVED1 = layout.offsetof(6);
        INTERPOLATION_FILTER = layout.offsetof(7);
        TXMODE = layout.offsetof(8);
        DELTA_Q_RES = layout.offsetof(9);
        DELTA_LF_RES = layout.offsetof(10);
        SKIPMODEFRAME = layout.offsetof(11);
        CODED_DENOM = layout.offsetof(12);
        RESERVED2 = layout.offsetof(13);
        ORDERHINTS = layout.offsetof(14);
        EXPECTEDFRAMEID = layout.offsetof(15);
        PTILEINFO = layout.offsetof(16);
        PQUANTIZATION = layout.offsetof(17);
        PSEGMENTATION = layout.offsetof(18);
        PLOOPFILTER = layout.offsetof(19);
        PCDEF = layout.offsetof(20);
        PLOOPRESTORATION = layout.offsetof(21);
        PGLOBALMOTION = layout.offsetof(22);
        PFILMGRAIN = layout.offsetof(23);
    }

    public static class Buffer
    extends StructBuffer<StdVideoDecodeAV1PictureInfo, Buffer>
    implements NativeResource {
        private static final StdVideoDecodeAV1PictureInfo ELEMENT_FACTORY = StdVideoDecodeAV1PictureInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected StdVideoDecodeAV1PictureInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public StdVideoDecodeAV1PictureInfoFlags flags() {
            return StdVideoDecodeAV1PictureInfo.nflags(this.address());
        }

        @NativeType(value="StdVideoAV1FrameType")
        public int frame_type() {
            return StdVideoDecodeAV1PictureInfo.nframe_type(this.address());
        }

        @NativeType(value="uint32_t")
        public int current_frame_id() {
            return StdVideoDecodeAV1PictureInfo.ncurrent_frame_id(this.address());
        }

        @NativeType(value="uint8_t")
        public byte OrderHint() {
            return StdVideoDecodeAV1PictureInfo.nOrderHint(this.address());
        }

        @NativeType(value="uint8_t")
        public byte primary_ref_frame() {
            return StdVideoDecodeAV1PictureInfo.nprimary_ref_frame(this.address());
        }

        @NativeType(value="uint8_t")
        public byte refresh_frame_flags() {
            return StdVideoDecodeAV1PictureInfo.nrefresh_frame_flags(this.address());
        }

        @NativeType(value="StdVideoAV1InterpolationFilter")
        public int interpolation_filter() {
            return StdVideoDecodeAV1PictureInfo.ninterpolation_filter(this.address());
        }

        @NativeType(value="StdVideoAV1TxMode")
        public int TxMode() {
            return StdVideoDecodeAV1PictureInfo.nTxMode(this.address());
        }

        @NativeType(value="uint8_t")
        public byte delta_q_res() {
            return StdVideoDecodeAV1PictureInfo.ndelta_q_res(this.address());
        }

        @NativeType(value="uint8_t")
        public byte delta_lf_res() {
            return StdVideoDecodeAV1PictureInfo.ndelta_lf_res(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_AV1_SKIP_MODE_FRAMES]")
        public ByteBuffer SkipModeFrame() {
            return StdVideoDecodeAV1PictureInfo.nSkipModeFrame(this.address());
        }

        @NativeType(value="uint8_t")
        public byte SkipModeFrame(int index) {
            return StdVideoDecodeAV1PictureInfo.nSkipModeFrame(this.address(), index);
        }

        @NativeType(value="uint8_t")
        public byte coded_denom() {
            return StdVideoDecodeAV1PictureInfo.ncoded_denom(this.address());
        }

        @NativeType(value="uint8_t[STD_VIDEO_AV1_NUM_REF_FRAMES]")
        public ByteBuffer OrderHints() {
            return StdVideoDecodeAV1PictureInfo.nOrderHints(this.address());
        }

        @NativeType(value="uint8_t")
        public byte OrderHints(int index) {
            return StdVideoDecodeAV1PictureInfo.nOrderHints(this.address(), index);
        }

        @NativeType(value="uint32_t[STD_VIDEO_AV1_NUM_REF_FRAMES]")
        public IntBuffer expectedFrameId() {
            return StdVideoDecodeAV1PictureInfo.nexpectedFrameId(this.address());
        }

        @NativeType(value="uint32_t")
        public int expectedFrameId(int index) {
            return StdVideoDecodeAV1PictureInfo.nexpectedFrameId(this.address(), index);
        }

        @NativeType(value="StdVideoAV1TileInfo const *")
        public StdVideoAV1TileInfo pTileInfo() {
            return StdVideoDecodeAV1PictureInfo.npTileInfo(this.address());
        }

        @NativeType(value="StdVideoAV1Quantization const *")
        public StdVideoAV1Quantization pQuantization() {
            return StdVideoDecodeAV1PictureInfo.npQuantization(this.address());
        }

        @NativeType(value="StdVideoAV1Segmentation const *")
        public StdVideoAV1Segmentation pSegmentation() {
            return StdVideoDecodeAV1PictureInfo.npSegmentation(this.address());
        }

        @NativeType(value="StdVideoAV1LoopFilter const *")
        public StdVideoAV1LoopFilter pLoopFilter() {
            return StdVideoDecodeAV1PictureInfo.npLoopFilter(this.address());
        }

        @NativeType(value="StdVideoAV1CDEF const *")
        public StdVideoAV1CDEF pCDEF() {
            return StdVideoDecodeAV1PictureInfo.npCDEF(this.address());
        }

        @NativeType(value="StdVideoAV1LoopRestoration const *")
        public StdVideoAV1LoopRestoration pLoopRestoration() {
            return StdVideoDecodeAV1PictureInfo.npLoopRestoration(this.address());
        }

        @NativeType(value="StdVideoAV1GlobalMotion const *")
        public StdVideoAV1GlobalMotion pGlobalMotion() {
            return StdVideoDecodeAV1PictureInfo.npGlobalMotion(this.address());
        }

        @NativeType(value="StdVideoAV1FilmGrain const *")
        public StdVideoAV1FilmGrain pFilmGrain() {
            return StdVideoDecodeAV1PictureInfo.npFilmGrain(this.address());
        }

        public Buffer flags(StdVideoDecodeAV1PictureInfoFlags value) {
            StdVideoDecodeAV1PictureInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer flags(Consumer<StdVideoDecodeAV1PictureInfoFlags> consumer) {
            consumer.accept(this.flags());
            return this;
        }

        public Buffer frame_type(@NativeType(value="StdVideoAV1FrameType") int value) {
            StdVideoDecodeAV1PictureInfo.nframe_type(this.address(), value);
            return this;
        }

        public Buffer current_frame_id(@NativeType(value="uint32_t") int value) {
            StdVideoDecodeAV1PictureInfo.ncurrent_frame_id(this.address(), value);
            return this;
        }

        public Buffer OrderHint(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeAV1PictureInfo.nOrderHint(this.address(), value);
            return this;
        }

        public Buffer primary_ref_frame(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeAV1PictureInfo.nprimary_ref_frame(this.address(), value);
            return this;
        }

        public Buffer refresh_frame_flags(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeAV1PictureInfo.nrefresh_frame_flags(this.address(), value);
            return this;
        }

        public Buffer interpolation_filter(@NativeType(value="StdVideoAV1InterpolationFilter") int value) {
            StdVideoDecodeAV1PictureInfo.ninterpolation_filter(this.address(), value);
            return this;
        }

        public Buffer TxMode(@NativeType(value="StdVideoAV1TxMode") int value) {
            StdVideoDecodeAV1PictureInfo.nTxMode(this.address(), value);
            return this;
        }

        public Buffer delta_q_res(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeAV1PictureInfo.ndelta_q_res(this.address(), value);
            return this;
        }

        public Buffer delta_lf_res(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeAV1PictureInfo.ndelta_lf_res(this.address(), value);
            return this;
        }

        public Buffer SkipModeFrame(@NativeType(value="uint8_t[STD_VIDEO_AV1_SKIP_MODE_FRAMES]") ByteBuffer value) {
            StdVideoDecodeAV1PictureInfo.nSkipModeFrame(this.address(), value);
            return this;
        }

        public Buffer SkipModeFrame(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoDecodeAV1PictureInfo.nSkipModeFrame(this.address(), index, value);
            return this;
        }

        public Buffer coded_denom(@NativeType(value="uint8_t") byte value) {
            StdVideoDecodeAV1PictureInfo.ncoded_denom(this.address(), value);
            return this;
        }

        public Buffer OrderHints(@NativeType(value="uint8_t[STD_VIDEO_AV1_NUM_REF_FRAMES]") ByteBuffer value) {
            StdVideoDecodeAV1PictureInfo.nOrderHints(this.address(), value);
            return this;
        }

        public Buffer OrderHints(int index, @NativeType(value="uint8_t") byte value) {
            StdVideoDecodeAV1PictureInfo.nOrderHints(this.address(), index, value);
            return this;
        }

        public Buffer expectedFrameId(@NativeType(value="uint32_t[STD_VIDEO_AV1_NUM_REF_FRAMES]") IntBuffer value) {
            StdVideoDecodeAV1PictureInfo.nexpectedFrameId(this.address(), value);
            return this;
        }

        public Buffer expectedFrameId(int index, @NativeType(value="uint32_t") int value) {
            StdVideoDecodeAV1PictureInfo.nexpectedFrameId(this.address(), index, value);
            return this;
        }

        public Buffer pTileInfo(@NativeType(value="StdVideoAV1TileInfo const *") StdVideoAV1TileInfo value) {
            StdVideoDecodeAV1PictureInfo.npTileInfo(this.address(), value);
            return this;
        }

        public Buffer pQuantization(@NativeType(value="StdVideoAV1Quantization const *") StdVideoAV1Quantization value) {
            StdVideoDecodeAV1PictureInfo.npQuantization(this.address(), value);
            return this;
        }

        public Buffer pSegmentation(@NativeType(value="StdVideoAV1Segmentation const *") StdVideoAV1Segmentation value) {
            StdVideoDecodeAV1PictureInfo.npSegmentation(this.address(), value);
            return this;
        }

        public Buffer pLoopFilter(@NativeType(value="StdVideoAV1LoopFilter const *") StdVideoAV1LoopFilter value) {
            StdVideoDecodeAV1PictureInfo.npLoopFilter(this.address(), value);
            return this;
        }

        public Buffer pCDEF(@NativeType(value="StdVideoAV1CDEF const *") StdVideoAV1CDEF value) {
            StdVideoDecodeAV1PictureInfo.npCDEF(this.address(), value);
            return this;
        }

        public Buffer pLoopRestoration(@NativeType(value="StdVideoAV1LoopRestoration const *") StdVideoAV1LoopRestoration value) {
            StdVideoDecodeAV1PictureInfo.npLoopRestoration(this.address(), value);
            return this;
        }

        public Buffer pGlobalMotion(@NativeType(value="StdVideoAV1GlobalMotion const *") StdVideoAV1GlobalMotion value) {
            StdVideoDecodeAV1PictureInfo.npGlobalMotion(this.address(), value);
            return this;
        }

        public Buffer pFilmGrain(@NativeType(value="StdVideoAV1FilmGrain const *") StdVideoAV1FilmGrain value) {
            StdVideoDecodeAV1PictureInfo.npFilmGrain(this.address(), value);
            return this;
        }
    }
}

