/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkExtensionProperties;
import org.lwjgl.vulkan.VkExtent2D;
import org.lwjgl.vulkan.VkVideoEncodeH264SessionCreateInfoKHR;
import org.lwjgl.vulkan.VkVideoEncodeH265SessionCreateInfoKHR;
import org.lwjgl.vulkan.VkVideoProfileInfoKHR;

public class VkVideoSessionCreateInfoKHR
extends Struct<VkVideoSessionCreateInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int QUEUEFAMILYINDEX;
    public static final int FLAGS;
    public static final int PVIDEOPROFILE;
    public static final int PICTUREFORMAT;
    public static final int MAXCODEDEXTENT;
    public static final int REFERENCEPICTUREFORMAT;
    public static final int MAXDPBSLOTS;
    public static final int MAXACTIVEREFERENCEPICTURES;
    public static final int PSTDHEADERVERSION;

    protected VkVideoSessionCreateInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkVideoSessionCreateInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkVideoSessionCreateInfoKHR(address, container);
    }

    public VkVideoSessionCreateInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkVideoSessionCreateInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkVideoSessionCreateInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkVideoSessionCreateInfoKHR.npNext(this.address());
    }

    @NativeType(value="uint32_t")
    public int queueFamilyIndex() {
        return VkVideoSessionCreateInfoKHR.nqueueFamilyIndex(this.address());
    }

    @NativeType(value="VkVideoSessionCreateFlagsKHR")
    public int flags() {
        return VkVideoSessionCreateInfoKHR.nflags(this.address());
    }

    @NativeType(value="VkVideoProfileInfoKHR const *")
    public VkVideoProfileInfoKHR pVideoProfile() {
        return VkVideoSessionCreateInfoKHR.npVideoProfile(this.address());
    }

    @NativeType(value="VkFormat")
    public int pictureFormat() {
        return VkVideoSessionCreateInfoKHR.npictureFormat(this.address());
    }

    public VkExtent2D maxCodedExtent() {
        return VkVideoSessionCreateInfoKHR.nmaxCodedExtent(this.address());
    }

    @NativeType(value="VkFormat")
    public int referencePictureFormat() {
        return VkVideoSessionCreateInfoKHR.nreferencePictureFormat(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDpbSlots() {
        return VkVideoSessionCreateInfoKHR.nmaxDpbSlots(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxActiveReferencePictures() {
        return VkVideoSessionCreateInfoKHR.nmaxActiveReferencePictures(this.address());
    }

    @NativeType(value="VkExtensionProperties const *")
    public VkExtensionProperties pStdHeaderVersion() {
        return VkVideoSessionCreateInfoKHR.npStdHeaderVersion(this.address());
    }

    public VkVideoSessionCreateInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkVideoSessionCreateInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR sType$Default() {
        return this.sType(1000023005);
    }

    public VkVideoSessionCreateInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkVideoSessionCreateInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR pNext(VkVideoEncodeH264SessionCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoSessionCreateInfoKHR pNext(VkVideoEncodeH265SessionCreateInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkVideoSessionCreateInfoKHR queueFamilyIndex(@NativeType(value="uint32_t") int value) {
        VkVideoSessionCreateInfoKHR.nqueueFamilyIndex(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR flags(@NativeType(value="VkVideoSessionCreateFlagsKHR") int value) {
        VkVideoSessionCreateInfoKHR.nflags(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR pVideoProfile(@NativeType(value="VkVideoProfileInfoKHR const *") VkVideoProfileInfoKHR value) {
        VkVideoSessionCreateInfoKHR.npVideoProfile(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR pictureFormat(@NativeType(value="VkFormat") int value) {
        VkVideoSessionCreateInfoKHR.npictureFormat(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR maxCodedExtent(VkExtent2D value) {
        VkVideoSessionCreateInfoKHR.nmaxCodedExtent(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR maxCodedExtent(Consumer<VkExtent2D> consumer) {
        consumer.accept(this.maxCodedExtent());
        return this;
    }

    public VkVideoSessionCreateInfoKHR referencePictureFormat(@NativeType(value="VkFormat") int value) {
        VkVideoSessionCreateInfoKHR.nreferencePictureFormat(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR maxDpbSlots(@NativeType(value="uint32_t") int value) {
        VkVideoSessionCreateInfoKHR.nmaxDpbSlots(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR maxActiveReferencePictures(@NativeType(value="uint32_t") int value) {
        VkVideoSessionCreateInfoKHR.nmaxActiveReferencePictures(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR pStdHeaderVersion(@NativeType(value="VkExtensionProperties const *") VkExtensionProperties value) {
        VkVideoSessionCreateInfoKHR.npStdHeaderVersion(this.address(), value);
        return this;
    }

    public VkVideoSessionCreateInfoKHR set(int sType, long pNext, int queueFamilyIndex, int flags, VkVideoProfileInfoKHR pVideoProfile, int pictureFormat, VkExtent2D maxCodedExtent, int referencePictureFormat, int maxDpbSlots, int maxActiveReferencePictures, VkExtensionProperties pStdHeaderVersion) {
        this.sType(sType);
        this.pNext(pNext);
        this.queueFamilyIndex(queueFamilyIndex);
        this.flags(flags);
        this.pVideoProfile(pVideoProfile);
        this.pictureFormat(pictureFormat);
        this.maxCodedExtent(maxCodedExtent);
        this.referencePictureFormat(referencePictureFormat);
        this.maxDpbSlots(maxDpbSlots);
        this.maxActiveReferencePictures(maxActiveReferencePictures);
        this.pStdHeaderVersion(pStdHeaderVersion);
        return this;
    }

    public VkVideoSessionCreateInfoKHR set(VkVideoSessionCreateInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkVideoSessionCreateInfoKHR malloc() {
        return new VkVideoSessionCreateInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkVideoSessionCreateInfoKHR calloc() {
        return new VkVideoSessionCreateInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkVideoSessionCreateInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkVideoSessionCreateInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkVideoSessionCreateInfoKHR create(long address) {
        return new VkVideoSessionCreateInfoKHR(address, null);
    }

    @Nullable
    public static VkVideoSessionCreateInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkVideoSessionCreateInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkVideoSessionCreateInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkVideoSessionCreateInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkVideoSessionCreateInfoKHR malloc(MemoryStack stack) {
        return new VkVideoSessionCreateInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkVideoSessionCreateInfoKHR calloc(MemoryStack stack) {
        return new VkVideoSessionCreateInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nqueueFamilyIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUEUEFAMILYINDEX);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static VkVideoProfileInfoKHR npVideoProfile(long struct) {
        return VkVideoProfileInfoKHR.create(MemoryUtil.memGetAddress(struct + (long)PVIDEOPROFILE));
    }

    public static int npictureFormat(long struct) {
        return UNSAFE.getInt(null, struct + (long)PICTUREFORMAT);
    }

    public static VkExtent2D nmaxCodedExtent(long struct) {
        return VkExtent2D.create(struct + (long)MAXCODEDEXTENT);
    }

    public static int nreferencePictureFormat(long struct) {
        return UNSAFE.getInt(null, struct + (long)REFERENCEPICTUREFORMAT);
    }

    public static int nmaxDpbSlots(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXDPBSLOTS);
    }

    public static int nmaxActiveReferencePictures(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXACTIVEREFERENCEPICTURES);
    }

    public static VkExtensionProperties npStdHeaderVersion(long struct) {
        return VkExtensionProperties.create(MemoryUtil.memGetAddress(struct + (long)PSTDHEADERVERSION));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nqueueFamilyIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUEUEFAMILYINDEX, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void npVideoProfile(long struct, VkVideoProfileInfoKHR value) {
        MemoryUtil.memPutAddress(struct + (long)PVIDEOPROFILE, value.address());
    }

    public static void npictureFormat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)PICTUREFORMAT, value);
    }

    public static void nmaxCodedExtent(long struct, VkExtent2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MAXCODEDEXTENT, VkExtent2D.SIZEOF);
    }

    public static void nreferencePictureFormat(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)REFERENCEPICTUREFORMAT, value);
    }

    public static void nmaxDpbSlots(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXDPBSLOTS, value);
    }

    public static void nmaxActiveReferencePictures(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXACTIVEREFERENCEPICTURES, value);
    }

    public static void npStdHeaderVersion(long struct, VkExtensionProperties value) {
        MemoryUtil.memPutAddress(struct + (long)PSTDHEADERVERSION, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PVIDEOPROFILE));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSTDHEADERVERSION));
    }

    static {
        Struct.Layout layout = VkVideoSessionCreateInfoKHR.__struct(VkVideoSessionCreateInfoKHR.__member(4), VkVideoSessionCreateInfoKHR.__member(POINTER_SIZE), VkVideoSessionCreateInfoKHR.__member(4), VkVideoSessionCreateInfoKHR.__member(4), VkVideoSessionCreateInfoKHR.__member(POINTER_SIZE), VkVideoSessionCreateInfoKHR.__member(4), VkVideoSessionCreateInfoKHR.__member(VkExtent2D.SIZEOF, VkExtent2D.ALIGNOF), VkVideoSessionCreateInfoKHR.__member(4), VkVideoSessionCreateInfoKHR.__member(4), VkVideoSessionCreateInfoKHR.__member(4), VkVideoSessionCreateInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        QUEUEFAMILYINDEX = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        PVIDEOPROFILE = layout.offsetof(4);
        PICTUREFORMAT = layout.offsetof(5);
        MAXCODEDEXTENT = layout.offsetof(6);
        REFERENCEPICTUREFORMAT = layout.offsetof(7);
        MAXDPBSLOTS = layout.offsetof(8);
        MAXACTIVEREFERENCEPICTURES = layout.offsetof(9);
        PSTDHEADERVERSION = layout.offsetof(10);
    }

    public static class Buffer
    extends StructBuffer<VkVideoSessionCreateInfoKHR, Buffer>
    implements NativeResource {
        private static final VkVideoSessionCreateInfoKHR ELEMENT_FACTORY = VkVideoSessionCreateInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkVideoSessionCreateInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkVideoSessionCreateInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkVideoSessionCreateInfoKHR.npNext(this.address());
        }

        @NativeType(value="uint32_t")
        public int queueFamilyIndex() {
            return VkVideoSessionCreateInfoKHR.nqueueFamilyIndex(this.address());
        }

        @NativeType(value="VkVideoSessionCreateFlagsKHR")
        public int flags() {
            return VkVideoSessionCreateInfoKHR.nflags(this.address());
        }

        @NativeType(value="VkVideoProfileInfoKHR const *")
        public VkVideoProfileInfoKHR pVideoProfile() {
            return VkVideoSessionCreateInfoKHR.npVideoProfile(this.address());
        }

        @NativeType(value="VkFormat")
        public int pictureFormat() {
            return VkVideoSessionCreateInfoKHR.npictureFormat(this.address());
        }

        public VkExtent2D maxCodedExtent() {
            return VkVideoSessionCreateInfoKHR.nmaxCodedExtent(this.address());
        }

        @NativeType(value="VkFormat")
        public int referencePictureFormat() {
            return VkVideoSessionCreateInfoKHR.nreferencePictureFormat(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDpbSlots() {
            return VkVideoSessionCreateInfoKHR.nmaxDpbSlots(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxActiveReferencePictures() {
            return VkVideoSessionCreateInfoKHR.nmaxActiveReferencePictures(this.address());
        }

        @NativeType(value="VkExtensionProperties const *")
        public VkExtensionProperties pStdHeaderVersion() {
            return VkVideoSessionCreateInfoKHR.npStdHeaderVersion(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkVideoSessionCreateInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000023005);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkVideoSessionCreateInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkVideoEncodeH264SessionCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkVideoEncodeH265SessionCreateInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer queueFamilyIndex(@NativeType(value="uint32_t") int value) {
            VkVideoSessionCreateInfoKHR.nqueueFamilyIndex(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkVideoSessionCreateFlagsKHR") int value) {
            VkVideoSessionCreateInfoKHR.nflags(this.address(), value);
            return this;
        }

        public Buffer pVideoProfile(@NativeType(value="VkVideoProfileInfoKHR const *") VkVideoProfileInfoKHR value) {
            VkVideoSessionCreateInfoKHR.npVideoProfile(this.address(), value);
            return this;
        }

        public Buffer pictureFormat(@NativeType(value="VkFormat") int value) {
            VkVideoSessionCreateInfoKHR.npictureFormat(this.address(), value);
            return this;
        }

        public Buffer maxCodedExtent(VkExtent2D value) {
            VkVideoSessionCreateInfoKHR.nmaxCodedExtent(this.address(), value);
            return this;
        }

        public Buffer maxCodedExtent(Consumer<VkExtent2D> consumer) {
            consumer.accept(this.maxCodedExtent());
            return this;
        }

        public Buffer referencePictureFormat(@NativeType(value="VkFormat") int value) {
            VkVideoSessionCreateInfoKHR.nreferencePictureFormat(this.address(), value);
            return this;
        }

        public Buffer maxDpbSlots(@NativeType(value="uint32_t") int value) {
            VkVideoSessionCreateInfoKHR.nmaxDpbSlots(this.address(), value);
            return this;
        }

        public Buffer maxActiveReferencePictures(@NativeType(value="uint32_t") int value) {
            VkVideoSessionCreateInfoKHR.nmaxActiveReferencePictures(this.address(), value);
            return this;
        }

        public Buffer pStdHeaderVersion(@NativeType(value="VkExtensionProperties const *") VkExtensionProperties value) {
            VkVideoSessionCreateInfoKHR.npStdHeaderVersion(this.address(), value);
            return this;
        }
    }
}

