/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkShaderModuleValidationCacheCreateInfoEXT;
import org.lwjgl.vulkan.VkValidationFeaturesEXT;

public class VkShaderModuleCreateInfo
extends Struct<VkShaderModuleCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int CODESIZE;
    public static final int PCODE;

    protected VkShaderModuleCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkShaderModuleCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkShaderModuleCreateInfo(address, container);
    }

    public VkShaderModuleCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkShaderModuleCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkShaderModuleCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkShaderModuleCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkShaderModuleCreateFlags")
    public int flags() {
        return VkShaderModuleCreateInfo.nflags(this.address());
    }

    @NativeType(value="size_t")
    public long codeSize() {
        return VkShaderModuleCreateInfo.ncodeSize(this.address());
    }

    @NativeType(value="uint32_t const *")
    public ByteBuffer pCode() {
        return VkShaderModuleCreateInfo.npCode(this.address());
    }

    public VkShaderModuleCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkShaderModuleCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkShaderModuleCreateInfo sType$Default() {
        return this.sType(16);
    }

    public VkShaderModuleCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkShaderModuleCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkShaderModuleCreateInfo pNext(VkShaderModuleValidationCacheCreateInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkShaderModuleCreateInfo pNext(VkValidationFeaturesEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkShaderModuleCreateInfo flags(@NativeType(value="VkShaderModuleCreateFlags") int value) {
        VkShaderModuleCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkShaderModuleCreateInfo pCode(@NativeType(value="uint32_t const *") ByteBuffer value) {
        VkShaderModuleCreateInfo.npCode(this.address(), value);
        return this;
    }

    public VkShaderModuleCreateInfo set(int sType, long pNext, int flags, ByteBuffer pCode) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pCode(pCode);
        return this;
    }

    public VkShaderModuleCreateInfo set(VkShaderModuleCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkShaderModuleCreateInfo malloc() {
        return new VkShaderModuleCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkShaderModuleCreateInfo calloc() {
        return new VkShaderModuleCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkShaderModuleCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkShaderModuleCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkShaderModuleCreateInfo create(long address) {
        return new VkShaderModuleCreateInfo(address, null);
    }

    @Nullable
    public static VkShaderModuleCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkShaderModuleCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkShaderModuleCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkShaderModuleCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkShaderModuleCreateInfo mallocStack() {
        return VkShaderModuleCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkShaderModuleCreateInfo callocStack() {
        return VkShaderModuleCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkShaderModuleCreateInfo mallocStack(MemoryStack stack) {
        return VkShaderModuleCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkShaderModuleCreateInfo callocStack(MemoryStack stack) {
        return VkShaderModuleCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkShaderModuleCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkShaderModuleCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkShaderModuleCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkShaderModuleCreateInfo.calloc(capacity, stack);
    }

    public static VkShaderModuleCreateInfo malloc(MemoryStack stack) {
        return new VkShaderModuleCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkShaderModuleCreateInfo calloc(MemoryStack stack) {
        return new VkShaderModuleCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long ncodeSize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)CODESIZE);
    }

    public static ByteBuffer npCode(long struct) {
        return MemoryUtil.memByteBuffer(MemoryUtil.memGetAddress(struct + (long)PCODE), (int)VkShaderModuleCreateInfo.ncodeSize(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ncodeSize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)CODESIZE, value);
    }

    public static void npCode(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCODE, MemoryUtil.memAddress(value));
        VkShaderModuleCreateInfo.ncodeSize(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PCODE));
    }

    static {
        Struct.Layout layout = VkShaderModuleCreateInfo.__struct(VkShaderModuleCreateInfo.__member(4), VkShaderModuleCreateInfo.__member(POINTER_SIZE), VkShaderModuleCreateInfo.__member(4), VkShaderModuleCreateInfo.__member(POINTER_SIZE), VkShaderModuleCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        CODESIZE = layout.offsetof(3);
        PCODE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkShaderModuleCreateInfo, Buffer>
    implements NativeResource {
        private static final VkShaderModuleCreateInfo ELEMENT_FACTORY = VkShaderModuleCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkShaderModuleCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkShaderModuleCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkShaderModuleCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkShaderModuleCreateFlags")
        public int flags() {
            return VkShaderModuleCreateInfo.nflags(this.address());
        }

        @NativeType(value="size_t")
        public long codeSize() {
            return VkShaderModuleCreateInfo.ncodeSize(this.address());
        }

        @NativeType(value="uint32_t const *")
        public ByteBuffer pCode() {
            return VkShaderModuleCreateInfo.npCode(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkShaderModuleCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(16);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkShaderModuleCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkShaderModuleValidationCacheCreateInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkValidationFeaturesEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkShaderModuleCreateFlags") int value) {
            VkShaderModuleCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pCode(@NativeType(value="uint32_t const *") ByteBuffer value) {
            VkShaderModuleCreateInfo.npCode(this.address(), value);
            return this;
        }
    }
}

