/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkSemaphoreSubmitInfo
extends Struct<VkSemaphoreSubmitInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int SEMAPHORE;
    public static final int VALUE;
    public static final int STAGEMASK;
    public static final int DEVICEINDEX;

    protected VkSemaphoreSubmitInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkSemaphoreSubmitInfo create(long address, @Nullable ByteBuffer container) {
        return new VkSemaphoreSubmitInfo(address, container);
    }

    public VkSemaphoreSubmitInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkSemaphoreSubmitInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkSemaphoreSubmitInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkSemaphoreSubmitInfo.npNext(this.address());
    }

    @NativeType(value="VkSemaphore")
    public long semaphore() {
        return VkSemaphoreSubmitInfo.nsemaphore(this.address());
    }

    @NativeType(value="uint64_t")
    public long value() {
        return VkSemaphoreSubmitInfo.nvalue(this.address());
    }

    @NativeType(value="VkPipelineStageFlags2")
    public long stageMask() {
        return VkSemaphoreSubmitInfo.nstageMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int deviceIndex() {
        return VkSemaphoreSubmitInfo.ndeviceIndex(this.address());
    }

    public VkSemaphoreSubmitInfo sType(@NativeType(value="VkStructureType") int value) {
        VkSemaphoreSubmitInfo.nsType(this.address(), value);
        return this;
    }

    public VkSemaphoreSubmitInfo sType$Default() {
        return this.sType(1000314005);
    }

    public VkSemaphoreSubmitInfo pNext(@NativeType(value="void const *") long value) {
        VkSemaphoreSubmitInfo.npNext(this.address(), value);
        return this;
    }

    public VkSemaphoreSubmitInfo semaphore(@NativeType(value="VkSemaphore") long value) {
        VkSemaphoreSubmitInfo.nsemaphore(this.address(), value);
        return this;
    }

    public VkSemaphoreSubmitInfo value(@NativeType(value="uint64_t") long value) {
        VkSemaphoreSubmitInfo.nvalue(this.address(), value);
        return this;
    }

    public VkSemaphoreSubmitInfo stageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
        VkSemaphoreSubmitInfo.nstageMask(this.address(), value);
        return this;
    }

    public VkSemaphoreSubmitInfo deviceIndex(@NativeType(value="uint32_t") int value) {
        VkSemaphoreSubmitInfo.ndeviceIndex(this.address(), value);
        return this;
    }

    public VkSemaphoreSubmitInfo set(int sType, long pNext, long semaphore, long value, long stageMask, int deviceIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.semaphore(semaphore);
        this.value(value);
        this.stageMask(stageMask);
        this.deviceIndex(deviceIndex);
        return this;
    }

    public VkSemaphoreSubmitInfo set(VkSemaphoreSubmitInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkSemaphoreSubmitInfo malloc() {
        return new VkSemaphoreSubmitInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkSemaphoreSubmitInfo calloc() {
        return new VkSemaphoreSubmitInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkSemaphoreSubmitInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkSemaphoreSubmitInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkSemaphoreSubmitInfo create(long address) {
        return new VkSemaphoreSubmitInfo(address, null);
    }

    @Nullable
    public static VkSemaphoreSubmitInfo createSafe(long address) {
        return address == 0L ? null : new VkSemaphoreSubmitInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkSemaphoreSubmitInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkSemaphoreSubmitInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkSemaphoreSubmitInfo malloc(MemoryStack stack) {
        return new VkSemaphoreSubmitInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkSemaphoreSubmitInfo calloc(MemoryStack stack) {
        return new VkSemaphoreSubmitInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nsemaphore(long struct) {
        return UNSAFE.getLong(null, struct + (long)SEMAPHORE);
    }

    public static long nvalue(long struct) {
        return UNSAFE.getLong(null, struct + (long)VALUE);
    }

    public static long nstageMask(long struct) {
        return UNSAFE.getLong(null, struct + (long)STAGEMASK);
    }

    public static int ndeviceIndex(long struct) {
        return UNSAFE.getInt(null, struct + (long)DEVICEINDEX);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nsemaphore(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)SEMAPHORE, value);
    }

    public static void nvalue(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)VALUE, value);
    }

    public static void nstageMask(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)STAGEMASK, value);
    }

    public static void ndeviceIndex(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DEVICEINDEX, value);
    }

    static {
        Struct.Layout layout = VkSemaphoreSubmitInfo.__struct(VkSemaphoreSubmitInfo.__member(4), VkSemaphoreSubmitInfo.__member(POINTER_SIZE), VkSemaphoreSubmitInfo.__member(8), VkSemaphoreSubmitInfo.__member(8), VkSemaphoreSubmitInfo.__member(8), VkSemaphoreSubmitInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        SEMAPHORE = layout.offsetof(2);
        VALUE = layout.offsetof(3);
        STAGEMASK = layout.offsetof(4);
        DEVICEINDEX = layout.offsetof(5);
    }

    public static class Buffer
    extends StructBuffer<VkSemaphoreSubmitInfo, Buffer>
    implements NativeResource {
        private static final VkSemaphoreSubmitInfo ELEMENT_FACTORY = VkSemaphoreSubmitInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkSemaphoreSubmitInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkSemaphoreSubmitInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkSemaphoreSubmitInfo.npNext(this.address());
        }

        @NativeType(value="VkSemaphore")
        public long semaphore() {
            return VkSemaphoreSubmitInfo.nsemaphore(this.address());
        }

        @NativeType(value="uint64_t")
        public long value() {
            return VkSemaphoreSubmitInfo.nvalue(this.address());
        }

        @NativeType(value="VkPipelineStageFlags2")
        public long stageMask() {
            return VkSemaphoreSubmitInfo.nstageMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int deviceIndex() {
            return VkSemaphoreSubmitInfo.ndeviceIndex(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkSemaphoreSubmitInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000314005);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkSemaphoreSubmitInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer semaphore(@NativeType(value="VkSemaphore") long value) {
            VkSemaphoreSubmitInfo.nsemaphore(this.address(), value);
            return this;
        }

        public Buffer value(@NativeType(value="uint64_t") long value) {
            VkSemaphoreSubmitInfo.nvalue(this.address(), value);
            return this;
        }

        public Buffer stageMask(@NativeType(value="VkPipelineStageFlags2") long value) {
            VkSemaphoreSubmitInfo.nstageMask(this.address(), value);
            return this;
        }

        public Buffer deviceIndex(@NativeType(value="uint32_t") int value) {
            VkSemaphoreSubmitInfo.ndeviceIndex(this.address(), value);
            return this;
        }
    }
}

