/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDeviceGroupRenderPassBeginInfo;
import org.lwjgl.vulkan.VkDeviceGroupRenderPassBeginInfoKHR;
import org.lwjgl.vulkan.VkMultisampledRenderToSingleSampledInfoEXT;
import org.lwjgl.vulkan.VkMultiviewPerViewAttributesInfoNVX;
import org.lwjgl.vulkan.VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM;
import org.lwjgl.vulkan.VkRect2D;
import org.lwjgl.vulkan.VkRenderPassStripeBeginInfoARM;
import org.lwjgl.vulkan.VkRenderingAttachmentInfo;
import org.lwjgl.vulkan.VkRenderingFragmentDensityMapAttachmentInfoEXT;
import org.lwjgl.vulkan.VkRenderingFragmentShadingRateAttachmentInfoKHR;

public class VkRenderingInfo
extends Struct<VkRenderingInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int RENDERAREA;
    public static final int LAYERCOUNT;
    public static final int VIEWMASK;
    public static final int COLORATTACHMENTCOUNT;
    public static final int PCOLORATTACHMENTS;
    public static final int PDEPTHATTACHMENT;
    public static final int PSTENCILATTACHMENT;

    protected VkRenderingInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkRenderingInfo create(long address, @Nullable ByteBuffer container) {
        return new VkRenderingInfo(address, container);
    }

    public VkRenderingInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkRenderingInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkRenderingInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkRenderingInfo.npNext(this.address());
    }

    @NativeType(value="VkRenderingFlags")
    public int flags() {
        return VkRenderingInfo.nflags(this.address());
    }

    public VkRect2D renderArea() {
        return VkRenderingInfo.nrenderArea(this.address());
    }

    @NativeType(value="uint32_t")
    public int layerCount() {
        return VkRenderingInfo.nlayerCount(this.address());
    }

    @NativeType(value="uint32_t")
    public int viewMask() {
        return VkRenderingInfo.nviewMask(this.address());
    }

    @NativeType(value="uint32_t")
    public int colorAttachmentCount() {
        return VkRenderingInfo.ncolorAttachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkRenderingAttachmentInfo const *")
    public VkRenderingAttachmentInfo.Buffer pColorAttachments() {
        return VkRenderingInfo.npColorAttachments(this.address());
    }

    @Nullable
    @NativeType(value="VkRenderingAttachmentInfo const *")
    public VkRenderingAttachmentInfo pDepthAttachment() {
        return VkRenderingInfo.npDepthAttachment(this.address());
    }

    @Nullable
    @NativeType(value="VkRenderingAttachmentInfo const *")
    public VkRenderingAttachmentInfo pStencilAttachment() {
        return VkRenderingInfo.npStencilAttachment(this.address());
    }

    public VkRenderingInfo sType(@NativeType(value="VkStructureType") int value) {
        VkRenderingInfo.nsType(this.address(), value);
        return this;
    }

    public VkRenderingInfo sType$Default() {
        return this.sType(1000044000);
    }

    public VkRenderingInfo pNext(@NativeType(value="void const *") long value) {
        VkRenderingInfo.npNext(this.address(), value);
        return this;
    }

    public VkRenderingInfo pNext(VkDeviceGroupRenderPassBeginInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderingInfo pNext(VkDeviceGroupRenderPassBeginInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderingInfo pNext(VkMultisampledRenderToSingleSampledInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderingInfo pNext(VkMultiviewPerViewAttributesInfoNVX value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderingInfo pNext(VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderingInfo pNext(VkRenderPassStripeBeginInfoARM value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderingInfo pNext(VkRenderingFragmentDensityMapAttachmentInfoEXT value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderingInfo pNext(VkRenderingFragmentShadingRateAttachmentInfoKHR value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkRenderingInfo flags(@NativeType(value="VkRenderingFlags") int value) {
        VkRenderingInfo.nflags(this.address(), value);
        return this;
    }

    public VkRenderingInfo renderArea(VkRect2D value) {
        VkRenderingInfo.nrenderArea(this.address(), value);
        return this;
    }

    public VkRenderingInfo renderArea(Consumer<VkRect2D> consumer) {
        consumer.accept(this.renderArea());
        return this;
    }

    public VkRenderingInfo layerCount(@NativeType(value="uint32_t") int value) {
        VkRenderingInfo.nlayerCount(this.address(), value);
        return this;
    }

    public VkRenderingInfo viewMask(@NativeType(value="uint32_t") int value) {
        VkRenderingInfo.nviewMask(this.address(), value);
        return this;
    }

    public VkRenderingInfo pColorAttachments(@Nullable @NativeType(value="VkRenderingAttachmentInfo const *") VkRenderingAttachmentInfo.Buffer value) {
        VkRenderingInfo.npColorAttachments(this.address(), value);
        return this;
    }

    public VkRenderingInfo pDepthAttachment(@Nullable @NativeType(value="VkRenderingAttachmentInfo const *") VkRenderingAttachmentInfo value) {
        VkRenderingInfo.npDepthAttachment(this.address(), value);
        return this;
    }

    public VkRenderingInfo pStencilAttachment(@Nullable @NativeType(value="VkRenderingAttachmentInfo const *") VkRenderingAttachmentInfo value) {
        VkRenderingInfo.npStencilAttachment(this.address(), value);
        return this;
    }

    public VkRenderingInfo set(int sType, long pNext, int flags, VkRect2D renderArea, int layerCount, int viewMask, @Nullable VkRenderingAttachmentInfo.Buffer pColorAttachments, @Nullable VkRenderingAttachmentInfo pDepthAttachment, @Nullable VkRenderingAttachmentInfo pStencilAttachment) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.renderArea(renderArea);
        this.layerCount(layerCount);
        this.viewMask(viewMask);
        this.pColorAttachments(pColorAttachments);
        this.pDepthAttachment(pDepthAttachment);
        this.pStencilAttachment(pStencilAttachment);
        return this;
    }

    public VkRenderingInfo set(VkRenderingInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkRenderingInfo malloc() {
        return new VkRenderingInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkRenderingInfo calloc() {
        return new VkRenderingInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkRenderingInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkRenderingInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkRenderingInfo create(long address) {
        return new VkRenderingInfo(address, null);
    }

    @Nullable
    public static VkRenderingInfo createSafe(long address) {
        return address == 0L ? null : new VkRenderingInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkRenderingInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkRenderingInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkRenderingInfo malloc(MemoryStack stack) {
        return new VkRenderingInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkRenderingInfo calloc(MemoryStack stack) {
        return new VkRenderingInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static VkRect2D nrenderArea(long struct) {
        return VkRect2D.create(struct + (long)RENDERAREA);
    }

    public static int nlayerCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYERCOUNT);
    }

    public static int nviewMask(long struct) {
        return UNSAFE.getInt(null, struct + (long)VIEWMASK);
    }

    public static int ncolorAttachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COLORATTACHMENTCOUNT);
    }

    @Nullable
    public static VkRenderingAttachmentInfo.Buffer npColorAttachments(long struct) {
        return VkRenderingAttachmentInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PCOLORATTACHMENTS), VkRenderingInfo.ncolorAttachmentCount(struct));
    }

    @Nullable
    public static VkRenderingAttachmentInfo npDepthAttachment(long struct) {
        return VkRenderingAttachmentInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PDEPTHATTACHMENT));
    }

    @Nullable
    public static VkRenderingAttachmentInfo npStencilAttachment(long struct) {
        return VkRenderingAttachmentInfo.createSafe(MemoryUtil.memGetAddress(struct + (long)PSTENCILATTACHMENT));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nrenderArea(long struct, VkRect2D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)RENDERAREA, VkRect2D.SIZEOF);
    }

    public static void nlayerCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LAYERCOUNT, value);
    }

    public static void nviewMask(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)VIEWMASK, value);
    }

    public static void ncolorAttachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COLORATTACHMENTCOUNT, value);
    }

    public static void npColorAttachments(long struct, @Nullable VkRenderingAttachmentInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PCOLORATTACHMENTS, MemoryUtil.memAddressSafe(value));
        VkRenderingInfo.ncolorAttachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void npDepthAttachment(long struct, @Nullable VkRenderingAttachmentInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PDEPTHATTACHMENT, MemoryUtil.memAddressSafe(value));
    }

    public static void npStencilAttachment(long struct, @Nullable VkRenderingAttachmentInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PSTENCILATTACHMENT, MemoryUtil.memAddressSafe(value));
    }

    public static void validate(long struct) {
        if (VkRenderingInfo.ncolorAttachmentCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PCOLORATTACHMENTS));
        }
    }

    static {
        Struct.Layout layout = VkRenderingInfo.__struct(VkRenderingInfo.__member(4), VkRenderingInfo.__member(POINTER_SIZE), VkRenderingInfo.__member(4), VkRenderingInfo.__member(VkRect2D.SIZEOF, VkRect2D.ALIGNOF), VkRenderingInfo.__member(4), VkRenderingInfo.__member(4), VkRenderingInfo.__member(4), VkRenderingInfo.__member(POINTER_SIZE), VkRenderingInfo.__member(POINTER_SIZE), VkRenderingInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        RENDERAREA = layout.offsetof(3);
        LAYERCOUNT = layout.offsetof(4);
        VIEWMASK = layout.offsetof(5);
        COLORATTACHMENTCOUNT = layout.offsetof(6);
        PCOLORATTACHMENTS = layout.offsetof(7);
        PDEPTHATTACHMENT = layout.offsetof(8);
        PSTENCILATTACHMENT = layout.offsetof(9);
    }

    public static class Buffer
    extends StructBuffer<VkRenderingInfo, Buffer>
    implements NativeResource {
        private static final VkRenderingInfo ELEMENT_FACTORY = VkRenderingInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkRenderingInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkRenderingInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkRenderingInfo.npNext(this.address());
        }

        @NativeType(value="VkRenderingFlags")
        public int flags() {
            return VkRenderingInfo.nflags(this.address());
        }

        public VkRect2D renderArea() {
            return VkRenderingInfo.nrenderArea(this.address());
        }

        @NativeType(value="uint32_t")
        public int layerCount() {
            return VkRenderingInfo.nlayerCount(this.address());
        }

        @NativeType(value="uint32_t")
        public int viewMask() {
            return VkRenderingInfo.nviewMask(this.address());
        }

        @NativeType(value="uint32_t")
        public int colorAttachmentCount() {
            return VkRenderingInfo.ncolorAttachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkRenderingAttachmentInfo const *")
        public VkRenderingAttachmentInfo.Buffer pColorAttachments() {
            return VkRenderingInfo.npColorAttachments(this.address());
        }

        @Nullable
        @NativeType(value="VkRenderingAttachmentInfo const *")
        public VkRenderingAttachmentInfo pDepthAttachment() {
            return VkRenderingInfo.npDepthAttachment(this.address());
        }

        @Nullable
        @NativeType(value="VkRenderingAttachmentInfo const *")
        public VkRenderingAttachmentInfo pStencilAttachment() {
            return VkRenderingInfo.npStencilAttachment(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkRenderingInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000044000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkRenderingInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkDeviceGroupRenderPassBeginInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkDeviceGroupRenderPassBeginInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMultisampledRenderToSingleSampledInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMultiviewPerViewAttributesInfoNVX value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderPassStripeBeginInfoARM value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderingFragmentDensityMapAttachmentInfoEXT value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer pNext(VkRenderingFragmentShadingRateAttachmentInfoKHR value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer flags(@NativeType(value="VkRenderingFlags") int value) {
            VkRenderingInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer renderArea(VkRect2D value) {
            VkRenderingInfo.nrenderArea(this.address(), value);
            return this;
        }

        public Buffer renderArea(Consumer<VkRect2D> consumer) {
            consumer.accept(this.renderArea());
            return this;
        }

        public Buffer layerCount(@NativeType(value="uint32_t") int value) {
            VkRenderingInfo.nlayerCount(this.address(), value);
            return this;
        }

        public Buffer viewMask(@NativeType(value="uint32_t") int value) {
            VkRenderingInfo.nviewMask(this.address(), value);
            return this;
        }

        public Buffer pColorAttachments(@Nullable @NativeType(value="VkRenderingAttachmentInfo const *") VkRenderingAttachmentInfo.Buffer value) {
            VkRenderingInfo.npColorAttachments(this.address(), value);
            return this;
        }

        public Buffer pDepthAttachment(@Nullable @NativeType(value="VkRenderingAttachmentInfo const *") VkRenderingAttachmentInfo value) {
            VkRenderingInfo.npDepthAttachment(this.address(), value);
            return this;
        }

        public Buffer pStencilAttachment(@Nullable @NativeType(value="VkRenderingAttachmentInfo const *") VkRenderingAttachmentInfo value) {
            VkRenderingInfo.npStencilAttachment(this.address(), value);
            return this;
        }
    }
}

