/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineLayoutCreateInfo;
import org.lwjgl.vulkan.VkWriteDescriptorSet;

public class VkPushDescriptorSetInfoKHR
extends Struct<VkPushDescriptorSetInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int STAGEFLAGS;
    public static final int LAYOUT;
    public static final int SET;
    public static final int DESCRIPTORWRITECOUNT;
    public static final int PDESCRIPTORWRITES;

    protected VkPushDescriptorSetInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPushDescriptorSetInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkPushDescriptorSetInfoKHR(address, container);
    }

    public VkPushDescriptorSetInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPushDescriptorSetInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPushDescriptorSetInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPushDescriptorSetInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkShaderStageFlags")
    public int stageFlags() {
        return VkPushDescriptorSetInfoKHR.nstageFlags(this.address());
    }

    @NativeType(value="VkPipelineLayout")
    public long layout() {
        return VkPushDescriptorSetInfoKHR.nlayout(this.address());
    }

    @NativeType(value="uint32_t")
    public int set() {
        return VkPushDescriptorSetInfoKHR.nset(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorWriteCount() {
        return VkPushDescriptorSetInfoKHR.ndescriptorWriteCount(this.address());
    }

    @NativeType(value="VkWriteDescriptorSet const *")
    public VkWriteDescriptorSet.Buffer pDescriptorWrites() {
        return VkPushDescriptorSetInfoKHR.npDescriptorWrites(this.address());
    }

    public VkPushDescriptorSetInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkPushDescriptorSetInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkPushDescriptorSetInfoKHR sType$Default() {
        return this.sType(1000545005);
    }

    public VkPushDescriptorSetInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkPushDescriptorSetInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkPushDescriptorSetInfoKHR pNext(VkPipelineLayoutCreateInfo value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkPushDescriptorSetInfoKHR stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
        VkPushDescriptorSetInfoKHR.nstageFlags(this.address(), value);
        return this;
    }

    public VkPushDescriptorSetInfoKHR layout(@NativeType(value="VkPipelineLayout") long value) {
        VkPushDescriptorSetInfoKHR.nlayout(this.address(), value);
        return this;
    }

    public VkPushDescriptorSetInfoKHR set(@NativeType(value="uint32_t") int value) {
        VkPushDescriptorSetInfoKHR.nset(this.address(), value);
        return this;
    }

    public VkPushDescriptorSetInfoKHR pDescriptorWrites(@NativeType(value="VkWriteDescriptorSet const *") VkWriteDescriptorSet.Buffer value) {
        VkPushDescriptorSetInfoKHR.npDescriptorWrites(this.address(), value);
        return this;
    }

    public VkPushDescriptorSetInfoKHR set(int sType, long pNext, int stageFlags, long layout, int set, VkWriteDescriptorSet.Buffer pDescriptorWrites) {
        this.sType(sType);
        this.pNext(pNext);
        this.stageFlags(stageFlags);
        this.layout(layout);
        this.set(set);
        this.pDescriptorWrites(pDescriptorWrites);
        return this;
    }

    public VkPushDescriptorSetInfoKHR set(VkPushDescriptorSetInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPushDescriptorSetInfoKHR malloc() {
        return new VkPushDescriptorSetInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPushDescriptorSetInfoKHR calloc() {
        return new VkPushDescriptorSetInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPushDescriptorSetInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPushDescriptorSetInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkPushDescriptorSetInfoKHR create(long address) {
        return new VkPushDescriptorSetInfoKHR(address, null);
    }

    @Nullable
    public static VkPushDescriptorSetInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkPushDescriptorSetInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPushDescriptorSetInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPushDescriptorSetInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPushDescriptorSetInfoKHR malloc(MemoryStack stack) {
        return new VkPushDescriptorSetInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPushDescriptorSetInfoKHR calloc(MemoryStack stack) {
        return new VkPushDescriptorSetInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nstageFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)STAGEFLAGS);
    }

    public static long nlayout(long struct) {
        return UNSAFE.getLong(null, struct + (long)LAYOUT);
    }

    public static int nset(long struct) {
        return UNSAFE.getInt(null, struct + (long)SET);
    }

    public static int ndescriptorWriteCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DESCRIPTORWRITECOUNT);
    }

    public static VkWriteDescriptorSet.Buffer npDescriptorWrites(long struct) {
        return VkWriteDescriptorSet.create(MemoryUtil.memGetAddress(struct + (long)PDESCRIPTORWRITES), VkPushDescriptorSetInfoKHR.ndescriptorWriteCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nstageFlags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STAGEFLAGS, value);
    }

    public static void nlayout(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)LAYOUT, value);
    }

    public static void nset(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SET, value);
    }

    public static void ndescriptorWriteCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DESCRIPTORWRITECOUNT, value);
    }

    public static void npDescriptorWrites(long struct, VkWriteDescriptorSet.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDESCRIPTORWRITES, value.address());
        VkPushDescriptorSetInfoKHR.ndescriptorWriteCount(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PDESCRIPTORWRITES));
    }

    static {
        Struct.Layout layout = VkPushDescriptorSetInfoKHR.__struct(VkPushDescriptorSetInfoKHR.__member(4), VkPushDescriptorSetInfoKHR.__member(POINTER_SIZE), VkPushDescriptorSetInfoKHR.__member(4), VkPushDescriptorSetInfoKHR.__member(8), VkPushDescriptorSetInfoKHR.__member(4), VkPushDescriptorSetInfoKHR.__member(4), VkPushDescriptorSetInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        STAGEFLAGS = layout.offsetof(2);
        LAYOUT = layout.offsetof(3);
        SET = layout.offsetof(4);
        DESCRIPTORWRITECOUNT = layout.offsetof(5);
        PDESCRIPTORWRITES = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkPushDescriptorSetInfoKHR, Buffer>
    implements NativeResource {
        private static final VkPushDescriptorSetInfoKHR ELEMENT_FACTORY = VkPushDescriptorSetInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPushDescriptorSetInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPushDescriptorSetInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPushDescriptorSetInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkShaderStageFlags")
        public int stageFlags() {
            return VkPushDescriptorSetInfoKHR.nstageFlags(this.address());
        }

        @NativeType(value="VkPipelineLayout")
        public long layout() {
            return VkPushDescriptorSetInfoKHR.nlayout(this.address());
        }

        @NativeType(value="uint32_t")
        public int set() {
            return VkPushDescriptorSetInfoKHR.nset(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorWriteCount() {
            return VkPushDescriptorSetInfoKHR.ndescriptorWriteCount(this.address());
        }

        @NativeType(value="VkWriteDescriptorSet const *")
        public VkWriteDescriptorSet.Buffer pDescriptorWrites() {
            return VkPushDescriptorSetInfoKHR.npDescriptorWrites(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPushDescriptorSetInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000545005);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPushDescriptorSetInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkPipelineLayoutCreateInfo value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer stageFlags(@NativeType(value="VkShaderStageFlags") int value) {
            VkPushDescriptorSetInfoKHR.nstageFlags(this.address(), value);
            return this;
        }

        public Buffer layout(@NativeType(value="VkPipelineLayout") long value) {
            VkPushDescriptorSetInfoKHR.nlayout(this.address(), value);
            return this;
        }

        public Buffer set(@NativeType(value="uint32_t") int value) {
            VkPushDescriptorSetInfoKHR.nset(this.address(), value);
            return this;
        }

        public Buffer pDescriptorWrites(@NativeType(value="VkWriteDescriptorSet const *") VkWriteDescriptorSet.Buffer value) {
            VkPushDescriptorSetInfoKHR.npDescriptorWrites(this.address(), value);
            return this;
        }
    }
}

