/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelinePropertiesIdentifierEXT
extends Struct<VkPipelinePropertiesIdentifierEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PIPELINEIDENTIFIER;

    protected VkPipelinePropertiesIdentifierEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPipelinePropertiesIdentifierEXT create(long address, @Nullable ByteBuffer container) {
        return new VkPipelinePropertiesIdentifierEXT(address, container);
    }

    public VkPipelinePropertiesIdentifierEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelinePropertiesIdentifierEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelinePropertiesIdentifierEXT.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPipelinePropertiesIdentifierEXT.npNext(this.address());
    }

    @NativeType(value="uint8_t[VK_UUID_SIZE]")
    public ByteBuffer pipelineIdentifier() {
        return VkPipelinePropertiesIdentifierEXT.npipelineIdentifier(this.address());
    }

    @NativeType(value="uint8_t")
    public byte pipelineIdentifier(int index) {
        return VkPipelinePropertiesIdentifierEXT.npipelineIdentifier(this.address(), index);
    }

    public VkPipelinePropertiesIdentifierEXT sType(@NativeType(value="VkStructureType") int value) {
        VkPipelinePropertiesIdentifierEXT.nsType(this.address(), value);
        return this;
    }

    public VkPipelinePropertiesIdentifierEXT sType$Default() {
        return this.sType(1000372000);
    }

    public VkPipelinePropertiesIdentifierEXT pNext(@NativeType(value="void *") long value) {
        VkPipelinePropertiesIdentifierEXT.npNext(this.address(), value);
        return this;
    }

    public VkPipelinePropertiesIdentifierEXT set(int sType, long pNext) {
        this.sType(sType);
        this.pNext(pNext);
        return this;
    }

    public VkPipelinePropertiesIdentifierEXT set(VkPipelinePropertiesIdentifierEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelinePropertiesIdentifierEXT malloc() {
        return new VkPipelinePropertiesIdentifierEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPipelinePropertiesIdentifierEXT calloc() {
        return new VkPipelinePropertiesIdentifierEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPipelinePropertiesIdentifierEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPipelinePropertiesIdentifierEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkPipelinePropertiesIdentifierEXT create(long address) {
        return new VkPipelinePropertiesIdentifierEXT(address, null);
    }

    @Nullable
    public static VkPipelinePropertiesIdentifierEXT createSafe(long address) {
        return address == 0L ? null : new VkPipelinePropertiesIdentifierEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPipelinePropertiesIdentifierEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelinePropertiesIdentifierEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkPipelinePropertiesIdentifierEXT malloc(MemoryStack stack) {
        return new VkPipelinePropertiesIdentifierEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelinePropertiesIdentifierEXT calloc(MemoryStack stack) {
        return new VkPipelinePropertiesIdentifierEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static ByteBuffer npipelineIdentifier(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)PIPELINEIDENTIFIER, 16);
    }

    public static byte npipelineIdentifier(long struct, int index) {
        return UNSAFE.getByte(null, struct + (long)PIPELINEIDENTIFIER + Checks.check(index, 16) * 1L);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    static {
        Struct.Layout layout = VkPipelinePropertiesIdentifierEXT.__struct(VkPipelinePropertiesIdentifierEXT.__member(4), VkPipelinePropertiesIdentifierEXT.__member(POINTER_SIZE), VkPipelinePropertiesIdentifierEXT.__array(1, 16));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PIPELINEIDENTIFIER = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkPipelinePropertiesIdentifierEXT, Buffer>
    implements NativeResource {
        private static final VkPipelinePropertiesIdentifierEXT ELEMENT_FACTORY = VkPipelinePropertiesIdentifierEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPipelinePropertiesIdentifierEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelinePropertiesIdentifierEXT.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPipelinePropertiesIdentifierEXT.npNext(this.address());
        }

        @NativeType(value="uint8_t[VK_UUID_SIZE]")
        public ByteBuffer pipelineIdentifier() {
            return VkPipelinePropertiesIdentifierEXT.npipelineIdentifier(this.address());
        }

        @NativeType(value="uint8_t")
        public byte pipelineIdentifier(int index) {
            return VkPipelinePropertiesIdentifierEXT.npipelineIdentifier(this.address(), index);
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelinePropertiesIdentifierEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000372000);
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPipelinePropertiesIdentifierEXT.npNext(this.address(), value);
            return this;
        }
    }
}

