/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkPipelineDynamicStateCreateInfo
extends Struct<VkPipelineDynamicStateCreateInfo>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int DYNAMICSTATECOUNT;
    public static final int PDYNAMICSTATES;

    protected VkPipelineDynamicStateCreateInfo(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkPipelineDynamicStateCreateInfo create(long address, @Nullable ByteBuffer container) {
        return new VkPipelineDynamicStateCreateInfo(address, container);
    }

    public VkPipelineDynamicStateCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkPipelineDynamicStateCreateInfo.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPipelineDynamicStateCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkPipelineDynamicStateCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkPipelineDynamicStateCreateFlags")
    public int flags() {
        return VkPipelineDynamicStateCreateInfo.nflags(this.address());
    }

    @NativeType(value="uint32_t")
    public int dynamicStateCount() {
        return VkPipelineDynamicStateCreateInfo.ndynamicStateCount(this.address());
    }

    @Nullable
    @NativeType(value="VkDynamicState const *")
    public IntBuffer pDynamicStates() {
        return VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address());
    }

    public VkPipelineDynamicStateCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkPipelineDynamicStateCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo sType$Default() {
        return this.sType(27);
    }

    public VkPipelineDynamicStateCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkPipelineDynamicStateCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo flags(@NativeType(value="VkPipelineDynamicStateCreateFlags") int value) {
        VkPipelineDynamicStateCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo pDynamicStates(@Nullable @NativeType(value="VkDynamicState const *") IntBuffer value) {
        VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address(), value);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo set(int sType, long pNext, int flags, @Nullable IntBuffer pDynamicStates) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pDynamicStates(pDynamicStates);
        return this;
    }

    public VkPipelineDynamicStateCreateInfo set(VkPipelineDynamicStateCreateInfo src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkPipelineDynamicStateCreateInfo malloc() {
        return new VkPipelineDynamicStateCreateInfo(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkPipelineDynamicStateCreateInfo calloc() {
        return new VkPipelineDynamicStateCreateInfo(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkPipelineDynamicStateCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkPipelineDynamicStateCreateInfo(MemoryUtil.memAddress(container), container);
    }

    public static VkPipelineDynamicStateCreateInfo create(long address) {
        return new VkPipelineDynamicStateCreateInfo(address, null);
    }

    @Nullable
    public static VkPipelineDynamicStateCreateInfo createSafe(long address) {
        return address == 0L ? null : new VkPipelineDynamicStateCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkPipelineDynamicStateCreateInfo.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPipelineDynamicStateCreateInfo.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkPipelineDynamicStateCreateInfo mallocStack() {
        return VkPipelineDynamicStateCreateInfo.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineDynamicStateCreateInfo callocStack() {
        return VkPipelineDynamicStateCreateInfo.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPipelineDynamicStateCreateInfo mallocStack(MemoryStack stack) {
        return VkPipelineDynamicStateCreateInfo.malloc(stack);
    }

    @Deprecated
    public static VkPipelineDynamicStateCreateInfo callocStack(MemoryStack stack) {
        return VkPipelineDynamicStateCreateInfo.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPipelineDynamicStateCreateInfo.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPipelineDynamicStateCreateInfo.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPipelineDynamicStateCreateInfo.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPipelineDynamicStateCreateInfo.calloc(capacity, stack);
    }

    public static VkPipelineDynamicStateCreateInfo malloc(MemoryStack stack) {
        return new VkPipelineDynamicStateCreateInfo(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkPipelineDynamicStateCreateInfo calloc(MemoryStack stack) {
        return new VkPipelineDynamicStateCreateInfo(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static int ndynamicStateCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DYNAMICSTATECOUNT);
    }

    @Nullable
    public static IntBuffer npDynamicStates(long struct) {
        return MemoryUtil.memIntBufferSafe(MemoryUtil.memGetAddress(struct + (long)PDYNAMICSTATES), VkPipelineDynamicStateCreateInfo.ndynamicStateCount(struct));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void ndynamicStateCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DYNAMICSTATECOUNT, value);
    }

    public static void npDynamicStates(long struct, @Nullable IntBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDYNAMICSTATES, MemoryUtil.memAddressSafe(value));
        VkPipelineDynamicStateCreateInfo.ndynamicStateCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkPipelineDynamicStateCreateInfo.ndynamicStateCount(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)PDYNAMICSTATES));
        }
    }

    static {
        Struct.Layout layout = VkPipelineDynamicStateCreateInfo.__struct(VkPipelineDynamicStateCreateInfo.__member(4), VkPipelineDynamicStateCreateInfo.__member(POINTER_SIZE), VkPipelineDynamicStateCreateInfo.__member(4), VkPipelineDynamicStateCreateInfo.__member(4), VkPipelineDynamicStateCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        DYNAMICSTATECOUNT = layout.offsetof(3);
        PDYNAMICSTATES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkPipelineDynamicStateCreateInfo, Buffer>
    implements NativeResource {
        private static final VkPipelineDynamicStateCreateInfo ELEMENT_FACTORY = VkPipelineDynamicStateCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkPipelineDynamicStateCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPipelineDynamicStateCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkPipelineDynamicStateCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkPipelineDynamicStateCreateFlags")
        public int flags() {
            return VkPipelineDynamicStateCreateInfo.nflags(this.address());
        }

        @NativeType(value="uint32_t")
        public int dynamicStateCount() {
            return VkPipelineDynamicStateCreateInfo.ndynamicStateCount(this.address());
        }

        @Nullable
        @NativeType(value="VkDynamicState const *")
        public IntBuffer pDynamicStates() {
            return VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPipelineDynamicStateCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(27);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkPipelineDynamicStateCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkPipelineDynamicStateCreateFlags") int value) {
            VkPipelineDynamicStateCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pDynamicStates(@Nullable @NativeType(value="VkDynamicState const *") IntBuffer value) {
            VkPipelineDynamicStateCreateInfo.npDynamicStates(this.address(), value);
            return this;
        }
    }
}

