/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDeviceOrHostAddressConstAMDX;

public class VkDispatchGraphCountInfoAMDX
extends Struct<VkDispatchGraphCountInfoAMDX>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int COUNT;
    public static final int INFOS;
    public static final int STRIDE;

    protected VkDispatchGraphCountInfoAMDX(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDispatchGraphCountInfoAMDX create(long address, @Nullable ByteBuffer container) {
        return new VkDispatchGraphCountInfoAMDX(address, container);
    }

    public VkDispatchGraphCountInfoAMDX(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDispatchGraphCountInfoAMDX.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int count() {
        return VkDispatchGraphCountInfoAMDX.ncount(this.address());
    }

    public VkDeviceOrHostAddressConstAMDX infos() {
        return VkDispatchGraphCountInfoAMDX.ninfos(this.address());
    }

    @NativeType(value="uint64_t")
    public long stride() {
        return VkDispatchGraphCountInfoAMDX.nstride(this.address());
    }

    public VkDispatchGraphCountInfoAMDX count(@NativeType(value="uint32_t") int value) {
        VkDispatchGraphCountInfoAMDX.ncount(this.address(), value);
        return this;
    }

    public VkDispatchGraphCountInfoAMDX infos(VkDeviceOrHostAddressConstAMDX value) {
        VkDispatchGraphCountInfoAMDX.ninfos(this.address(), value);
        return this;
    }

    public VkDispatchGraphCountInfoAMDX infos(Consumer<VkDeviceOrHostAddressConstAMDX> consumer) {
        consumer.accept(this.infos());
        return this;
    }

    public VkDispatchGraphCountInfoAMDX stride(@NativeType(value="uint64_t") long value) {
        VkDispatchGraphCountInfoAMDX.nstride(this.address(), value);
        return this;
    }

    public VkDispatchGraphCountInfoAMDX set(int count, VkDeviceOrHostAddressConstAMDX infos, long stride) {
        this.count(count);
        this.infos(infos);
        this.stride(stride);
        return this;
    }

    public VkDispatchGraphCountInfoAMDX set(VkDispatchGraphCountInfoAMDX src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDispatchGraphCountInfoAMDX malloc() {
        return new VkDispatchGraphCountInfoAMDX(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDispatchGraphCountInfoAMDX calloc() {
        return new VkDispatchGraphCountInfoAMDX(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDispatchGraphCountInfoAMDX create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDispatchGraphCountInfoAMDX(MemoryUtil.memAddress(container), container);
    }

    public static VkDispatchGraphCountInfoAMDX create(long address) {
        return new VkDispatchGraphCountInfoAMDX(address, null);
    }

    @Nullable
    public static VkDispatchGraphCountInfoAMDX createSafe(long address) {
        return address == 0L ? null : new VkDispatchGraphCountInfoAMDX(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDispatchGraphCountInfoAMDX.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDispatchGraphCountInfoAMDX.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDispatchGraphCountInfoAMDX malloc(MemoryStack stack) {
        return new VkDispatchGraphCountInfoAMDX(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDispatchGraphCountInfoAMDX calloc(MemoryStack stack) {
        return new VkDispatchGraphCountInfoAMDX(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ncount(long struct) {
        return UNSAFE.getInt(null, struct + (long)COUNT);
    }

    public static VkDeviceOrHostAddressConstAMDX ninfos(long struct) {
        return VkDeviceOrHostAddressConstAMDX.create(struct + (long)INFOS);
    }

    public static long nstride(long struct) {
        return UNSAFE.getLong(null, struct + (long)STRIDE);
    }

    public static void ncount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)COUNT, value);
    }

    public static void ninfos(long struct, VkDeviceOrHostAddressConstAMDX value) {
        MemoryUtil.memCopy(value.address(), struct + (long)INFOS, VkDeviceOrHostAddressConstAMDX.SIZEOF);
    }

    public static void nstride(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)STRIDE, value);
    }

    static {
        Struct.Layout layout = VkDispatchGraphCountInfoAMDX.__struct(VkDispatchGraphCountInfoAMDX.__member(4), VkDispatchGraphCountInfoAMDX.__member(VkDeviceOrHostAddressConstAMDX.SIZEOF, VkDeviceOrHostAddressConstAMDX.ALIGNOF), VkDispatchGraphCountInfoAMDX.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        COUNT = layout.offsetof(0);
        INFOS = layout.offsetof(1);
        STRIDE = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDispatchGraphCountInfoAMDX, Buffer>
    implements NativeResource {
        private static final VkDispatchGraphCountInfoAMDX ELEMENT_FACTORY = VkDispatchGraphCountInfoAMDX.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDispatchGraphCountInfoAMDX getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int count() {
            return VkDispatchGraphCountInfoAMDX.ncount(this.address());
        }

        public VkDeviceOrHostAddressConstAMDX infos() {
            return VkDispatchGraphCountInfoAMDX.ninfos(this.address());
        }

        @NativeType(value="uint64_t")
        public long stride() {
            return VkDispatchGraphCountInfoAMDX.nstride(this.address());
        }

        public Buffer count(@NativeType(value="uint32_t") int value) {
            VkDispatchGraphCountInfoAMDX.ncount(this.address(), value);
            return this;
        }

        public Buffer infos(VkDeviceOrHostAddressConstAMDX value) {
            VkDispatchGraphCountInfoAMDX.ninfos(this.address(), value);
            return this;
        }

        public Buffer infos(Consumer<VkDeviceOrHostAddressConstAMDX> consumer) {
            consumer.accept(this.infos());
            return this;
        }

        public Buffer stride(@NativeType(value="uint64_t") long value) {
            VkDispatchGraphCountInfoAMDX.nstride(this.address(), value);
            return this;
        }
    }
}

