/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDescriptorPoolSize
extends Struct<VkDescriptorPoolSize>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int DESCRIPTORCOUNT;

    protected VkDescriptorPoolSize(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDescriptorPoolSize create(long address, @Nullable ByteBuffer container) {
        return new VkDescriptorPoolSize(address, container);
    }

    public VkDescriptorPoolSize(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDescriptorPoolSize.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDescriptorType")
    public int type() {
        return VkDescriptorPoolSize.ntype(this.address());
    }

    @NativeType(value="uint32_t")
    public int descriptorCount() {
        return VkDescriptorPoolSize.ndescriptorCount(this.address());
    }

    public VkDescriptorPoolSize type(@NativeType(value="VkDescriptorType") int value) {
        VkDescriptorPoolSize.ntype(this.address(), value);
        return this;
    }

    public VkDescriptorPoolSize descriptorCount(@NativeType(value="uint32_t") int value) {
        VkDescriptorPoolSize.ndescriptorCount(this.address(), value);
        return this;
    }

    public VkDescriptorPoolSize set(int type, int descriptorCount) {
        this.type(type);
        this.descriptorCount(descriptorCount);
        return this;
    }

    public VkDescriptorPoolSize set(VkDescriptorPoolSize src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDescriptorPoolSize malloc() {
        return new VkDescriptorPoolSize(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDescriptorPoolSize calloc() {
        return new VkDescriptorPoolSize(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDescriptorPoolSize create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDescriptorPoolSize(MemoryUtil.memAddress(container), container);
    }

    public static VkDescriptorPoolSize create(long address) {
        return new VkDescriptorPoolSize(address, null);
    }

    @Nullable
    public static VkDescriptorPoolSize createSafe(long address) {
        return address == 0L ? null : new VkDescriptorPoolSize(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDescriptorPoolSize.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDescriptorPoolSize.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkDescriptorPoolSize mallocStack() {
        return VkDescriptorPoolSize.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorPoolSize callocStack() {
        return VkDescriptorPoolSize.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDescriptorPoolSize mallocStack(MemoryStack stack) {
        return VkDescriptorPoolSize.malloc(stack);
    }

    @Deprecated
    public static VkDescriptorPoolSize callocStack(MemoryStack stack) {
        return VkDescriptorPoolSize.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDescriptorPoolSize.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDescriptorPoolSize.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDescriptorPoolSize.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDescriptorPoolSize.calloc(capacity, stack);
    }

    public static VkDescriptorPoolSize malloc(MemoryStack stack) {
        return new VkDescriptorPoolSize(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDescriptorPoolSize calloc(MemoryStack stack) {
        return new VkDescriptorPoolSize(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static int ndescriptorCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)DESCRIPTORCOUNT);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void ndescriptorCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DESCRIPTORCOUNT, value);
    }

    static {
        Struct.Layout layout = VkDescriptorPoolSize.__struct(VkDescriptorPoolSize.__member(4), VkDescriptorPoolSize.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        DESCRIPTORCOUNT = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkDescriptorPoolSize, Buffer>
    implements NativeResource {
        private static final VkDescriptorPoolSize ELEMENT_FACTORY = VkDescriptorPoolSize.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDescriptorPoolSize getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDescriptorType")
        public int type() {
            return VkDescriptorPoolSize.ntype(this.address());
        }

        @NativeType(value="uint32_t")
        public int descriptorCount() {
            return VkDescriptorPoolSize.ndescriptorCount(this.address());
        }

        public Buffer type(@NativeType(value="VkDescriptorType") int value) {
            VkDescriptorPoolSize.ntype(this.address(), value);
            return this;
        }

        public Buffer descriptorCount(@NativeType(value="uint32_t") int value) {
            VkDescriptorPoolSize.ndescriptorCount(this.address(), value);
            return this;
        }
    }
}

