/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkCopyCommandTransformInfoQCOM;
import org.lwjgl.vulkan.VkExtent3D;
import org.lwjgl.vulkan.VkImageSubresourceLayers;
import org.lwjgl.vulkan.VkOffset3D;

public class VkBufferImageCopy2
extends Struct<VkBufferImageCopy2>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int BUFFEROFFSET;
    public static final int BUFFERROWLENGTH;
    public static final int BUFFERIMAGEHEIGHT;
    public static final int IMAGESUBRESOURCE;
    public static final int IMAGEOFFSET;
    public static final int IMAGEEXTENT;

    protected VkBufferImageCopy2(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkBufferImageCopy2 create(long address, @Nullable ByteBuffer container) {
        return new VkBufferImageCopy2(address, container);
    }

    public VkBufferImageCopy2(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkBufferImageCopy2.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkBufferImageCopy2.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkBufferImageCopy2.npNext(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long bufferOffset() {
        return VkBufferImageCopy2.nbufferOffset(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferRowLength() {
        return VkBufferImageCopy2.nbufferRowLength(this.address());
    }

    @NativeType(value="uint32_t")
    public int bufferImageHeight() {
        return VkBufferImageCopy2.nbufferImageHeight(this.address());
    }

    public VkImageSubresourceLayers imageSubresource() {
        return VkBufferImageCopy2.nimageSubresource(this.address());
    }

    public VkOffset3D imageOffset() {
        return VkBufferImageCopy2.nimageOffset(this.address());
    }

    public VkExtent3D imageExtent() {
        return VkBufferImageCopy2.nimageExtent(this.address());
    }

    public VkBufferImageCopy2 sType(@NativeType(value="VkStructureType") int value) {
        VkBufferImageCopy2.nsType(this.address(), value);
        return this;
    }

    public VkBufferImageCopy2 sType$Default() {
        return this.sType(1000337009);
    }

    public VkBufferImageCopy2 pNext(@NativeType(value="void const *") long value) {
        VkBufferImageCopy2.npNext(this.address(), value);
        return this;
    }

    public VkBufferImageCopy2 pNext(VkCopyCommandTransformInfoQCOM value) {
        return this.pNext(value.pNext(this.pNext()).address());
    }

    public VkBufferImageCopy2 bufferOffset(@NativeType(value="VkDeviceSize") long value) {
        VkBufferImageCopy2.nbufferOffset(this.address(), value);
        return this;
    }

    public VkBufferImageCopy2 bufferRowLength(@NativeType(value="uint32_t") int value) {
        VkBufferImageCopy2.nbufferRowLength(this.address(), value);
        return this;
    }

    public VkBufferImageCopy2 bufferImageHeight(@NativeType(value="uint32_t") int value) {
        VkBufferImageCopy2.nbufferImageHeight(this.address(), value);
        return this;
    }

    public VkBufferImageCopy2 imageSubresource(VkImageSubresourceLayers value) {
        VkBufferImageCopy2.nimageSubresource(this.address(), value);
        return this;
    }

    public VkBufferImageCopy2 imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
        consumer.accept(this.imageSubresource());
        return this;
    }

    public VkBufferImageCopy2 imageOffset(VkOffset3D value) {
        VkBufferImageCopy2.nimageOffset(this.address(), value);
        return this;
    }

    public VkBufferImageCopy2 imageOffset(Consumer<VkOffset3D> consumer) {
        consumer.accept(this.imageOffset());
        return this;
    }

    public VkBufferImageCopy2 imageExtent(VkExtent3D value) {
        VkBufferImageCopy2.nimageExtent(this.address(), value);
        return this;
    }

    public VkBufferImageCopy2 imageExtent(Consumer<VkExtent3D> consumer) {
        consumer.accept(this.imageExtent());
        return this;
    }

    public VkBufferImageCopy2 set(int sType, long pNext, long bufferOffset, int bufferRowLength, int bufferImageHeight, VkImageSubresourceLayers imageSubresource, VkOffset3D imageOffset, VkExtent3D imageExtent) {
        this.sType(sType);
        this.pNext(pNext);
        this.bufferOffset(bufferOffset);
        this.bufferRowLength(bufferRowLength);
        this.bufferImageHeight(bufferImageHeight);
        this.imageSubresource(imageSubresource);
        this.imageOffset(imageOffset);
        this.imageExtent(imageExtent);
        return this;
    }

    public VkBufferImageCopy2 set(VkBufferImageCopy2 src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkBufferImageCopy2 malloc() {
        return new VkBufferImageCopy2(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkBufferImageCopy2 calloc() {
        return new VkBufferImageCopy2(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkBufferImageCopy2 create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkBufferImageCopy2(MemoryUtil.memAddress(container), container);
    }

    public static VkBufferImageCopy2 create(long address) {
        return new VkBufferImageCopy2(address, null);
    }

    @Nullable
    public static VkBufferImageCopy2 createSafe(long address) {
        return address == 0L ? null : new VkBufferImageCopy2(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkBufferImageCopy2.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkBufferImageCopy2.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkBufferImageCopy2 malloc(MemoryStack stack) {
        return new VkBufferImageCopy2(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkBufferImageCopy2 calloc(MemoryStack stack) {
        return new VkBufferImageCopy2(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static long nbufferOffset(long struct) {
        return UNSAFE.getLong(null, struct + (long)BUFFEROFFSET);
    }

    public static int nbufferRowLength(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERROWLENGTH);
    }

    public static int nbufferImageHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)BUFFERIMAGEHEIGHT);
    }

    public static VkImageSubresourceLayers nimageSubresource(long struct) {
        return VkImageSubresourceLayers.create(struct + (long)IMAGESUBRESOURCE);
    }

    public static VkOffset3D nimageOffset(long struct) {
        return VkOffset3D.create(struct + (long)IMAGEOFFSET);
    }

    public static VkExtent3D nimageExtent(long struct) {
        return VkExtent3D.create(struct + (long)IMAGEEXTENT);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nbufferOffset(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)BUFFEROFFSET, value);
    }

    public static void nbufferRowLength(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUFFERROWLENGTH, value);
    }

    public static void nbufferImageHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)BUFFERIMAGEHEIGHT, value);
    }

    public static void nimageSubresource(long struct, VkImageSubresourceLayers value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGESUBRESOURCE, VkImageSubresourceLayers.SIZEOF);
    }

    public static void nimageOffset(long struct, VkOffset3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGEOFFSET, VkOffset3D.SIZEOF);
    }

    public static void nimageExtent(long struct, VkExtent3D value) {
        MemoryUtil.memCopy(value.address(), struct + (long)IMAGEEXTENT, VkExtent3D.SIZEOF);
    }

    static {
        Struct.Layout layout = VkBufferImageCopy2.__struct(VkBufferImageCopy2.__member(4), VkBufferImageCopy2.__member(POINTER_SIZE), VkBufferImageCopy2.__member(8), VkBufferImageCopy2.__member(4), VkBufferImageCopy2.__member(4), VkBufferImageCopy2.__member(VkImageSubresourceLayers.SIZEOF, VkImageSubresourceLayers.ALIGNOF), VkBufferImageCopy2.__member(VkOffset3D.SIZEOF, VkOffset3D.ALIGNOF), VkBufferImageCopy2.__member(VkExtent3D.SIZEOF, VkExtent3D.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        BUFFEROFFSET = layout.offsetof(2);
        BUFFERROWLENGTH = layout.offsetof(3);
        BUFFERIMAGEHEIGHT = layout.offsetof(4);
        IMAGESUBRESOURCE = layout.offsetof(5);
        IMAGEOFFSET = layout.offsetof(6);
        IMAGEEXTENT = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<VkBufferImageCopy2, Buffer>
    implements NativeResource {
        private static final VkBufferImageCopy2 ELEMENT_FACTORY = VkBufferImageCopy2.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkBufferImageCopy2 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkBufferImageCopy2.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkBufferImageCopy2.npNext(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long bufferOffset() {
            return VkBufferImageCopy2.nbufferOffset(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferRowLength() {
            return VkBufferImageCopy2.nbufferRowLength(this.address());
        }

        @NativeType(value="uint32_t")
        public int bufferImageHeight() {
            return VkBufferImageCopy2.nbufferImageHeight(this.address());
        }

        public VkImageSubresourceLayers imageSubresource() {
            return VkBufferImageCopy2.nimageSubresource(this.address());
        }

        public VkOffset3D imageOffset() {
            return VkBufferImageCopy2.nimageOffset(this.address());
        }

        public VkExtent3D imageExtent() {
            return VkBufferImageCopy2.nimageExtent(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkBufferImageCopy2.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000337009);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkBufferImageCopy2.npNext(this.address(), value);
            return this;
        }

        public Buffer pNext(VkCopyCommandTransformInfoQCOM value) {
            return this.pNext(value.pNext(this.pNext()).address());
        }

        public Buffer bufferOffset(@NativeType(value="VkDeviceSize") long value) {
            VkBufferImageCopy2.nbufferOffset(this.address(), value);
            return this;
        }

        public Buffer bufferRowLength(@NativeType(value="uint32_t") int value) {
            VkBufferImageCopy2.nbufferRowLength(this.address(), value);
            return this;
        }

        public Buffer bufferImageHeight(@NativeType(value="uint32_t") int value) {
            VkBufferImageCopy2.nbufferImageHeight(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(VkImageSubresourceLayers value) {
            VkBufferImageCopy2.nimageSubresource(this.address(), value);
            return this;
        }

        public Buffer imageSubresource(Consumer<VkImageSubresourceLayers> consumer) {
            consumer.accept(this.imageSubresource());
            return this;
        }

        public Buffer imageOffset(VkOffset3D value) {
            VkBufferImageCopy2.nimageOffset(this.address(), value);
            return this;
        }

        public Buffer imageOffset(Consumer<VkOffset3D> consumer) {
            consumer.accept(this.imageOffset());
            return this;
        }

        public Buffer imageExtent(VkExtent3D value) {
            VkBufferImageCopy2.nimageExtent(this.address(), value);
            return this;
        }

        public Buffer imageExtent(Consumer<VkExtent3D> consumer) {
            consumer.accept(this.imageExtent());
            return this;
        }
    }
}

