/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkCalibratedTimestampInfoKHR;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkPhysicalDevice;

public class KHRCalibratedTimestamps {
    public static final int VK_KHR_CALIBRATED_TIMESTAMPS_SPEC_VERSION = 1;
    public static final String VK_KHR_CALIBRATED_TIMESTAMPS_EXTENSION_NAME = "VK_KHR_calibrated_timestamps";
    public static final int VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_KHR = 1000184000;

    protected KHRCalibratedTimestamps() {
        throw new UnsupportedOperationException();
    }

    public static int nvkGetPhysicalDeviceCalibrateableTimeDomainsKHR(VkPhysicalDevice physicalDevice, long pTimeDomainCount, long pTimeDomains) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceCalibrateableTimeDomainsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPI(physicalDevice.address(), pTimeDomainCount, pTimeDomains, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceCalibrateableTimeDomainsKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") IntBuffer pTimeDomainCount, @Nullable @NativeType(value="VkTimeDomainKHR *") IntBuffer pTimeDomains) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pTimeDomainCount, 1);
            Checks.checkSafe((Buffer)pTimeDomains, pTimeDomainCount.get(pTimeDomainCount.position()));
        }
        return KHRCalibratedTimestamps.nvkGetPhysicalDeviceCalibrateableTimeDomainsKHR(physicalDevice, MemoryUtil.memAddress(pTimeDomainCount), MemoryUtil.memAddressSafe(pTimeDomains));
    }

    public static int nvkGetCalibratedTimestampsKHR(VkDevice device, int timestampCount, long pTimestampInfos, long pTimestamps, long pMaxDeviation) {
        long __functionAddress = device.getCapabilities().vkGetCalibratedTimestampsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPPPI(device.address(), timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetCalibratedTimestampsKHR(VkDevice device, @NativeType(value="VkCalibratedTimestampInfoKHR const *") VkCalibratedTimestampInfoKHR.Buffer pTimestampInfos, @NativeType(value="uint64_t *") LongBuffer pTimestamps, @NativeType(value="uint64_t *") LongBuffer pMaxDeviation) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pTimestamps, pTimestampInfos.remaining());
            Checks.check((Buffer)pMaxDeviation, 1);
        }
        return KHRCalibratedTimestamps.nvkGetCalibratedTimestampsKHR(device, pTimestampInfos.remaining(), pTimestampInfos.address(), MemoryUtil.memAddress(pTimestamps), MemoryUtil.memAddress(pMaxDeviation));
    }

    @NativeType(value="VkResult")
    public static int vkGetPhysicalDeviceCalibrateableTimeDomainsKHR(VkPhysicalDevice physicalDevice, @NativeType(value="uint32_t *") int[] pTimeDomainCount, @Nullable @NativeType(value="VkTimeDomainKHR *") int[] pTimeDomains) {
        long __functionAddress = physicalDevice.getCapabilities().vkGetPhysicalDeviceCalibrateableTimeDomainsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pTimeDomainCount, 1);
            Checks.checkSafe(pTimeDomains, pTimeDomainCount[0]);
        }
        return JNI.callPPPI(physicalDevice.address(), pTimeDomainCount, pTimeDomains, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkGetCalibratedTimestampsKHR(VkDevice device, @NativeType(value="VkCalibratedTimestampInfoKHR const *") VkCalibratedTimestampInfoKHR.Buffer pTimestampInfos, @NativeType(value="uint64_t *") long[] pTimestamps, @NativeType(value="uint64_t *") long[] pMaxDeviation) {
        long __functionAddress = device.getCapabilities().vkGetCalibratedTimestampsKHR;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pTimestamps, pTimestampInfos.remaining());
            Checks.check(pMaxDeviation, 1);
        }
        return JNI.callPPPPI(device.address(), pTimestampInfos.remaining(), pTimestampInfos.address(), pTimestamps, pMaxDeviation, __functionAddress);
    }
}

