/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;

public class INTELAccelerator {
    public static final int CL_ACCELERATOR_DESCRIPTOR_INTEL = 16528;
    public static final int CL_ACCELERATOR_REFERENCE_COUNT_INTEL = 16529;
    public static final int CL_ACCELERATOR_CONTEXT_INTEL = 16530;
    public static final int CL_ACCELERATOR_TYPE_INTEL = 16531;
    public static final int CL_INVALID_ACCELERATOR_INTEL = -1094;
    public static final int CL_INVALID_ACCELERATOR_TYPE_INTEL = -1095;
    public static final int CL_INVALID_ACCELERATOR_DESCRIPTOR_INTEL = -1096;
    public static final int CL_ACCELERATOR_TYPE_NOT_SUPPORTED_INTEL = -1097;

    protected INTELAccelerator() {
        throw new UnsupportedOperationException();
    }

    public static long nclCreateAcceleratorINTEL(long context, int accelerator_type, long descriptor_size, long descriptor, long errcode_ret) {
        long __functionAddress = CL.getICD().clCreateAcceleratorINTEL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
        }
        return JNI.callPPPPP(context, accelerator_type, descriptor_size, descriptor, errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_accelerator_intel")
    public static long clCreateAcceleratorINTEL(@NativeType(value="cl_context") long context, @NativeType(value="cl_accelerator_type_intel") int accelerator_type, @NativeType(value="void const *") ByteBuffer descriptor, @Nullable @NativeType(value="cl_int *") IntBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe((Buffer)errcode_ret, 1);
        }
        return INTELAccelerator.nclCreateAcceleratorINTEL(context, accelerator_type, descriptor.remaining(), MemoryUtil.memAddress(descriptor), MemoryUtil.memAddressSafe(errcode_ret));
    }

    @NativeType(value="cl_int")
    public static int clRetainAcceleratorINTEL(@NativeType(value="cl_accelerator_intel") long accelerator) {
        long __functionAddress = CL.getICD().clRetainAcceleratorINTEL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(accelerator);
        }
        return JNI.callPI(accelerator, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clReleaseAcceleratorINTEL(@NativeType(value="cl_accelerator_intel") long accelerator) {
        long __functionAddress = CL.getICD().clReleaseAcceleratorINTEL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(accelerator);
        }
        return JNI.callPI(accelerator, __functionAddress);
    }

    public static int nclGetAcceleratorInfoINTEL(long accelerator, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetAcceleratorInfoINTEL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(accelerator);
        }
        return JNI.callPPPPI(accelerator, param_name, param_value_size, param_value, param_value_size_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetAcceleratorInfoINTEL(@NativeType(value="cl_accelerator_intel") long accelerator, @NativeType(value="cl_accelerator_info_intel") int param_name, @Nullable @NativeType(value="void *") ByteBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return INTELAccelerator.nclGetAcceleratorInfoINTEL(accelerator, param_name, Checks.remainingSafe(param_value), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetAcceleratorInfoINTEL(@NativeType(value="cl_accelerator_intel") long accelerator, @NativeType(value="cl_accelerator_info_intel") int param_name, @Nullable @NativeType(value="void *") IntBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return INTELAccelerator.nclGetAcceleratorInfoINTEL(accelerator, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_int")
    public static int clGetAcceleratorInfoINTEL(@NativeType(value="cl_accelerator_intel") long accelerator, @NativeType(value="cl_accelerator_info_intel") int param_name, @Nullable @NativeType(value="void *") PointerBuffer param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return INTELAccelerator.nclGetAcceleratorInfoINTEL(accelerator, param_name, Integer.toUnsignedLong(Checks.remainingSafe(param_value)) << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    @NativeType(value="cl_accelerator_intel")
    public static long clCreateAcceleratorINTEL(@NativeType(value="cl_context") long context, @NativeType(value="cl_accelerator_type_intel") int accelerator_type, @NativeType(value="void const *") ByteBuffer descriptor, @Nullable @NativeType(value="cl_int *") int[] errcode_ret) {
        long __functionAddress = CL.getICD().clCreateAcceleratorINTEL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(context);
            Checks.checkSafe(errcode_ret, 1);
        }
        return JNI.callPPPPP(context, accelerator_type, (long)descriptor.remaining(), MemoryUtil.memAddress(descriptor), errcode_ret, __functionAddress);
    }

    @NativeType(value="cl_int")
    public static int clGetAcceleratorInfoINTEL(@NativeType(value="cl_accelerator_intel") long accelerator, @NativeType(value="cl_accelerator_info_intel") int param_name, @Nullable @NativeType(value="void *") int[] param_value, @Nullable @NativeType(value="size_t *") PointerBuffer param_value_size_ret) {
        long __functionAddress = CL.getICD().clGetAcceleratorInfoINTEL;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(accelerator);
            Checks.checkSafe(param_value_size_ret, 1);
        }
        return JNI.callPPPPI(accelerator, param_name, Integer.toUnsignedLong(Checks.lengthSafe(param_value)) << 2, param_value, MemoryUtil.memAddressSafe(param_value_size_ret), __functionAddress);
    }
}

