/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.geochat;

import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ServiceConfigurationError;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.geochat.JsonQueryCallback;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.Logging;

public final class JsonQueryUtil
implements Runnable {
    private final String query;
    private final JsonQueryCallback callback;

    public static JsonObject query(String query) throws IOException {
        return JsonQueryUtil.query(query, false);
    }

    public static JsonObject query(String query, boolean logAtDebug) throws IOException {
        String serverURL = Config.getPref().get("geochat.server", "https://zverik.dev.openstreetmap.org/osmochat.php?action=");
        URI url = URI.create(serverURL + query);
        HttpClient.Response connection = HttpClient.create((URL)url.toURL()).setLogAtDebug(logAtDebug).connect();
        if (connection.getResponseCode() != 200) {
            throw new IOException("HTTP Response code " + connection.getResponseCode() + " (" + connection.getResponseMessage() + ")");
        }
        InputStream inp = connection.getContent();
        if (inp == null) {
            throw new IOException("Empty response");
        }
        try {
            JsonObject jsonObject;
            block13: {
                JsonReader reader = Json.createReader((InputStream)inp);
                try {
                    jsonObject = reader.readObject();
                    if (reader == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonException | ServiceConfigurationError e) {
                        throw new IOException("Failed to parse JSON: " + e.getMessage(), e);
                    }
                }
                reader.close();
            }
            return jsonObject;
        }
        finally {
            connection.disconnect();
        }
    }

    private JsonQueryUtil(String query, JsonQueryCallback callback) {
        this.query = query;
        this.callback = callback;
    }

    public static void queryAsync(String query, JsonQueryCallback callback) {
        MainApplication.worker.submit(new JsonQueryUtil(query, callback));
    }

    private void doRealRun() {
        JsonObject obj;
        try {
            obj = JsonQueryUtil.query(this.query);
        }
        catch (IOException e) {
            Logging.warn((String)(e.getClass().getName() + " while connecting to a chat server: " + e.getMessage()));
            obj = null;
        }
        if (this.callback != null) {
            this.callback.processJson(obj);
        }
    }

    @Override
    public void run() {
        if (EventQueue.isDispatchThread()) {
            new Thread(this::doRealRun).start();
        } else {
            this.doRealRun();
        }
    }
}

