/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.changeset.util;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.Logging;

public class DataSetChangesetBuilder {
    private DataSet dataSet;

    public BoundedChangesetDataSet build(String dataString) {
        this.dataSet = new DataSet();
        try (JsonReader reader = Json.createReader((Reader)new StringReader(dataString));){
            JsonObject jsonObject = reader.readObject();
            BoundedChangesetDataSet boundedChangesetDataSet = this.build(jsonObject.getJsonArray("elements"));
            return boundedChangesetDataSet;
        }
    }

    private BoundedChangesetDataSet build(JsonArray array) {
        for (JsonObject obj : array.getValuesAs(JsonObject.class)) {
            JsonObject old;
            String action = obj.getString("action");
            String type = obj.getString("type");
            JsonObject tags = obj.getJsonObject("tags");
            if ("delete".equals(action) && "node".equals(type) && !obj.isNull("old")) {
                old = obj.getJsonObject("old");
                this.processPoint(tags, old, action);
                continue;
            }
            if ("delete".equals(action) && "way".equals(type) && !obj.isNull("old")) {
                old = obj.getJsonObject("old");
                this.processLineString(tags, old, action);
                continue;
            }
            if ("create".equals(action) && "node".equals(type)) {
                this.processPoint(tags, obj, action);
                continue;
            }
            if ("create".equals(action) && "way".equals(type)) {
                this.processLineString(tags, obj, action);
                continue;
            }
            if ("modify".equals(action) && "way".equals(type)) {
                this.processLineString(tags, obj, "modify-new");
                old = obj.getJsonObject("old");
                this.processLineString(tags, old, "modify-old");
                continue;
            }
            if ("modify".equals(action) && "node".equals(type)) {
                this.processPoint(tags, obj, "modify-new");
                old = obj.getJsonObject("old");
                this.processPoint(tags, old, "modify-old");
                continue;
            }
            if ("modify".equals(action) && "relation".equals(type)) {
                old = obj.getJsonObject("old");
                Bounds boundsRelationOld = DataSetChangesetBuilder.buildRelation(old);
                this.bounds2rectangle(tags, boundsRelationOld, "modify-old-rel");
                Bounds boundsRelationNew = DataSetChangesetBuilder.buildRelation(obj);
                this.bounds2rectangle(tags, boundsRelationNew, "modify-new-rel");
                continue;
            }
            if ("create".equals(action) && "relation".equals(type)) {
                Bounds boundsRelationNew = DataSetChangesetBuilder.buildRelation(obj);
                this.bounds2rectangle(tags, boundsRelationNew, "create-rel");
                continue;
            }
            if (!"delete".equals(action) || !"relation".equals(type)) continue;
            old = obj.getJsonObject("old");
            Bounds boundsRelationNew = DataSetChangesetBuilder.buildRelation(old);
            this.bounds2rectangle(tags, boundsRelationNew, "delete-rel");
        }
        Bounds bounds = null;
        for (OsmPrimitive osmPrimitive : this.dataSet.allPrimitives()) {
            bounds = DataSetChangesetBuilder.mergeBounds(bounds, osmPrimitive);
        }
        return new BoundedChangesetDataSet(this.dataSet, bounds);
    }

    private void processPoint(JsonObject tags, JsonObject nodeJson, String action) {
        Node node = this.createNode(DataSetChangesetBuilder.newLatLon(nodeJson));
        DataSetChangesetBuilder.fillTagsFromFeature(tags, (OsmPrimitive)node, action);
    }

    private void processLineString(JsonObject tags, JsonObject wayJson, String action) {
        JsonArray arrayNodes = wayJson.getJsonArray("nodes");
        if (arrayNodes.isEmpty()) {
            return;
        }
        LinkedList<LatLon> coordinates = new LinkedList<LatLon>();
        for (int i = 0; i < arrayNodes.size(); ++i) {
            coordinates.add(DataSetChangesetBuilder.newLatLon(arrayNodes.getJsonObject(i)));
        }
        Way way = this.createWay(coordinates);
        DataSetChangesetBuilder.fillTagsFromFeature(tags, (OsmPrimitive)way, action);
    }

    private static void fillTagsFromFeature(JsonObject tags, OsmPrimitive primitive, String action) {
        if (tags != null) {
            primitive.setKeys(DataSetChangesetBuilder.getTags(tags, action));
        }
    }

    private Node createNode(LatLon latLon) {
        Node node = new Node(latLon);
        this.dataSet.addPrimitive((OsmPrimitive)node);
        return node;
    }

    private Way createWay(List<LatLon> coordinates) {
        if (coordinates.isEmpty()) {
            return null;
        }
        Way way = new Way();
        way.setNodes(coordinates.stream().map(this::createNode).collect(Collectors.toList()));
        this.dataSet.addPrimitive((OsmPrimitive)way);
        return way;
    }

    private static Map<String, String> getTags(JsonObject tags, String action) {
        TreeMap<String, String> mapTags = new TreeMap<String, String>();
        mapTags.put("action", action);
        for (Map.Entry entry : tags.entrySet()) {
            mapTags.put((String)entry.getKey(), String.valueOf(((JsonValue)entry.getValue()).toString()));
        }
        return mapTags;
    }

    private static Bounds mergeBounds(Bounds bounds, OsmPrimitive osmPrimitive) {
        if (osmPrimitive instanceof Node && ((Node)osmPrimitive).isLatLonKnown()) {
            return DataSetChangesetBuilder.mergeBounds(bounds, (ILatLon)osmPrimitive);
        }
        return bounds;
    }

    private static Bounds mergeBounds(Bounds bounds, ILatLon coords) {
        if (bounds == null) {
            return new Bounds(coords.lat(), coords.lon(), coords.lat(), coords.lon());
        }
        bounds.extend(coords.lat(), coords.lon());
        return bounds;
    }

    private void bounds2rectangle(JsonObject tags, Bounds bounds, String action) {
        if (bounds == null) {
            return;
        }
        double minLat = bounds.getMinLat();
        double minLon = bounds.getMinLon();
        double maxLat = bounds.getMaxLat();
        double maxLon = bounds.getMaxLon();
        List<Node> nodes = Arrays.asList(new Node(new LatLon(minLat, minLon)), new Node(new LatLon(minLat, maxLon)), new Node(new LatLon(maxLat, maxLon)), new Node(new LatLon(maxLat, minLon)), new Node(new LatLon(minLat, minLon)));
        Way way = new Way();
        way.setNodes(nodes);
        DataSetChangesetBuilder.fillTagsFromFeature(tags, (OsmPrimitive)way, action);
        this.dataSet.addPrimitiveRecursive((OsmPrimitive)way);
    }

    private static Bounds buildRelation(JsonObject obj) {
        DataSet dataSetRel = new DataSet();
        JsonArray members = obj.getJsonArray("members");
        for (int j = 0; j < members.size(); ++j) {
            JsonObject member = members.getJsonObject(j);
            String memberType = member.getString("type");
            if ("way".equals(memberType)) {
                dataSetRel.addPrimitive((OsmPrimitive)DataSetChangesetBuilder.processRelationLineString(member, dataSetRel));
                continue;
            }
            if (!"node".equals(memberType)) continue;
            dataSetRel.addPrimitive((OsmPrimitive)DataSetChangesetBuilder.newNode(member));
        }
        Bounds boundsRelationOld = null;
        for (OsmPrimitive osmPrimitive : dataSetRel.allPrimitives()) {
            boundsRelationOld = DataSetChangesetBuilder.mergeBounds(boundsRelationOld, osmPrimitive);
        }
        return boundsRelationOld;
    }

    private static LatLon newLatLon(JsonObject json) {
        JsonString latString = json.getJsonString("lat");
        JsonString lonString = json.getJsonString("lon");
        if (latString == null || lonString == null) {
            Logging.error((String)("Invalid JSON: " + String.valueOf(json)));
            return null;
        }
        return new LatLon(Double.parseDouble(latString.getString()), Double.parseDouble(lonString.getString()));
    }

    private static Node newNode(JsonObject nodeJson) {
        return new Node(DataSetChangesetBuilder.newLatLon(nodeJson));
    }

    private static Way processRelationLineString(JsonObject wayJson, DataSet dataSetOld) {
        JsonArray arrayNodes = wayJson.getJsonArray("nodes");
        Way way = new Way();
        if (arrayNodes.isEmpty()) {
            return way;
        }
        ArrayList<Node> nodes = new ArrayList<Node>(arrayNodes.size());
        for (int i = 0; i < arrayNodes.size(); ++i) {
            Node node = DataSetChangesetBuilder.newNode(arrayNodes.getJsonObject(i));
            dataSetOld.addPrimitive((OsmPrimitive)node);
            nodes.add(node);
        }
        way.setNodes(nodes);
        return way;
    }

    public static class BoundedChangesetDataSet {
        private final DataSet dataSet;
        private final Bounds bounds;

        public BoundedChangesetDataSet(DataSet dataSet, Bounds bounds) {
            this.dataSet = dataSet;
            this.bounds = bounds;
        }

        public Bounds getBounds() {
            return this.bounds;
        }

        public DataSet getDataSet() {
            return this.dataSet;
        }
    }
}

