/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.utils;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Area;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MapView;

public final class MapViewGeometryUtil {
    private MapViewGeometryUtil() {
    }

    public static Area getNonDownloadedArea(MapView mv, Iterable<Bounds> downloadBounds) {
        Rectangle b = mv.getBounds();
        b.grow(100, 100);
        Area a = new Area(b);
        for (Bounds bounds : downloadBounds) {
            Point p1 = mv.getPoint(bounds.getMin());
            Point p2 = mv.getPoint(bounds.getMax());
            Rectangle r = new Rectangle(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y), Math.abs(p2.x - p1.x), Math.abs(p2.y - p1.y));
            a.subtract(new Area(r));
        }
        return a;
    }
}

