/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.mode;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.util.Calendar;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.io.download.StreetsideDownloader;

public abstract class AbstractMode
extends MouseAdapter
implements NavigatableComponent.ZoomChangeListener {
    private static final int DOWNLOAD_COOLDOWN = 2000;
    private static SemiautomaticThread semiautomaticThread = new SemiautomaticThread();
    public final int cursor = 0;

    public static void resetThread() {
        semiautomaticThread.interrupt();
        semiautomaticThread = new SemiautomaticThread();
    }

    protected StreetsideImage getClosest(Point clickPoint) {
        double snapDistance = 10.0;
        double minDistance = Double.MAX_VALUE;
        StreetsideImage closest = null;
        for (StreetsideImage image : StreetsideLayer.getInstance().getData().getImages()) {
            Point imagePoint = MainApplication.getMap().mapView.getPoint((ILatLon)image);
            imagePoint.setLocation(imagePoint.getX(), imagePoint.getY());
            double dist = clickPoint.distanceSq(imagePoint);
            if (!(minDistance > dist) || !(clickPoint.distance(imagePoint) < snapDistance) || !image.visible()) continue;
            minDistance = dist;
            closest = image;
        }
        return closest;
    }

    public void zoomChanged() {
        if (StreetsideDownloader.getMode() == StreetsideDownloader.DOWNLOAD_MODE.VISIBLE_AREA) {
            if (!semiautomaticThread.isAlive()) {
                semiautomaticThread.start();
            }
            semiautomaticThread.moved();
        }
    }

    private static class SemiautomaticThread
    extends Thread {
        private long lastDownload;
        private boolean moved;

        private SemiautomaticThread() {
        }

        @Override
        public void run() {
            while (true) {
                if (this.moved && Calendar.getInstance().getTimeInMillis() - this.lastDownload >= 2000L) {
                    this.lastDownload = Calendar.getInstance().getTimeInMillis();
                    StreetsideDownloader.downloadVisibleArea();
                    this.moved = false;
                    StreetsideLayer.invalidateInstance();
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        public void moved() {
            this.moved = true;
        }
    }
}

