/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.io.download;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.plugins.streetside.StreetsideData;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideMainDialog;
import org.openstreetmap.josm.plugins.streetside.io.download.SequenceDownloadRunnable;
import org.openstreetmap.josm.plugins.streetside.utils.PluginState;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideUtils;

public class StreetsideSquareDownloadRunnable
implements Runnable {
    private final Bounds bounds;

    public StreetsideSquareDownloadRunnable(Bounds bounds) {
        this.bounds = bounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PluginState.startDownload();
        StreetsideUtils.updateHelpText();
        int zoom = 16;
        AtomicBoolean cancelled = new AtomicBoolean(false);
        AtomicInteger counter = new AtomicInteger();
        StreetsideData data = StreetsideLayer.getInstance().getData();
        DownloadRunnable.download(16, this.bounds, cancelled, counter, data);
        while (counter.get() > 0) {
            try {
                AtomicInteger atomicInteger = counter;
                synchronized (atomicInteger) {
                    counter.wait(100L);
                }
            }
            catch (InterruptedException e) {
                cancelled.set(true);
                Thread.currentThread().interrupt();
            }
        }
        if (Thread.interrupted()) {
            return;
        }
        PluginState.finishDownload();
        StreetsideUtils.updateHelpText();
        StreetsideLayer.invalidateInstance();
        StreetsideMainDialog.getInstance().updateImage();
    }

    private static TileXY getTile(int zoom, double lat, double lon) {
        double x = (lon + 180.0) / 360.0 * Math.pow(2.0, zoom);
        double y = (1.0 - Math.log(Math.tan(lat * Math.PI / 180.0) + 1.0 / Math.cos(lat * Math.PI / 180.0)) / Math.PI) * Math.pow(2.0, zoom - 1);
        return new TileXY(x, y);
    }

    private static Bounds getBounds(int zoom, int x, int y) {
        double minLon = StreetsideSquareDownloadRunnable.getLon(zoom, x);
        double maxLon = StreetsideSquareDownloadRunnable.getLon(zoom, x + 1);
        double maxLat = StreetsideSquareDownloadRunnable.getLat(zoom, y);
        double minLat = StreetsideSquareDownloadRunnable.getLat(zoom, y + 1);
        return new Bounds(minLat, minLon, maxLat, maxLon);
    }

    private static double getLon(int zoom, int x) {
        return (double)(360 * x) / Math.pow(2.0, zoom) - 180.0;
    }

    private static double getLat(int zoom, int y) {
        return Math.atan(Math.sinh(Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, zoom))) * 180.0 / Math.PI;
    }

    private record DownloadRunnable(int zoom, int x, int y, AtomicBoolean cancelled, AtomicInteger counter, StreetsideData data) implements Runnable
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.cancelled.get()) {
                    return;
                }
                Object newData = new SequenceDownloadRunnable(StreetsideSquareDownloadRunnable.getBounds(this.zoom, this.x, this.y)).call();
                if (newData.size() >= 500) {
                    DownloadRunnable.download(this.zoom + 1, StreetsideSquareDownloadRunnable.getBounds(this.zoom, this.x, this.y), this.cancelled, this.counter, this.data);
                    return;
                }
                if (this.cancelled.get()) {
                    return;
                }
                StreetsideData streetsideData = this.data;
                synchronized (streetsideData) {
                    this.data.addAll((Collection<StreetsideImage>)newData);
                }
            }
            finally {
                this.counter.decrementAndGet();
                AtomicInteger atomicInteger = this.counter;
                synchronized (atomicInteger) {
                    this.counter.notifyAll();
                }
            }
        }

        static void download(int zoom, Bounds bounds, AtomicBoolean cancelled, AtomicInteger counter, StreetsideData data) {
            TileXY min = StreetsideSquareDownloadRunnable.getTile(zoom, bounds.getMaxLat(), bounds.getMinLon());
            TileXY max = StreetsideSquareDownloadRunnable.getTile(zoom, bounds.getMinLat(), bounds.getMaxLon());
            for (int x = min.getXIndex(); x <= max.getXIndex(); ++x) {
                for (int y = min.getYIndex(); y <= max.getYIndex(); ++y) {
                    counter.incrementAndGet();
                    Thread.ofVirtual().name("streetside-" + zoom + "/" + x + "/" + y).start(new DownloadRunnable(zoom, x, y, cancelled, counter, data));
                }
            }
        }
    }
}

