/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.ImportImagePlugin;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.ImportImagePlugin.ImageLayer;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class LoadImageAction
extends JosmAction {
    public LoadImageAction() {
        super(I18n.tr((String)"Import image", (Object[])new Object[0]), (String)null, I18n.tr((String)"Import georeferenced image", (Object[])new Object[0]), null, true, "importimage/loadimage", true);
    }

    public void actionPerformed(ActionEvent event) {
        JFileChooser fc = new JFileChooser(Config.getPref().get("plugins.importimage.importpath", null));
        fc.setAcceptAllFileFilterUsed(false);
        int result = fc.showOpenDialog((Component)MainApplication.getMainFrame());
        if (result == 0) {
            ImageLayer layer;
            Config.getPref().put("plugins.importimage.importpath", fc.getCurrentDirectory().getAbsolutePath());
            Logging.info((String)"ImportImagePlugin LoadImageAction: File chosen: {0}", (Object[])new Object[]{fc.getSelectedFile()});
            try {
                layer = new ImageLayer(fc.getSelectedFile());
            }
            catch (ImageLayer.LayerCreationCanceledException e) {
                Logging.trace((Throwable)e);
                return;
            }
            catch (Exception e) {
                Logging.error((String)"ImportImagePlugin LoadImageAction: Error while creating image layer: \n{0}", (Object[])new Object[]{e.getMessage()});
                JOptionPane.showMessageDialog(null, I18n.marktr((String)("Error while creating image layer: " + String.valueOf(e.getCause()))));
                return;
            }
            MainApplication.getLayerManager().addLayer((Layer)layer);
            BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
            layer.visitBoundingBox(boundingXYVisitor);
            MainApplication.getMap().mapView.zoomTo(boundingXYVisitor);
        }
    }
}

