/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.jna.mac;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import java.nio.charset.StandardCharsets;
import org.openstreetmap.josm.plugins.jna.mac.FoundationLibrary;
import org.openstreetmap.josm.plugins.jna.mac.StringEncoding;

abstract class Foundation {
    private static final FoundationLibrary foundationLibrary = Native.load("Foundation", FoundationLibrary.class);

    private Foundation() {
    }

    public static void nsLog(String format, Object args) {
        NativeLong formatAsCFString = Foundation.cfString(format);
        try {
            foundationLibrary.NSLog(formatAsCFString, args);
        }
        finally {
            Foundation.cfRelease(formatAsCFString);
        }
    }

    static NativeLong cfString(String s) {
        byte[] utf16Bytes = s.getBytes(StandardCharsets.UTF_16LE);
        return foundationLibrary.CFStringCreateWithBytes(null, utf16Bytes, utf16Bytes.length, StringEncoding.kCFStringEncodingUTF16LE.value, (byte)0);
    }

    static void cfRelease(NativeLong id) {
        foundationLibrary.CFRelease(id);
    }
}

