/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.canvec_helper;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.io.importexport.OsmImporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.canvec_helper.CanvecLayer;
import org.openstreetmap.josm.tools.Logging;

class CanVecTile {
    private CanvecLayer layer;
    boolean canDownload = false;
    private List<String> subTileIds = new ArrayList<String>();
    private boolean zipScanned = false;
    private List<CanVecTile> subTiles = new ArrayList<CanVecTile>();
    private boolean subTilesMade = false;
    private List<String> index;
    private int depth;
    private int corda;
    private int cordc;
    private boolean valid = false;
    private String cordb;
    private String cordd;
    private Bounds bounds;
    String tileid;

    CanVecTile(String tileid, CanvecLayer layer) {
        String parta = tileid.substring(0, 3);
        String partb = tileid.substring(3, 4);
        String partc = tileid.substring(4, 6);
        String partd = tileid.substring(6);
        int a = Integer.parseInt(parta);
        int c = Integer.parseInt(partc);
        this.realInit(a, partb, c, partd, layer, new ArrayList<String>());
    }

    CanVecTile(int a, String b, int c, String d, CanvecLayer layer, List<String> index) {
        this.realInit(a, b, c, d, layer, index);
    }

    private void realInit(int a, String b, int c, String d, CanvecLayer layer, List<String> index) {
        double zeroPointLon;
        double zeroPointLat;
        this.index = index;
        this.layer = layer;
        this.corda = a;
        this.cordb = b;
        this.cordc = c;
        this.cordd = d;
        if (a >= 0 && a <= 119) {
            int column = a / 10;
            int row = a % 10;
            if (row > 6) {
                return;
            }
            zeroPointLat = 40 + 4 * row;
            zeroPointLon = -56 - 8 * column;
            if (row > 6) {
                return;
            }
        } else {
            return;
        }
        double latSpan = 4.0;
        double lonSpan = 8.0;
        this.depth = 1;
        int grid2 = b.isEmpty() ? 0 : b.charAt(0) - 64;
        int[] rows1 = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3};
        int[] cols1 = new int[]{0, 3, 2, 1, 0, 0, 1, 2, 3, 3, 2, 1, 0, 0, 1, 2, 3};
        double lat2 = zeroPointLat + latSpan / 4.0 * (double)rows1[grid2];
        double lon2 = zeroPointLon + lonSpan / 4.0 * (double)cols1[grid2];
        if (grid2 != 0) {
            latSpan /= 4.0;
            lonSpan /= 4.0;
            this.depth = 2;
        }
        int[] rows3 = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3};
        lat2 += latSpan / 4.0 * (double)rows3[c];
        int[] cols3 = new int[]{0, 3, 2, 1, 0, 0, 1, 2, 3, 3, 2, 1, 0, 0, 1, 2, 3};
        lon2 += lonSpan / 4.0 * (double)cols3[c];
        if (c != 0) {
            latSpan /= 4.0;
            lonSpan /= 4.0;
            this.depth = 3;
        }
        if (!this.cordd.isEmpty()) {
            this.depth = 4;
            String[] foo = this.cordd.split("\\.");
            for (int i = 0; i < foo.length && !"osm".equals(foo[i]); ++i) {
                int cell;
                if (foo[i].isEmpty()) continue;
                try {
                    cell = Integer.parseInt(foo[i]);
                }
                catch (NumberFormatException e) {
                    continue;
                }
                switch (cell) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        lat2 += latSpan / 2.0;
                        break;
                    }
                    case 2: {
                        lat2 += latSpan / 2.0;
                        lon2 += lonSpan / 2.0;
                        break;
                    }
                    case 3: {
                        lon2 += lonSpan / 2.0;
                    }
                }
                latSpan /= 2.0;
                lonSpan /= 2.0;
            }
        }
        this.bounds = new Bounds(lat2, lon2, lat2 + latSpan, lon2 + lonSpan);
        this.tileid = this.cordb.isEmpty() ? String.format("%03d", this.corda) : (this.cordc == 0 ? String.format("%03d%s", this.corda, this.cordb) : (this.cordd.isEmpty() ? String.format("%03d%s%02d", this.corda, this.cordb, this.cordc) : String.format("%03d%s%02d%s", this.corda, this.cordb, this.cordc, this.cordd)));
        this.valid = true;
    }

    boolean isValid() {
        return this.valid;
    }

    String getTileId() {
        return this.tileid;
    }

    boolean isVisible(Bounds view) {
        return view.intersects(this.bounds);
    }

    Point[] getCorners(MapView mv) {
        LatLon min = this.bounds.getMin();
        LatLon max = this.bounds.getMax();
        LatLon x1 = new LatLon(min.lat(), max.lon());
        LatLon x2 = new LatLon(max.lat(), min.lon());
        return new Point[]{mv.getPoint(min), mv.getPoint(x1), mv.getPoint(max), mv.getPoint(x2)};
    }

    public String getDownloadUrl() {
        return String.format("http://ftp2.cits.rncan.gc.ca/OSM/pub/%1$03d/%2$s/%1$03d%2$s%3$02d.zip", this.corda, this.cordb, this.cordc);
    }

    private ZipFile openZip() throws IOException {
        File downloadPath = this.layer.plugin.getPluginDirs().getUserDataDirectory(true);
        CachedFile tileZip = new CachedFile(this.getDownloadUrl()).setDestDir(downloadPath.toString());
        return new ZipFile(tileZip.getFile());
    }

    void downloadSelf() {
        ZipFile zipFile;
        if (this.zipScanned) {
            return;
        }
        try {
            zipFile = this.openZip();
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if ("Metadata.txt".equals(entry.getName())) continue;
            this.subTileIds.add(entry.getName());
            this.zipScanned = true;
            CanVecTile finalTile = new CanVecTile(entry.getName(), this.layer);
            if (!finalTile.isValid()) continue;
            this.subTiles.add(finalTile);
        }
    }

    void loadRawOsm() {
        try {
            ZipFile zipFile = this.openZip();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!this.tileid.equals(entry.getName())) continue;
                InputStream rawtile = zipFile.getInputStream(entry);
                OsmImporter importer = new OsmImporter();
                OsmImporter.OsmImporterData temp = importer.loadLayer(rawtile, null, entry.getName(), null);
                MainApplication.worker.submit(temp.getPostLayerTask());
                MainApplication.getLayerManager().addLayer((Layer)temp.getLayer());
                temp.getLayer().data.setUploadPolicy(UploadPolicy.NORMAL);
            }
        }
        catch (IOException | IllegalDataException e) {
            Logging.error((Throwable)e);
            return;
        }
    }

    private void makeSubTiles(int layer) {
        ArrayList<String> buffer = new ArrayList<String>();
        if (this.subTilesMade) {
            return;
        }
        switch (layer) {
            case 1: {
                Pattern p = Pattern.compile("\\d\\d\\d([A-Z]).*");
                String lastCell = "";
                for (int i = 0; i < this.index.size(); ++i) {
                    Matcher m = p.matcher(this.index.get(i));
                    m.matches();
                    String cell = m.group(1);
                    if (cell.equals(lastCell)) {
                        buffer.add(m.group(0));
                    } else if (lastCell.isEmpty()) {
                        buffer.add(m.group(0));
                    } else {
                        this.subTiles.add(new CanVecTile(this.corda, lastCell, 0, "", this.layer, buffer));
                        buffer = new ArrayList();
                        buffer.add(m.group(0));
                    }
                    lastCell = cell;
                }
                this.subTiles.add(new CanVecTile(this.corda, lastCell, 0, "", this.layer, buffer));
                break;
            }
            case 2: {
                Pattern p = Pattern.compile("\\d\\d\\d[A-Z](\\d\\d).*");
                int lastCell2 = -1;
                for (int i = 0; i < this.index.size(); ++i) {
                    Matcher m = p.matcher(this.index.get(i));
                    m.matches();
                    int cell = Integer.parseInt(m.group(1));
                    if (cell == lastCell2) {
                        buffer.add(m.group(0));
                    } else if (lastCell2 == -1) {
                        buffer.add(m.group(0));
                    } else {
                        this.subTiles.add(new CanVecTile(this.corda, this.cordb, lastCell2, "", this.layer, buffer));
                        buffer = new ArrayList();
                        buffer.add(m.group(0));
                    }
                    lastCell2 = cell;
                }
                if (lastCell2 == -1) break;
                this.subTiles.add(new CanVecTile(this.corda, this.cordb, lastCell2, "", this.layer, buffer));
            }
        }
        this.subTilesMade = true;
    }

    void paint(Graphics2D g, MapView mv, Bounds bounds, int maxZoom) {
        boolean showSubTiles = false;
        if (!this.isVisible(bounds)) {
            return;
        }
        if (this.depth == 4) {
            this.layer.openable.add(this);
        }
        if (this.depth == 3 && bounds.getArea() < 0.5) {
            if (this.zipScanned) {
                showSubTiles = true;
            } else if (this.canDownload) {
                this.downloadSelf();
                showSubTiles = true;
            } else {
                this.layer.downloadable.add(this);
            }
        } else if (this.depth == 2 && bounds.getArea() < 20.0) {
            this.makeSubTiles(2);
            showSubTiles = true;
        } else if (this.depth == 1 && bounds.getArea() < 40.0) {
            this.makeSubTiles(1);
            showSubTiles = true;
        }
        if (showSubTiles && this.depth < maxZoom) {
            for (int i = 0; i < this.subTiles.size(); ++i) {
                CanVecTile tile = this.subTiles.get(i);
                tile.paint(g, mv, bounds, maxZoom);
            }
        } else {
            Point[] corners = this.getCorners(mv);
            int[] xs = new int[]{corners[0].x, corners[1].x, corners[2].x, corners[3].x};
            int[] ys = new int[]{corners[0].y, corners[1].y, corners[2].y, corners[3].y};
            Polygon shape = new Polygon(xs, ys, 4);
            g.draw(shape);
            g.drawString(this.getTileId(), corners[0].x, corners[0].y);
        }
    }
}

