/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.media.jai.kernel;

import javax.media.jai.KernelJAI;
import org.jaitools.numeric.CompareOp;

public class KernelUtil {
    public static KernelJAI standardize(KernelJAI kernel) {
        float[] data = kernel.getKernelData();
        float sum = 0.0f;
        for (float f : data) {
            sum += f;
        }
        int i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / sum;
        }
        return new KernelJAI(kernel.getWidth(), kernel.getHeight(), kernel.getXOrigin(), kernel.getYOrigin(), data);
    }

    public static KernelJAI setElement(KernelJAI kernel, int x, int y, float newValue) {
        if (kernel == null) {
            throw new IllegalArgumentException("kernel must not be null");
        }
        float[] data = kernel.getKernelData();
        int w = kernel.getWidth();
        int h = kernel.getHeight();
        if (x < 0 || x >= w) {
            throw new IllegalArgumentException("x out of bounds: " + x);
        }
        if (y < 0 || y >= w) {
            throw new IllegalArgumentException("y out of bounds: " + y);
        }
        int index = y * w + x;
        data[index] = newValue;
        return new KernelJAI(w, h, kernel.getXOrigin(), kernel.getYOrigin(), data);
    }

    public static String kernelToString(KernelJAI kernel, boolean multiLine) {
        float[] data = kernel.getKernelData();
        int w = kernel.getWidth();
        int h = kernel.getHeight();
        StringBuilder sb = new StringBuilder();
        boolean binaryData = true;
        for (int i = 0; i < data.length && binaryData; ++i) {
            if (CompareOp.aequal(data[i], 0.0f) || CompareOp.aequal(data[i], 1.0f)) continue;
            binaryData = false;
        }
        int k = 0;
        sb.append("[");
        for (int i = 0; i < w; ++i) {
            sb.append("[");
            int j = 0;
            while (j < h) {
                if (binaryData) {
                    sb.append((int)data[k]);
                } else {
                    sb.append(String.format("%.4f", Float.valueOf(data[k])));
                    if (j < w - 1) {
                        sb.append(" ");
                    }
                }
                ++j;
                ++k;
            }
            sb.append("]");
            if (i >= w - 1) continue;
            if (multiLine) {
                sb.append("\n ");
                continue;
            }
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

