/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import java.util.List;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.Position2D;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;
import si.uom.SI;

public abstract class GeostationarySatellite
extends MapProjection {
    private static final long serialVersionUID = 1L;
    final double h;
    final double radius_g;
    final double radius_g_1;
    final double C;
    private static final double SQRT2 = Math.sqrt(2.0);

    public GeostationarySatellite(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        List<GeneralParameterDescriptor> expected = this.getParameterDescriptors().descriptors();
        double a = this.semiMajor;
        this.h = this.doubleValue(expected, Provider.SATELLITE_HEIGHT, parameters);
        this.radius_g_1 = this.h / a;
        this.radius_g = 1.0 + this.radius_g_1;
        this.C = this.radius_g * this.radius_g - 1.0;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup values = super.getParameterValues();
        ParameterDescriptorGroup descriptor = this.getParameterDescriptors();
        List<GeneralParameterDescriptor> expected = descriptor.descriptors();
        this.set(expected, Provider.SATELLITE_HEIGHT, values, this.h);
        return values;
    }

    public static Bounds circumscribeFullDisk(CoordinateReferenceSystem geosCRS) throws TransformException, FactoryException {
        if (!GeostationarySatellite.isGeostationaryCRS(geosCRS)) {
            return null;
        }
        MathTransform mt = CRS.findMathTransform(geosCRS, (CoordinateReferenceSystem)CRS.getProjectedCRS(geosCRS).getBaseCRS(), true);
        MathTransform imt = mt.inverse();
        ParameterValueGroup parameters = CRS.getMapProjection(geosCRS).getParameterValues();
        double semiMajorAxis = parameters.parameter("semi_major").doubleValue();
        double satelliteHeight = parameters.parameter("satellite_height").doubleValue();
        double centralMeridian = parameters.parameter("central_meridian").doubleValue();
        Position2D dp2d = new Position2D();
        double halfFoVRadians = Math.acos(semiMajorAxis / (satelliteHeight + semiMajorAxis));
        double halfFoVDegrees = Math.toDegrees(halfFoVRadians);
        dp2d.setLocation(centralMeridian - halfFoVDegrees, 0.0);
        imt.transform(dp2d, dp2d);
        double xMin = dp2d.getX();
        dp2d.setLocation(centralMeridian + halfFoVDegrees, 0.0);
        imt.transform(dp2d, dp2d);
        double xMax = dp2d.getX();
        dp2d.setLocation(centralMeridian, -halfFoVDegrees);
        imt.transform(dp2d, dp2d);
        double yMin = dp2d.getY();
        dp2d.setLocation(centralMeridian, halfFoVDegrees);
        imt.transform(dp2d, dp2d);
        double yMax = dp2d.getY();
        GeneralBounds bounds = new GeneralBounds(geosCRS);
        bounds.setEnvelope(xMin, yMin, xMax, yMax);
        return bounds;
    }

    public static Bounds inscribeFullDiskEstimate(CoordinateReferenceSystem geosCRS) throws TransformException, FactoryException {
        Bounds circumscribed = GeostationarySatellite.circumscribeFullDisk(geosCRS);
        return circumscribed == null ? null : GeostationarySatellite.doInscribeFullDisk(circumscribed);
    }

    static Bounds doInscribeFullDisk(Bounds circumscribed) {
        double dx = circumscribed.getSpan(0) / SQRT2;
        double dy = circumscribed.getSpan(1) / SQRT2;
        GeneralBounds bounds = new GeneralBounds(circumscribed.getCoordinateReferenceSystem());
        bounds.setEnvelope(circumscribed.getMedian(0) - dx / 2.0, circumscribed.getMedian(1) - dy / 2.0, circumscribed.getMedian(0) + dx / 2.0, circumscribed.getMedian(1) + dy / 2.0);
        return bounds;
    }

    static boolean isGeostationaryCRS(CoordinateReferenceSystem crs) {
        if (crs == null) {
            return false;
        }
        String code = crs.getName().getCode();
        return "GEOS".equals(code) || "Geostationary_Satellite".equals(code);
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        public static final ParameterDescriptor SATELLITE_HEIGHT = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "satellite_height")}, 3.5785831E7, 0.0, Double.POSITIVE_INFINITY, SI.METRE);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "GEOS"), new NamedIdentifier(Citations.OGC, "Geostationary_Satellite")}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, SATELLITE_HEIGHT, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            if (Provider.isSpherical(parameters)) {
                return new Spherical(parameters);
            }
            return new Ellipsoidal(parameters);
        }
    }

    public static class Ellipsoidal
    extends GeostationarySatellite {
        private static final long serialVersionUID = 1L;
        final double radius_p;
        final double radius_p2;
        final double radius_p_inv2;

        public Ellipsoidal(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
            double es = this.excentricitySquared;
            double one_es = 1.0 - es;
            double rone_es = 1.0 / one_es;
            this.radius_p = Math.sqrt(one_es);
            this.radius_p2 = one_es;
            this.radius_p_inv2 = rone_es;
        }

        @Override
        protected Point2D transformNormalized(double lambda, double phi, Point2D p2d) throws ProjectionException {
            double Vz;
            double Vy;
            double r = this.radius_p / Math.hypot(this.radius_p * Math.cos(phi = Math.atan(this.radius_p2 * Math.tan(phi))), Math.sin(phi));
            double Vx = r * Math.cos(lambda) * Math.cos(phi);
            if ((this.radius_g - Vx) * Vx - (Vy = r * Math.sin(lambda) * Math.cos(phi)) * Vy - (Vz = r * Math.sin(phi)) * Vz * this.radius_p_inv2 < 0.0) {
                throw new ProjectionException();
            }
            double tmp = this.radius_g - Vx;
            double x = this.radius_g_1 * Math.atan(Vy / tmp);
            double y = this.radius_g_1 * Math.atan(Vz / Math.hypot(Vy, tmp));
            p2d.setLocation(x, y);
            return p2d;
        }

        @Override
        protected Point2D inverseTransformNormalized(double x, double y, Point2D p2d) throws ProjectionException {
            double Vx = -1.0;
            double Vy = Math.tan(x / this.radius_g_1);
            double Vz = Math.tan(y / this.radius_g_1) * Math.hypot(1.0, Vy);
            double a = Vz / this.radius_p;
            double b = 2.0 * this.radius_g * Vx;
            double det = b * b - 4.0 * (a = Vy * Vy + a * a + Vx * Vx) * this.C;
            if (det < 0.0) {
                throw new ProjectionException();
            }
            double k = (-b - Math.sqrt(det)) / (2.0 * a);
            Vx = this.radius_g + k * Vx;
            double lambda = Math.atan2(Vy *= k, Vx);
            double phi = Math.atan((Vz *= k) * Math.cos(lambda) / Vx);
            phi = Math.atan(this.radius_p_inv2 * Math.tan(phi));
            p2d.setLocation(lambda, phi);
            return p2d;
        }
    }

    public static class Spherical
    extends GeostationarySatellite {
        private static final long serialVersionUID = 1L;
        final double radius_p;
        final double radius_p2;
        final double radius_p_inv2;

        public Spherical(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
            this.radius_p_inv2 = 1.0;
            this.radius_p2 = 1.0;
            this.radius_p = 1.0;
        }

        @Override
        protected Point2D transformNormalized(double lambda, double phi, Point2D p2d) throws ProjectionException {
            double Vz;
            double Vy;
            double tmp = Math.cos(phi);
            double Vx = Math.cos(lambda) * tmp;
            if ((this.radius_g - Vx) * Vx - (Vy = Math.sin(lambda) * tmp) * Vy - (Vz = Math.sin(phi)) * Vz < 0.0) {
                throw new ProjectionException();
            }
            tmp = this.radius_g - Vx;
            double x = this.radius_g_1 * Math.atan(Vy / tmp);
            double y = this.radius_g_1 * Math.atan(Vz / Math.hypot(Vy, tmp));
            p2d.setLocation(x, y);
            return p2d;
        }

        @Override
        protected Point2D inverseTransformNormalized(double x, double y, Point2D p2d) throws ProjectionException {
            double Vz;
            double Vx = -1.0;
            double b = 2.0 * this.radius_g * Vx;
            double Vy = Math.tan(x / (this.radius_g - 1.0));
            double a = Vy * Vy + (Vz = Math.tan(y / (this.radius_g - 1.0)) * Math.sqrt(1.0 + Vy * Vy)) * Vz + Vx * Vx;
            double det = b * b - 4.0 * a * this.C;
            if (det < 0.0) {
                throw new ProjectionException("Det less than 0: " + det);
            }
            double k = (-b - Math.sqrt(det)) / (2.0 * a);
            Vx = this.radius_g + k * Vx;
            double lambda = Math.atan2(Vy *= k, Vx);
            double phi = Math.atan((Vz *= k) * Math.cos(lambda) / Vx);
            p2d.setLocation(lambda, phi);
            return p2d;
        }
    }
}

