/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.geotools.api.metadata.quality.PositionalAccuracy;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.ConcatenatedOperation;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransformFactory;
import org.geotools.api.referencing.operation.SingleOperation;
import org.geotools.api.referencing.operation.Transformation;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.AbstractCoordinateOperation;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.Classes;
import org.geotools.util.UnmodifiableArrayList;

public class DefaultConcatenatedOperation
extends AbstractCoordinateOperation
implements ConcatenatedOperation {
    private static final long serialVersionUID = 4199619838029045700L;
    private final List<SingleOperation> operations;

    public DefaultConcatenatedOperation(String name, CoordinateOperation ... operations) {
        this(Collections.singletonMap("name", name), operations);
    }

    public DefaultConcatenatedOperation(Map<String, ?> properties, CoordinateOperation ... operations) {
        this(properties, new ArrayList<SingleOperation>(operations.length), operations);
    }

    public DefaultConcatenatedOperation(Map<String, ?> properties, CoordinateOperation[] operations, MathTransformFactory factory) throws FactoryException {
        this(properties, new ArrayList<SingleOperation>(operations.length), operations, factory);
    }

    private DefaultConcatenatedOperation(Map<String, ?> properties, ArrayList<SingleOperation> list, CoordinateOperation ... operations) {
        this(properties, DefaultConcatenatedOperation.expand(operations, list), list);
    }

    private DefaultConcatenatedOperation(Map<String, ?> properties, ArrayList<SingleOperation> list, CoordinateOperation[] operations, MathTransformFactory factory) throws FactoryException {
        this(properties, DefaultConcatenatedOperation.expand(operations, list, factory, true), list);
    }

    private DefaultConcatenatedOperation(Map<String, ?> properties, MathTransform transform, List<SingleOperation> operations) {
        super(DefaultConcatenatedOperation.mergeAccuracy(properties, operations), operations.get(0).getSourceCRS(), operations.get(operations.size() - 1).getTargetCRS(), transform);
        this.operations = UnmodifiableArrayList.wrap(operations.toArray(new SingleOperation[operations.size()]));
    }

    private static MathTransform expand(CoordinateOperation[] operations, List<SingleOperation> list) {
        try {
            return DefaultConcatenatedOperation.expand(operations, list, null, true);
        }
        catch (FactoryException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    private static MathTransform expand(CoordinateOperation[] operations, List<SingleOperation> target, MathTransformFactory factory, boolean wantTransform) throws FactoryException {
        int size;
        MathTransform transform = null;
        DefaultConcatenatedOperation.ensureNonNull("operations", operations);
        for (int i = 0; i < operations.length; ++i) {
            DefaultConcatenatedOperation.ensureNonNull("operations", operations, i);
            CoordinateOperation op = operations[i];
            if (op instanceof SingleOperation) {
                target.add((SingleOperation)op);
            } else if (op instanceof ConcatenatedOperation) {
                ConcatenatedOperation cop = (ConcatenatedOperation)op;
                List<SingleOperation> cops = cop.getOperations();
                DefaultConcatenatedOperation.expand(cops.toArray(new CoordinateOperation[cops.size()]), target, factory, false);
            } else {
                throw new IllegalArgumentException(MessageFormat.format("Class '{0}' is illegal. It must be '{1}' or a derivated class.", Classes.getClass(op), SingleOperation.class));
            }
            if (i != 0) {
                int dim2;
                int dim1;
                CoordinateReferenceSystem previous = operations[i - 1].getTargetCRS();
                CoordinateReferenceSystem next = op.getSourceCRS();
                if (previous != null && next != null && (dim1 = previous.getCoordinateSystem().getDimension()) != (dim2 = next.getCoordinateSystem().getDimension())) {
                    throw new IllegalArgumentException(MessageFormat.format("Mismatched object dimension: {0}D and {1}D.", dim1, dim2));
                }
            }
            if (!wantTransform) continue;
            MathTransform step = op.getMathTransform();
            transform = transform == null ? step : (factory != null ? factory.createConcatenatedTransform(transform, step) : ConcatenatedTransform.create(transform, step));
        }
        if (wantTransform && (size = target.size()) <= 1) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter \"{0}\" is missing.", "operations[" + size + "]"));
        }
        return transform;
    }

    private static Map<String, ?> mergeAccuracy(Map<String, ?> properties, List<? extends CoordinateOperation> operations) {
        if (!properties.containsKey("coordinateOperationAccuracy")) {
            LinkedHashSet<PositionalAccuracy> accuracy = null;
            for (CoordinateOperation coordinateOperation : operations) {
                Collection<PositionalAccuracy> candidates;
                if (!(coordinateOperation instanceof Transformation) || (candidates = coordinateOperation.getCoordinateOperationAccuracy()) == null || candidates.isEmpty()) continue;
                if (accuracy == null) {
                    accuracy = new LinkedHashSet<PositionalAccuracy>();
                }
                accuracy.addAll(candidates);
            }
            if (accuracy != null) {
                HashMap merged = new HashMap(properties);
                merged.put("coordinateOperationAccuracy", accuracy.toArray(new PositionalAccuracy[accuracy.size()]));
                return merged;
            }
        }
        return properties;
    }

    @Override
    public List<SingleOperation> getOperations() {
        return this.operations;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            DefaultConcatenatedOperation that = (DefaultConcatenatedOperation)object;
            return DefaultConcatenatedOperation.equals(this.operations, that.operations, compareMetadata);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.operations.hashCode() ^ 0xFD679FC4;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        String label = super.formatWKT(formatter);
        for (SingleOperation operation : this.operations) {
            formatter.append(operation);
        }
        return label;
    }
}

