/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import javax.xml.namespace.QName;
import org.geotools.api.temporal.Instant;
import org.geotools.api.temporal.Period;
import org.geotools.api.temporal.Position;
import org.geotools.gml3.GML;
import org.geotools.temporal.object.DefaultInstant;
import org.geotools.temporal.object.DefaultPeriod;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;

public class TimePeriodTypeBinding
extends AbstractComplexBinding {
    @Override
    public QName getTarget() {
        return GML.TimePeriodType;
    }

    public Class getType() {
        return Period.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        Instant begin = null;
        Instant end = null;
        if (node.hasChild("begin")) {
            begin = (Instant)node.getChildValue("begin");
        } else {
            Position beginPosition = (Position)node.getChildValue("beginPosition");
            begin = new DefaultInstant(beginPosition);
        }
        if (node.hasChild("end")) {
            end = (Instant)node.getChildValue("end");
        } else {
            Position endPosition = (Position)node.getChildValue("endPosition");
            end = new DefaultInstant(endPosition);
        }
        if (begin == null || end == null) {
            throw new IllegalArgumentException("Time period begin/end not specified");
        }
        return new DefaultPeriod(begin, end);
    }
}

