/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.simple;

import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.xsd.Encoder;
import org.locationtech.jts.geom.LineString;
import org.xml.sax.helpers.AttributesImpl;

class LineStringEncoder
extends GeometryEncoder<LineString> {
    static final QualifiedName LINE_STRING = new QualifiedName("http://www.opengis.net/gml", "LineString", "gml");
    QualifiedName element;

    protected LineStringEncoder(Encoder encoder, String gmlPrefix) {
        this(encoder, LINE_STRING.derive(gmlPrefix));
    }

    protected LineStringEncoder(Encoder encoder, QualifiedName element) {
        super(encoder);
        this.element = element;
    }

    @Override
    public void encode(LineString geometry, AttributesImpl atts, GMLWriter handler) throws Exception {
        handler.startElement(this.element, atts);
        handler.coordinates(geometry.getCoordinateSequence());
        handler.endElement(this.element);
    }
}

