/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.ContentState;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class EventContentFeatureWriter
implements FeatureWriter<SimpleFeatureType, SimpleFeature> {
    ContentState state;
    SimpleFeature feature;
    ContentFeatureStore store;
    FeatureWriter<SimpleFeatureType, SimpleFeature> writer;

    public EventContentFeatureWriter(ContentFeatureStore store, FeatureWriter<SimpleFeatureType, SimpleFeature> writer) {
        this.store = store;
        this.writer = writer;
        this.state = store.getState();
        Transaction t = this.state.getTransaction();
        if (t != Transaction.AUTO_COMMIT) {
            t.putState(this, new EventContentTransactionState());
        }
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.writer.getFeatureType();
    }

    @Override
    public SimpleFeature next() throws IOException {
        if (this.writer == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        this.feature = this.writer.next();
        return this.feature;
    }

    @Override
    public void remove() throws IOException {
        if (this.writer == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        this.state.fireFeatureRemoved(this.store, this.feature);
        this.writer.remove();
    }

    @Override
    public void write() throws IOException {
        if (this.writer == null) {
            throw new IOException("FeatureWriter has been closed");
        }
        this.writer.write();
        if (this.feature == null) {
            throw new IOException("No feature available to write");
        }
        if (this.writer.hasNext()) {
            ReferencedEnvelope bounds = ReferencedEnvelope.reference(this.feature.getBounds());
            this.state.fireFeatureUpdated(this.store, this.feature, bounds);
            this.feature = null;
        } else {
            this.state.fireFeatureAdded(this.store, this.feature);
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.writer == null) {
            return false;
        }
        return this.writer.hasNext();
    }

    @Override
    public void close() throws IOException {
        Transaction t = this.state.getTransaction();
        if (t != Transaction.AUTO_COMMIT) {
            t.removeState(this);
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        this.feature = null;
    }

    class EventContentTransactionState
    implements Transaction.State {
        EventContentTransactionState() {
        }

        @Override
        public void commit() throws IOException {
            EventContentFeatureWriter.this.store.getState().fireBatchFeatureEvent(true);
        }

        @Override
        public void rollback() throws IOException {
            EventContentFeatureWriter.this.store.getState().fireBatchFeatureEvent(false);
        }

        @Override
        public void setTransaction(Transaction transaction) {
        }

        @Override
        public void addAuthorization(String AuthID) throws IOException {
        }
    }
}

