/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.datasource;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.data.DataSourceException;
import org.geotools.data.jdbc.datasource.AbstractDataSourceFactorySpi;

public class DBCPDataSourceFactory
extends AbstractDataSourceFactorySpi {
    public static final DataAccessFactory.Param DSTYPE = new DataAccessFactory.Param("dstype", String.class, "Must be DBCP", false, null, Collections.singletonMap("level", "program"));
    public static final DataAccessFactory.Param USERNAME = new DataAccessFactory.Param("username", String.class, "User name to login as", false);
    public static final DataAccessFactory.Param PASSWORD = new DataAccessFactory.Param("password", String.class, "Password used to login", false);
    public static final DataAccessFactory.Param JDBC_URL = new DataAccessFactory.Param("jdbcUrl", String.class, "The JDBC url (check the JDBC driver docs to find out its format)", true);
    public static final DataAccessFactory.Param DRIVERCLASS = new DataAccessFactory.Param("driverClassName", String.class, "The JDBC driver class name (check the JDBC driver docs to find out its name)", true);
    public static final DataAccessFactory.Param MAXACTIVE = new DataAccessFactory.Param("maxActive", Integer.class, "The maximum number of active connections in the pool", true);
    public static final DataAccessFactory.Param MAXIDLE = new DataAccessFactory.Param("maxIdle", Integer.class, "The maximum number of idle connections in the pool", true);
    private static final DataAccessFactory.Param[] PARAMS = new DataAccessFactory.Param[]{DSTYPE, DRIVERCLASS, JDBC_URL, USERNAME, PASSWORD, MAXACTIVE, MAXIDLE};

    @Override
    public DataSource createDataSource(Map<String, ?> params) throws IOException {
        return this.createNewDataSource(params);
    }

    @Override
    public boolean canProcess(Map<String, ?> params) {
        return super.canProcess(params) && "DBCP".equals(params.get("dstype"));
    }

    @Override
    public DataSource createNewDataSource(Map<String, ?> params) throws IOException {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName((String)DRIVERCLASS.lookUp(params));
        dataSource.setUrl((String)JDBC_URL.lookUp(params));
        dataSource.setUsername((String)USERNAME.lookUp(params));
        dataSource.setPassword((String)PASSWORD.lookUp(params));
        dataSource.setAccessToUnderlyingConnectionAllowed(true);
        dataSource.setMaxActive((Integer)MAXACTIVE.lookUp(params));
        dataSource.setMaxIdle((Integer)MAXIDLE.lookUp(params));
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new DataSourceException("Connection pool improperly set up: " + e.getMessage(), e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return dataSource;
    }

    @Override
    public String getDescription() {
        return "A BDCP connection pool.";
    }

    @Override
    public DataAccessFactory.Param[] getParametersInfo() {
        return PARAMS;
    }

    @Override
    public boolean isAvailable() {
        try {
            new BasicDataSource();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

