/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureLock;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.LockingManager;
import org.geotools.api.data.Query;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultServiceInfo;

final class DataStoreAdaptor
implements DataStore {
    private Name name;
    private SimpleFeatureSource source;
    private SimpleFeatureType schema;
    private String typeName;

    public DataStoreAdaptor(SimpleFeatureSource source) {
        this.source = source;
        this.schema = (SimpleFeatureType)source.getSchema();
        this.name = this.schema.getName();
        this.typeName = this.name.getLocalPart();
    }

    @Override
    public void updateSchema(Name name, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("DataStoreAdaptor does not support modification");
    }

    @Override
    public void removeSchema(Name name) throws IOException {
        throw new UnsupportedOperationException("DataStoreAdaptor does not support modification");
    }

    @Override
    public SimpleFeatureType getSchema(Name name) throws IOException {
        if (this.name.equals(name)) {
            return this.schema;
        }
        throw new IOException("Not found: " + name + " DataStoreAdaptor datastore contains " + this.name);
    }

    @Override
    public List<Name> getNames() throws IOException {
        return Collections.singletonList(this.name);
    }

    @Override
    public ServiceInfo getInfo() {
        DefaultServiceInfo info = new DefaultServiceInfo();
        info.setDescription("DataStoreAdaptor " + this.name);
        info.setTitle(this.name.getLocalPart());
        return info;
    }

    private void ensureNotDisposed() throws IOException {
        if (this.source == null) {
            throw new IOException("DataStoreAdaptor is not available as it has been disposed");
        }
    }

    @Override
    public void dispose() {
        this.source = null;
        this.schema = null;
        this.name = null;
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("DataStoreAdaptor does not support modification");
    }

    @Override
    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("DataStoreAdaptor does not support modification");
    }

    @Override
    public void removeSchema(String typeName) throws IOException {
        throw new UnsupportedOperationException("DataStoreAdaptor does not support modification");
    }

    @Override
    public String[] getTypeNames() throws IOException {
        this.ensureNotDisposed();
        return new String[]{this.typeName};
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        this.ensureNotDisposed();
        if (this.typeName.equals(typeName)) {
            return this.schema;
        }
        throw new IOException("Not found: " + typeName + " DataStoreAdaptor datastore contains " + this.typeName);
    }

    @Override
    public LockingManager getLockingManager() {
        return new LockingManager(){

            @Override
            public void unLockFeatureID(String typeName, String authID, Transaction transaction, FeatureLock featureLock) throws IOException {
            }

            @Override
            public boolean release(String authID, Transaction transaction) throws IOException {
                return false;
            }

            @Override
            public boolean refresh(String authID, Transaction transaction) throws IOException {
                return false;
            }

            @Override
            public void lockFeatureID(String typeName, String authID, Transaction transaction, FeatureLock featureLock) throws IOException {
            }

            @Override
            public boolean exists(String authID) {
                return false;
            }
        };
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("DataStoreAdaptor does not support modification");
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("DataStoreAdaptor does not support modification");
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException("DataStoreAdaptor does not support modification");
    }

    @Override
    public SimpleFeatureSource getFeatureSource(Name name) throws IOException {
        this.ensureNotDisposed();
        if (this.name.equals(name)) {
            return this.source;
        }
        throw new IOException("Not found: " + name + "DataStoreAdaptor contains " + this.typeName);
    }

    @Override
    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        this.ensureNotDisposed();
        if (this.typeName.equals(typeName)) {
            return this.source;
        }
        throw new IOException("Not found: " + typeName + " DataStoreAdaptor contains " + this.typeName);
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        this.ensureNotDisposed();
        if (this.typeName.equals(query.getTypeName())) {
            return DataUtilities.reader(this.source.getFeatures());
        }
        throw new IOException("Not found: " + query.getTypeName() + " DataStoreAdaptor contains " + this.typeName);
    }
}

