/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.processing.operation;

import it.geosolutions.jaiext.JAIExt;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.range.Range;
import it.geosolutions.jaiext.range.RangeFactory;
import it.geosolutions.jaiext.utilities.ImageLayout2;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.operator.MosaicDescriptor;
import javax.media.jai.operator.MosaicType;
import org.geotools.api.coverage.Coverage;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.metadata.spatial.PixelOrientation;
import org.geotools.api.parameter.InvalidParameterValueException;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.coverage.processing.CoverageProcessingException;
import org.geotools.coverage.processing.OperationJAI;
import org.geotools.coverage.processing.operation.GridCoverage2DRIA;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ImageUtilities;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.ImagingParameterDescriptors;
import org.geotools.parameter.ImagingParameters;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;

public class Mosaic
extends OperationJAI {
    private static final int THRESHOLD_PARAM = 3;
    private static final int BACKGROUND_PARAM = 4;
    private static final int NODATA_RANGE_PARAM = 5;
    private static final int MOSAIC_TYPE_PARAM = 0;
    private static final int ALPHA_PARAM = 1;
    private static final int ROI_PARAM = 2;
    public static final String POLICY = "policy";
    public static final String GEOMETRY = "geometry";
    public static final String SOURCES_NAME = "Sources";
    public static final String OUTNODATA_NAME = "outputNoData";
    public static final String ALPHA_NAME = "alphas";
    public static final ParameterDescriptor<Collection> SOURCES = new DefaultParameterDescriptor<Object>(Citations.JAI, "Sources", Collection.class, null, null, null, null, null, true);
    public static final ParameterDescriptor<GridGeometry> GG = new DefaultParameterDescriptor<Object>(Citations.JAI, "geometry", GridGeometry.class, null, null, null, null, null, false);
    public static final ParameterDescriptor<String> GEOMETRY_POLICY = new DefaultParameterDescriptor<Object>(Citations.JAI, "policy", String.class, null, null, null, null, null, false);
    public static final ParameterDescriptor<double[]> OUTPUT_NODATA = new DefaultParameterDescriptor<Object>(Citations.JAI, "outputNoData", double[].class, null, null, null, null, null, false);
    public static final ParameterDescriptor<Collection> ALPHA = new DefaultParameterDescriptor<Object>(Citations.JAI, "alphas", Collection.class, null, null, null, null, null, false);
    private static Set<ParameterDescriptor> REPLACED_DESCRIPTORS;

    public Mosaic() {
        super(Mosaic.getOperationDescriptor("Mosaic"), new ImagingParameterDescriptors(Mosaic.getOperationDescriptor("Mosaic"), REPLACED_DESCRIPTORS));
    }

    @Override
    public Coverage doOperation(ParameterValueGroup parameters, Hints hints) throws CoverageProcessingException {
        ArrayList<GridCoverage2D> sourceCollection = new ArrayList<GridCoverage2D>();
        this.extractSources(parameters, sourceCollection, null);
        int numSources = sourceCollection.size();
        GridCoverage2D[] sources = new GridCoverage2D[numSources];
        sourceCollection.toArray(sources);
        GridCoverage2D firstCoverage = sources[0];
        CoordinateReferenceSystem crs = firstCoverage.getCoordinateReferenceSystem();
        for (GridCoverage2D source : sources) {
            CoordinateReferenceSystem crsSource = source.getCoordinateReferenceSystem();
            if (CRS.equalsIgnoreMetadata(crs, crsSource)) continue;
            throw new CoverageProcessingException("Input Coverages have different CRS");
        }
        Params params = this.prepareParameters(parameters, sources, hints);
        return this.deriveGridCoverage(sources, params);
    }

    private Params prepareParameters(ParameterValueGroup parameters, GridCoverage2D[] sources, Hints hints) {
        double[] nodatas;
        int i;
        ImagingParameters copy = (ImagingParameters)this.descriptor.createValue();
        ParameterBlockJAI block = (ParameterBlockJAI)copy.parameters;
        GridGeometryPolicy policy = null;
        Object externalGG = parameters.parameter(GEOMETRY).getValue();
        GridGeometry2D gg = null;
        if (externalGG != null && externalGG instanceof GridGeometry2D) {
            gg = (GridGeometry2D)externalGG;
            policy = GridGeometryPolicy.EXTERNAL;
        } else {
            Object ggPolicy = parameters.parameter(POLICY).getValue();
            if (ggPolicy != null && ggPolicy instanceof String) {
                policy = GridGeometryPolicy.getPolicyFromString((String)ggPolicy);
            }
        }
        if (policy == null) {
            policy = GridGeometryPolicy.FIRST;
        }
        Object alphaBandList = parameters.parameter(ALPHA_NAME).getValue();
        GridCoverage2D[] alphaCovs = null;
        if (alphaBandList != null && alphaBandList instanceof Collection) {
            Collection alphas = (Collection)alphaBandList;
            alphaCovs = new GridCoverage2D[alphas.size()];
            alphas.toArray(alphaCovs);
        }
        ResampledRasters rr = policy.resampleGridGeometry(sources, alphaCovs, gg, parameters, hints);
        RenderedImage[] rasters = rr.getRasters();
        ROI[] newRois = rr.getRois();
        GridGeometry2D finalGeometry = rr.getFinalGeometry();
        if (finalGeometry == null) {
            throw new CoverageProcessingException("No final GridGeometry found");
        }
        int numSources = rasters.length;
        if (Boolean.TRUE.equals(hints.get(JAI.KEY_REPLACE_INDEX_COLOR_MODEL))) {
            for (i = 0; i < numSources; ++i) {
                RenderedImage source = rasters[i];
                if (source.getColorModel() instanceof IndexColorModel) {
                    source = new ImageWorker(source).forceComponentColorModel().getRenderedImage();
                }
                block.setSource(source, i);
            }
            hints = new Hints(hints);
            hints.add(new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, Boolean.FALSE));
            hints.add(new RenderingHints(JAI.KEY_TRANSFORM_ON_COLORMAP, Boolean.TRUE));
        } else {
            for (i = 0; i < numSources; ++i) {
                block.setSource(rasters[i], i);
            }
        }
        double[] nodata = null;
        Object outputNodata = parameters.parameter(OUTNODATA_NAME).getValue();
        nodata = outputNodata != null && outputNodata instanceof double[] ? (double[])outputNodata : CoverageUtilities.getBackgroundValues(sources[0]);
        block.set((Object)nodata, 4);
        ROI[] rois = new ROI[numSources];
        for (int i2 = 0; i2 < numSources; ++i2) {
            rois[i2] = newRois != null && newRois[i2] != null ? newRois[i2] : new ROIShape(PlanarImage.wrapRenderedImage(rasters[i2]).getBounds());
        }
        block.set((Object)rois, 2);
        if (rr.getAlphas() != null) {
            block.set((Object)rr.getAlphas(), 1);
        }
        double threshold = CoverageUtilities.getMosaicThreshold(rasters[0].getSampleModel().getDataType());
        block.set((Object)new double[][]{{threshold}}, 3);
        block.set((Object)MosaicDescriptor.MOSAIC_TYPE_OVERLAY, 0);
        if (JAIExt.isJAIExtOperation("Mosaic") && (nodatas = rr.getBackgrounds()) != null && rr.hasNoData()) {
            Range[] ranges = new Range[numSources];
            for (int i3 = 0; i3 < numSources; ++i3) {
                double value = nodatas[i3];
                ranges[i3] = RangeFactory.create(value, value);
            }
            block.set((Object)ranges, 5);
        }
        Params params = new Params(block, hints, finalGeometry);
        params.rr = rr;
        return params;
    }

    private GridCoverage2D deriveGridCoverage(GridCoverage2D[] sources, Params parameters) {
        GridCoverage2D primarySource = sources[0];
        RenderingHints hintsStart = ImageUtilities.getRenderingHints(parameters.getSource());
        RenderingHints hints = null;
        if (parameters.hints != null) {
            if (hintsStart != null) {
                hints = new Hints(hintsStart);
                hints.add(parameters.hints);
            } else {
                hints = new Hints(parameters.hints);
            }
        }
        ImageLayout layoutOld = hints != null ? (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT) : null;
        ImageLayout layout = null;
        if (layoutOld != null) {
            layout = (ImageLayout)layoutOld.clone();
            layout.unsetValid(1);
            layout.unsetValid(2);
            layout.unsetValid(4);
            layout.unsetValid(8);
            layout.unsetValid(512);
            layout.unsetValid(256);
        } else {
            layout = new ImageLayout2();
        }
        GridEnvelope2D gridRange = parameters.finalGeometry.getGridRange2D();
        layout.setMinX(gridRange.x);
        layout.setMinY(gridRange.y);
        layout.setWidth(gridRange.width);
        layout.setHeight(gridRange.height);
        if (hints == null) {
            hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        } else {
            hints.put(JAI.KEY_IMAGE_LAYOUT, layout);
        }
        InternationalString name = this.deriveName(sources, -1, null);
        CoordinateReferenceSystem crs = primarySource.getCoordinateReferenceSystem();
        MathTransform toCRS = parameters.finalGeometry.getGridToCRS();
        RenderedImage data = this.createRenderedImage(parameters.parameters, hints);
        Map<String, ?> properties = this.getProperties(data, crs, name, toCRS, sources, parameters);
        return Mosaic.getFactory(parameters.hints).create(name, data, crs, toCRS, this.getOutputSampleDimensions(primarySource.getSampleDimensions(), data), sources, properties);
    }

    @Override
    protected RenderedImage createRenderedImage(ParameterBlockJAI parameters, RenderingHints hints) {
        parameters.getSources();
        RenderedImage[] images = parameters.getSources().toArray(new RenderedImage[parameters.getSources().size()]);
        MosaicType type = (MosaicType)this.getParameter(parameters, 0);
        PlanarImage[] alphas = (PlanarImage[])this.getParameter(parameters, 1);
        ROI[] rois = (ROI[])this.getParameter(parameters, 2);
        double[][] thresholds = (double[][])this.getParameter(parameters, 3);
        Range[] noData = (Range[])this.getParameter(parameters, 5);
        double[] backgrounds = (double[])this.getParameter(parameters, 4);
        if (rois != null && rois.length > 0 && Arrays.stream(rois).anyMatch(r -> r != null)) {
            RenderingHints newHints = new RenderingHints(Collections.emptyMap());
            newHints.putAll((Map<?, ?>)hints);
            newHints.put(ImageWorker.FORCE_MOSAIC_ROI_PROPERTY, (Object)true);
            hints = newHints;
        }
        ImageWorker iw = new ImageWorker();
        iw.setRenderingHints(hints);
        iw.setBackground(backgrounds);
        iw.mosaic(images, type, alphas, rois, thresholds, noData);
        return iw.getRenderedImage();
    }

    private <T> T getParameter(ParameterBlockJAI pb, int index) {
        if (pb.getNumParameters() > index) {
            Object result = pb.getObjectParameter(index);
            return (T)result;
        }
        return null;
    }

    private GridSampleDimension[] getOutputSampleDimensions(GridSampleDimension[] sampleDimensions, RenderedImage data) {
        int outputNumBands = data.getSampleModel().getNumBands();
        if (outputNumBands == sampleDimensions.length) {
            return sampleDimensions;
        }
        GridSampleDimension[] newSampleDimensions = new GridSampleDimension[outputNumBands];
        for (int i = 0; i < newSampleDimensions.length; ++i) {
            newSampleDimensions[i] = new GridSampleDimension("Band" + i);
        }
        return newSampleDimensions;
    }

    protected Map<String, ?> getProperties(RenderedImage data, CoordinateReferenceSystem crs, InternationalString name, MathTransform gridToCRS, GridCoverage2D[] sources, Params parameters) {
        Object nodataParam;
        HashMap<String, Object> properties;
        if (sources[0].getProperties() == null) {
            properties = new HashMap<String, Object>();
        } else {
            Map props = sources[0].getProperties();
            properties = new HashMap(props);
        }
        ParameterBlockJAI jai = parameters.parameters;
        int numSources = jai.getNumSources();
        ResampledRasters rr = parameters.rr;
        if (rr != null && rr.getRois() != null) {
            ROI[] rois = rr.getRois();
            ROI finalROI = null;
            for (int i = 0; i < numSources; ++i) {
                if (finalROI == null) {
                    finalROI = rois[i];
                    continue;
                }
                if (rois[i] == null) {
                    RenderedImage ri = sources[i].getRenderedImage();
                    finalROI = finalROI.add(new ROIShape(new Rectangle2D.Double(ri.getMinX(), ri.getMinY(), ri.getWidth(), ri.getHeight())));
                    continue;
                }
                finalROI = finalROI.add(rois[i]);
            }
            CoverageUtilities.setROIProperty(properties, finalROI);
        }
        if ((nodataParam = jai.getObjectParameter(4)) != null && rr != null && rr.hasNoData()) {
            CoverageUtilities.setNoDataProperty(properties, nodataParam);
        }
        return properties;
    }

    @Override
    protected void extractSources(ParameterValueGroup parameters, Collection<GridCoverage2D> sources, String[] sourceNames) throws ParameterNotFoundException, InvalidParameterValueException {
        Utilities.ensureNonNull("parameters", parameters);
        Utilities.ensureNonNull("sources", sources);
        Object srcCoverages = parameters.parameter(SOURCES_NAME).getValue();
        if (!(srcCoverages instanceof Collection) || ((Collection)srcCoverages).isEmpty() || !(((Collection)srcCoverages).iterator().next() instanceof GridCoverage2D)) {
            throw new InvalidParameterValueException(MessageFormat.format("Illegal value for argument \"{0}\".", "sources"), "sources", srcCoverages);
        }
        Collection sourceCoverages = (Collection)srcCoverages;
        sources.addAll(sourceCoverages);
    }

    static {
        HashSet<ParameterDescriptor<Object>> replacedDescriptors = new HashSet<ParameterDescriptor<Object>>();
        replacedDescriptors.add(SOURCES);
        replacedDescriptors.add(GG);
        replacedDescriptors.add(GEOMETRY_POLICY);
        replacedDescriptors.add(OUTPUT_NODATA);
        replacedDescriptors.add(ALPHA);
        REPLACED_DESCRIPTORS = Collections.unmodifiableSet(replacedDescriptors);
    }

    private static final class ResampledRasters {
        private RenderedImage[] rasters;
        private GridGeometry2D finalGeometry;
        private PlanarImage[] alphas;
        private double[] nodata;
        private ROI[] rois;
        private boolean hasNoData;

        private ResampledRasters() {
        }

        public RenderedImage[] getRasters() {
            return this.rasters;
        }

        public void setRasters(RenderedImage[] rasters) {
            this.rasters = rasters;
        }

        public GridGeometry2D getFinalGeometry() {
            return this.finalGeometry;
        }

        public void setFinalGeometry(GridGeometry2D finalGeometry) {
            this.finalGeometry = finalGeometry;
        }

        public PlanarImage[] getAlphas() {
            return this.alphas;
        }

        public void setAlphas(PlanarImage[] alphas) {
            this.alphas = alphas;
        }

        public double[] getBackgrounds() {
            return this.nodata;
        }

        public void setBackgrounds(double[] nodata) {
            this.nodata = nodata;
        }

        public ROI[] getRois() {
            return this.rois;
        }

        public void setRois(ROI[] rois) {
            this.rois = rois;
        }

        public boolean hasNoData() {
            return this.hasNoData;
        }

        public void setHasNoData(boolean hasNoData) {
            this.hasNoData = hasNoData;
        }
    }

    protected static final class Params {
        public ResampledRasters rr;
        public final ParameterBlockJAI parameters;
        public final GridGeometry2D finalGeometry;
        public final Hints hints;

        Params(ParameterBlockJAI parameters, Hints hints, GridGeometry2D finalGeometry) {
            this.parameters = parameters;
            this.hints = hints;
            this.finalGeometry = finalGeometry;
        }

        final RenderedImage getSource() {
            int n = this.parameters.getNumSources();
            for (int i = 0; i < n; ++i) {
                Object source = this.parameters.getSource(i);
                if (!(source instanceof RenderedImage)) continue;
                return (RenderedImage)source;
            }
            return null;
        }
    }

    public static enum GridGeometryPolicy {
        FIRST("first"){

            @Override
            public ResampledRasters resampleGridGeometry(GridCoverage2D[] sources, GridCoverage2D[] alphas, GridGeometry2D external, ParameterValueGroup parameters, Hints hints) {
                int index = 0;
                GridGeometry2D finalGG = GridGeometryPolicy.extractFinalGridGeometry(sources, index);
                return GridGeometryPolicy.resampleCoverages(sources, alphas, finalGG, parameters, hints);
            }
        }
        ,
        FINE("fine"){

            @Override
            public ResampledRasters resampleGridGeometry(GridCoverage2D[] sources, GridCoverage2D[] alphas, GridGeometry2D external, ParameterValueGroup parameters, Hints hints) {
                int numSources = sources.length;
                GridGeometry2D grid = sources[0].getGridGeometry();
                ReferencedEnvelope env = grid.getEnvelope2D();
                GridEnvelope2D gridEnv = grid.getGridRange2D();
                double res = env.getWidth() / (double)gridEnv.width;
                int index = 0;
                for (int i = 1; i < numSources; ++i) {
                    GridGeometry2D gridI = sources[i].getGridGeometry();
                    ReferencedEnvelope envI = gridI.getEnvelope2D();
                    GridEnvelope2D gridEnvI = gridI.getGridRange2D();
                    double resValue = envI.getWidth() / (double)gridEnvI.width;
                    if (!(resValue < res)) continue;
                    res = resValue;
                    index = i;
                }
                GridGeometry2D finalGG = GridGeometryPolicy.extractFinalGridGeometry(sources, index);
                return GridGeometryPolicy.resampleCoverages(sources, alphas, finalGG, parameters, hints);
            }
        }
        ,
        COARSE("coarse"){

            @Override
            public ResampledRasters resampleGridGeometry(GridCoverage2D[] sources, GridCoverage2D[] alphas, GridGeometry2D external, ParameterValueGroup parameters, Hints hints) {
                int numSources = sources.length;
                GridGeometry2D grid = sources[0].getGridGeometry();
                ReferencedEnvelope env = grid.getEnvelope2D();
                GridEnvelope2D gridEnv = grid.getGridRange2D();
                double res = env.getWidth() / (double)gridEnv.width;
                int index = 0;
                for (int i = 1; i < numSources; ++i) {
                    GridGeometry2D gridI = sources[i].getGridGeometry();
                    ReferencedEnvelope envI = gridI.getEnvelope2D();
                    GridEnvelope2D gridEnvI = gridI.getGridRange2D();
                    double resValue = envI.getWidth() / (double)gridEnvI.width;
                    if (!(resValue > res)) continue;
                    res = resValue;
                    index = i;
                }
                GridGeometry2D finalGG = GridGeometryPolicy.extractFinalGridGeometry(sources, index);
                return GridGeometryPolicy.resampleCoverages(sources, alphas, finalGG, parameters, hints);
            }
        }
        ,
        EXTERNAL("external"){

            @Override
            public ResampledRasters resampleGridGeometry(GridCoverage2D[] sources, GridCoverage2D[] alphas, GridGeometry2D external, ParameterValueGroup parameters, Hints hints) {
                if (external == null) {
                    throw new CoverageProcessingException("No input GridGeometry found");
                }
                return GridGeometryPolicy.resampleCoverages(sources, alphas, external, parameters, hints);
            }
        };

        private String name;

        private GridGeometryPolicy(String name) {
            this.name = name;
        }

        public abstract ResampledRasters resampleGridGeometry(GridCoverage2D[] var1, GridCoverage2D[] var2, GridGeometry2D var3, ParameterValueGroup var4, Hints var5);

        public static GridGeometryPolicy getPolicyFromString(String policyString) {
            if (policyString.equalsIgnoreCase(GridGeometryPolicy.FIRST.name)) {
                return FIRST;
            }
            if (policyString.equalsIgnoreCase(GridGeometryPolicy.FINE.name)) {
                return FINE;
            }
            if (policyString.equalsIgnoreCase(GridGeometryPolicy.COARSE.name)) {
                return COARSE;
            }
            if (policyString.equalsIgnoreCase(GridGeometryPolicy.EXTERNAL.name)) {
                return EXTERNAL;
            }
            return null;
        }

        private static ResampledRasters resampleCoverages(GridCoverage2D[] sources, GridCoverage2D[] alphas, GridGeometry2D external, ParameterValueGroup parameters, Hints hints) {
            int numSources = sources.length;
            RenderedImage[] rasters = new RenderedImage[numSources];
            double[] backgrounds = new double[numSources];
            ROI[] rois = new ROI[numSources];
            boolean hasNoDataProp = false;
            MathTransform2D g2w = external.getGridToCRS2D(PixelOrientation.UPPER_LEFT);
            double[] nodata = null;
            Object outputNodata = parameters.parameter(Mosaic.OUTNODATA_NAME).getValue();
            if (outputNodata != null && outputNodata instanceof double[]) {
                nodata = (double[])outputNodata;
            }
            boolean hasAlpha = alphas != null && alphas.length > 0;
            PlanarImage[] alphaArray = new PlanarImage[numSources];
            for (int i = 0; i < numSources; ++i) {
                Object property;
                GridCoverage2DRIA.GridCoverage2DRIAPropertyGenerator propertyGenerator;
                Object property2;
                NoDataContainer noDataProperty;
                MathTransform2D w2gD;
                GridCoverage2D coverage = sources[i];
                GridGeometry2D inputGG = coverage.getGridGeometry();
                MathTransform2D g2wS = inputGG.getGridToCRS2D(PixelOrientation.UPPER_LEFT);
                MathTransform concatenated = ConcatenatedTransform.create(g2wS, w2gD = external.getCRSToGrid2D(PixelOrientation.UPPER_LEFT));
                if (concatenated != null && concatenated.isIdentity()) {
                    double fillValue;
                    RenderedImage renderedImage;
                    rasters[i] = renderedImage = coverage.getRenderedImage();
                    rois[i] = CoverageUtilities.getROIProperty(coverage);
                    if (hasAlpha && alphas[i] != null) {
                        GridGeometryPolicy.checkAlpha(coverage, alphas[i]);
                        alphaArray[i] = PlanarImage.wrapRenderedImage(alphas[i].getRenderedImage());
                        if (rois[i] != null) {
                            ImageWorker w = new ImageWorker(alphaArray[i]);
                            ImageWorker w1 = new ImageWorker(rois[i].getAsImage());
                            ImageLayout layout = new ImageLayout();
                            layout.setMinX(alphaArray[i].getMinX());
                            layout.setMinY(alphaArray[i].getMinY());
                            layout.setWidth(alphaArray[i].getWidth());
                            layout.setHeight(alphaArray[i].getHeight());
                            w1.setRenderingHint(JAI.KEY_IMAGE_LAYOUT, layout);
                            w1.translate(0.0f, 0.0f, null);
                            w.mask(w1.getRenderedImage(), false, 0);
                        }
                    }
                    backgrounds[i] = fillValue = CoverageUtilities.getBackgroundValues(coverage)[0];
                    noDataProperty = CoverageUtilities.getNoDataProperty(coverage);
                    hasNoDataProp |= noDataProperty != null;
                    continue;
                }
                GridGeometry2D newGG = new GridGeometry2D(PixelInCell.CELL_CORNER, g2w, inputGG.getEnvelope(), GeoTools.getDefaultHints());
                try {
                    GeneralBounds transformed = CRS.transform(g2w.inverse(), inputGG.getEnvelope());
                    Rectangle rect = transformed.toRectangle2D().getBounds();
                    GridEnvelope2D gEnv2 = new GridEnvelope2D(rect);
                    newGG = new GridGeometry2D(gEnv2, inputGG.getEnvelope());
                }
                catch (TransformException | InvalidGridGeometryException e) {
                    throw new CoverageProcessingException(e);
                }
                double[] fillValue = null;
                fillValue = nodata == null ? CoverageUtilities.getBackgroundValues(coverage) : nodata;
                if (newGG.equals(coverage.getGridGeometry())) {
                    rasters[i] = coverage.getRenderedImage();
                    if (hasAlpha && alphas[i] != null) {
                        alphaArray[i] = PlanarImage.wrapRenderedImage(alphas[i].getRenderedImage());
                    }
                } else {
                    rasters[i] = GridCoverage2DRIA.create(coverage, newGG, fillValue, hints, CoverageUtilities.getROIProperty(coverage));
                    if (hasAlpha && alphas[i] != null) {
                        GridGeometryPolicy.checkAlpha(coverage, alphas[i]);
                        GridCoverage2DRIA al = GridCoverage2DRIA.create(alphas[i], newGG, new double[1], hints, CoverageUtilities.getROIProperty(coverage));
                        alphaArray[i] = PlanarImage.wrapRenderedImage(al);
                    }
                }
                backgrounds[i] = fillValue[0];
                ROI roi = rasters[i] instanceof GridCoverage2DRIA ? ((property2 = (propertyGenerator = new GridCoverage2DRIA.GridCoverage2DRIAPropertyGenerator()).getProperty("roi", rasters[i])) != null && property2 instanceof ROI ? (ROI)property2 : null) : ((property = rasters[i].getProperty("roi")) != null && property instanceof ROI ? (ROI)property : null);
                rois[i] = roi;
                noDataProperty = CoverageUtilities.getNoDataProperty(coverage);
                hasNoDataProp |= noDataProperty != null;
            }
            ResampledRasters rr = new ResampledRasters();
            rr.setFinalGeometry(external);
            rr.setRasters(rasters);
            rr.setAlphas(alphaArray);
            rr.setBackgrounds(backgrounds);
            rr.setRois(rois);
            rr.setHasNoData(hasNoDataProp);
            return rr;
        }

        private static void checkAlpha(GridCoverage2D coverage, GridCoverage2D alpha) {
            if (!coverage.getGridGeometry().equals(alpha.getGridGeometry())) {
                throw new CoverageProcessingException("Alpha Coverage and Source Coverage does not have the same dimensions");
            }
        }

        private static GridGeometry2D extractFinalGridGeometry(GridCoverage2D[] sources, int index) {
            GridGeometry2D gg = sources[index].getGridGeometry();
            MathTransform2D g2w = gg.getGridToCRS2D(PixelOrientation.UPPER_LEFT);
            ReferencedEnvelope bbox = gg.getEnvelope2D();
            for (GridCoverage2D source : sources) {
                bbox.include(source.getEnvelope2D());
            }
            GridGeometry2D finalGG = new GridGeometry2D(PixelInCell.CELL_CORNER, g2w, bbox, GeoTools.getDefaultHints());
            return finalGG;
        }
    }
}

