/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.affine;

import com.sun.media.jai.util.ImageUtil;
import it.geosolutions.jaiext.affine.JaiI18N;
import it.geosolutions.jaiext.interpolators.InterpolationNearest;
import it.geosolutions.jaiext.range.Range;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Map;
import javax.media.jai.BorderExtender;
import javax.media.jai.GeometricOpImage;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.util.ImagingException;
import javax.media.jai.util.ImagingListener;

abstract class AffineOpImage
extends GeometricOpImage {
    protected static final double HALF_PIXEL = 0.5;
    static final BorderExtender roiExtender = BorderExtender.createInstance(0);
    protected static final int USHORT_MAX_VALUE = 65535;
    protected AffineTransform f_transform;
    protected AffineTransform i_transform;
    protected Interpolation interp;
    protected Rectangle srcimg;
    protected Rectangle padimg;
    protected BorderExtender extender;
    protected Rectangle theDest;
    protected ImagingListener listener;
    protected byte[] destinationNoDataByte;
    protected short[] destinationNoDataUShort;
    protected short[] destinationNoDataShort;
    protected int[] destinationNoDataInt;
    protected float[] destinationNoDataFloat;
    protected double[] destinationNoDataDouble;
    protected boolean isNearestNew = false;
    protected boolean isBilinearNew = false;
    protected boolean isBicubicNew = false;
    protected boolean useROIAccessor;
    protected static final int GEOM_FRAC_MAX = 0x100000;
    double m00;
    double m10;
    double flr_m00;
    double flr_m10;
    double fracdx;
    double fracdx1;
    double fracdy;
    double fracdy1;
    int incx;
    int incx1;
    int incy;
    int incy1;
    int ifracdx;
    int ifracdx1;
    int ifracdy;
    int ifracdy1;
    protected int lpad;
    protected int rpad;
    protected int tpad;
    protected int bpad;
    protected final ROI srcROI;
    protected final PlanarImage srcROIImage;
    protected final Rectangle roiBounds;
    protected final boolean hasROI;
    protected boolean hasNoData = false;
    protected Range noData;
    protected boolean caseA;
    protected boolean caseB;
    protected boolean caseC;
    protected RenderedOp extendedIMG;
    protected RenderedOp srcROIImgExt;
    protected Rectangle roiRect;

    protected static int floorRatio(long num, long denom) {
        if (denom < 0L) {
            denom = -denom;
            num = -num;
        }
        if (num >= 0L) {
            return (int)(num / denom);
        }
        return (int)((num - denom + 1L) / denom);
    }

    protected static int ceilRatio(long num, long denom) {
        if (denom < 0L) {
            denom = -denom;
            num = -num;
        }
        if (num >= 0L) {
            return (int)((num + denom - 1L) / denom);
        }
        return (int)(num / denom);
    }

    private static ImageLayout layoutHelper(ImageLayout layout, RenderedImage source, AffineTransform forward_tr) {
        ImageLayout newLayout = layout != null ? (ImageLayout)layout.clone() : new ImageLayout();
        float sx0 = source.getMinX();
        float sy0 = source.getMinY();
        float sw = source.getWidth();
        float sh = source.getHeight();
        Point2D[] pts = new Point2D[]{new Point2D.Float(sx0, sy0), new Point2D.Float(sx0 + sw, sy0), new Point2D.Float(sx0 + sw, sy0 + sh), new Point2D.Float(sx0, sy0 + sh)};
        forward_tr.transform(pts, 0, pts, 0, 4);
        float dx0 = Float.MAX_VALUE;
        float dy0 = Float.MAX_VALUE;
        float dx1 = -3.4028235E38f;
        float dy1 = -3.4028235E38f;
        for (int i = 0; i < 4; ++i) {
            float px = (float)pts[i].getX();
            float py = (float)pts[i].getY();
            dx0 = Math.min(dx0, px);
            dy0 = Math.min(dy0, py);
            dx1 = Math.max(dx1, px);
            dy1 = Math.max(dy1, py);
        }
        int lw = (int)(dx1 - dx0);
        int lh = (int)(dy1 - dy0);
        int i_dx0 = (int)Math.floor(dx0);
        int lx0 = (double)Math.abs(dx0 - (float)i_dx0) <= 0.5 ? i_dx0 : (int)Math.ceil(dx0);
        int i_dy0 = (int)Math.floor(dy0);
        int ly0 = (double)Math.abs(dy0 - (float)i_dy0) <= 0.5 ? i_dy0 : (int)Math.ceil(dy0);
        newLayout.setMinX(lx0);
        newLayout.setMinY(ly0);
        newLayout.setWidth(lw);
        newLayout.setHeight(lh);
        return newLayout;
    }

    public AffineOpImage(RenderedImage source, BorderExtender extender, Map config, ImageLayout layout, AffineTransform transform, Interpolation interp, double[] backgroundValues) {
        super(AffineOpImage.vectorize(source), AffineOpImage.layoutHelper(layout, source, transform), config, true, extender, interp, backgroundValues);
        this.listener = ImageUtil.getImagingListener((RenderingHints)config);
        this.interp = interp;
        this.extender = extender;
        this.lpad = interp.getLeftPadding();
        this.rpad = interp.getRightPadding();
        this.tpad = interp.getTopPadding();
        this.bpad = interp.getBottomPadding();
        this.srcimg = new Rectangle(this.getSourceImage(0).getMinX(), this.getSourceImage(0).getMinY(), this.getSourceImage(0).getWidth(), this.getSourceImage(0).getHeight());
        this.padimg = new Rectangle(this.srcimg.x - this.lpad, this.srcimg.y - this.tpad, this.srcimg.width + this.lpad + this.rpad, this.srcimg.height + this.tpad + this.bpad);
        if (extender == null) {
            float sx0 = this.srcimg.x;
            float sy0 = this.srcimg.y;
            float sw = this.srcimg.width;
            float sh = this.srcimg.height;
            float f_lpad = this.lpad;
            float f_rpad = this.rpad;
            float f_tpad = this.tpad;
            float f_bpad = this.bpad;
            if (!(interp instanceof InterpolationNearest)) {
                f_lpad = (float)((double)f_lpad + 0.5);
                f_tpad = (float)((double)f_tpad + 0.5);
                f_rpad = (float)((double)f_rpad + 0.5);
                f_bpad = (float)((double)f_bpad + 0.5);
            }
            Point2D[] pts = new Point2D[]{new Point2D.Float(sx0 += f_lpad, sy0 += f_tpad), new Point2D.Float(sx0 + (sw -= f_lpad + f_rpad), sy0), new Point2D.Float(sx0 + sw, sy0 + (sh -= f_tpad + f_bpad)), new Point2D.Float(sx0, sy0 + sh)};
            transform.transform(pts, 0, pts, 0, 4);
            float dx0 = Float.MAX_VALUE;
            float dy0 = Float.MAX_VALUE;
            float dx1 = -3.4028235E38f;
            float dy1 = -3.4028235E38f;
            for (int i = 0; i < 4; ++i) {
                float px = (float)pts[i].getX();
                float py = (float)pts[i].getY();
                dx0 = Math.min(dx0, px);
                dy0 = Math.min(dy0, py);
                dx1 = Math.max(dx1, px);
                dy1 = Math.max(dy1, py);
            }
            int lx0 = (int)Math.ceil(dx0);
            int ly0 = (int)Math.ceil(dy0);
            int lx1 = (int)Math.floor(dx1);
            int ly1 = (int)Math.floor(dy1);
            this.theDest = new Rectangle(lx0, ly0, lx1 - lx0, ly1 - ly0);
        } else {
            this.theDest = this.getBounds();
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(source, 0);
            pb.set(this.lpad, 0);
            pb.set(this.rpad, 1);
            pb.set(this.tpad, 2);
            pb.set(this.bpad, 3);
            pb.set(extender, 4);
            this.extendedIMG = JAI.create("border", pb);
        }
        try {
            this.i_transform = transform.createInverse();
        }
        catch (Exception e) {
            String message = JaiI18N.getString("AffineOpImage0");
            this.listener.errorOccurred(message, new ImagingException(message, e), this, false);
        }
        this.f_transform = (AffineTransform)transform.clone();
        this.m00 = this.i_transform.getScaleX();
        this.flr_m00 = Math.floor(this.m00);
        this.fracdx = this.m00 - this.flr_m00;
        this.fracdx1 = 1.0 - this.fracdx;
        this.incx = (int)this.flr_m00;
        this.incx1 = this.incx + 1;
        this.ifracdx = (int)Math.round(this.fracdx * 1048576.0);
        this.ifracdx1 = 0x100000 - this.ifracdx;
        this.m10 = this.i_transform.getShearY();
        this.flr_m10 = Math.floor(this.m10);
        this.fracdy = this.m10 - this.flr_m10;
        this.fracdy1 = 1.0 - this.fracdy;
        this.incy = (int)this.flr_m10;
        this.incy1 = this.incy + 1;
        this.ifracdy = (int)Math.round(this.fracdy * 1048576.0);
        this.ifracdy1 = 0x100000 - this.ifracdy;
        Object property = source.getProperty("ROI");
        if (property instanceof ROI) {
            this.srcROI = (ROI)property;
            this.srcROIImage = this.srcROI.getAsImage();
            this.roiRect = new Rectangle(this.srcROIImage.getMinX() - this.lpad, this.srcROIImage.getMinY() - this.tpad, this.srcROIImage.getWidth() + this.lpad + this.rpad, this.srcROIImage.getHeight() + this.tpad + this.bpad);
            this.roiBounds = this.srcROIImage.getBounds();
            Rectangle srcRect = this.padimg;
            int deltaX0 = this.roiBounds.x - srcRect.x;
            int leftP = deltaX0 > 0 ? deltaX0 : 0;
            int deltaY0 = this.roiBounds.y - srcRect.y;
            int topP = deltaY0 > 0 ? deltaY0 : 0;
            int deltaX1 = srcRect.x + srcRect.width - this.roiBounds.x - this.roiBounds.width;
            int rightP = deltaX1 > 0 ? deltaX1 : 0;
            int deltaY1 = srcRect.y + srcRect.height - this.roiBounds.y - this.roiBounds.height;
            int bottomP = deltaY1 > 0 ? deltaY1 : 0;
            ParameterBlock pb = new ParameterBlock();
            pb.setSource(this.srcROIImage, 0);
            pb.set(leftP, 0);
            pb.set(rightP, 1);
            pb.set(topP, 2);
            pb.set(bottomP, 3);
            pb.set(roiExtender, 4);
            this.srcROIImgExt = JAI.create("border", pb);
            this.hasROI = true;
        } else {
            this.srcROI = null;
            this.srcROIImage = null;
            this.roiBounds = null;
            this.hasROI = false;
        }
    }

    public Point2D mapDestPoint(Point2D destPt) {
        if (destPt == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D dpt = (Point2D)destPt.clone();
        dpt.setLocation(dpt.getX() + 0.5, dpt.getY() + 0.5);
        Point2D spt = this.i_transform.transform(dpt, null);
        spt.setLocation(spt.getX() - 0.5, spt.getY() - 0.5);
        return spt;
    }

    public Point2D mapSourcePoint(Point2D sourcePt) {
        if (sourcePt == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Point2D spt = (Point2D)sourcePt.clone();
        spt.setLocation(spt.getX() + 0.5, spt.getY() + 0.5);
        Point2D dpt = this.f_transform.transform(spt, null);
        dpt.setLocation(dpt.getX() - 0.5, dpt.getY() - 0.5);
        return dpt;
    }

    @Override
    protected Rectangle forwardMapRect(Rectangle sourceRect, int sourceIndex) {
        return this.f_transform.createTransformedShape(sourceRect).getBounds();
    }

    @Override
    protected Rectangle backwardMapRect(Rectangle destRect, int sourceIndex) {
        float dx0 = destRect.x;
        float dy0 = destRect.y;
        float dw = destRect.width;
        float dh = destRect.height;
        Point2D[] pts = new Point2D[]{new Point2D.Float(dx0, dy0), new Point2D.Float(dx0 + dw, dy0), new Point2D.Float(dx0 + dw, dy0 + dh), new Point2D.Float(dx0, dy0 + dh)};
        this.i_transform.transform(pts, 0, pts, 0, 4);
        float f_sx0 = Float.MAX_VALUE;
        float f_sy0 = Float.MAX_VALUE;
        float f_sx1 = -3.4028235E38f;
        float f_sy1 = -3.4028235E38f;
        for (int i = 0; i < 4; ++i) {
            float px = (float)pts[i].getX();
            float py = (float)pts[i].getY();
            f_sx0 = Math.min(f_sx0, px);
            f_sy0 = Math.min(f_sy0, py);
            f_sx1 = Math.max(f_sx1, px);
            f_sy1 = Math.max(f_sy1, py);
        }
        int s_x0 = 0;
        int s_y0 = 0;
        int s_x1 = 0;
        int s_y1 = 0;
        if (this.interp instanceof InterpolationNearest) {
            s_x0 = (int)Math.floor(f_sx0);
            s_y0 = (int)Math.floor(f_sy0);
            s_x1 = (int)Math.ceil((double)f_sx1 + 0.5);
            s_y1 = (int)Math.ceil((double)f_sy1 + 0.5);
        } else {
            s_x0 = (int)Math.floor((double)f_sx0 - 0.5);
            s_y0 = (int)Math.floor((double)f_sy0 - 0.5);
            s_x1 = (int)Math.ceil(f_sx1);
            s_y1 = (int)Math.ceil(f_sy1);
        }
        return new Rectangle(s_x0, s_y0, s_x1 - s_x0, s_y1 - s_y0);
    }

    public void mapDestPoint(Point2D destPoint, Point2D srcPoint) {
        this.i_transform.transform(destPoint, srcPoint);
    }

    @Override
    public Raster computeTile(int tileX, int tileY) {
        Point org = new Point(this.tileXToX(tileX), this.tileYToY(tileY));
        WritableRaster dest = this.createWritableRaster(this.sampleModel, org);
        Rectangle rect = new Rectangle(org.x, org.y, this.tileWidth, this.tileHeight);
        Rectangle destRect = rect.intersection(this.theDest);
        Rectangle destRect1 = rect.intersection(this.getBounds());
        if (destRect.width <= 0 || destRect.height <= 0) {
            if (this.setBackground) {
                ImageUtil.fillBackground(dest, destRect1, this.backgroundValues);
            }
            return dest;
        }
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        srcRect = this.extender == null ? srcRect.intersection(this.srcimg) : srcRect.intersection(this.padimg);
        if (srcRect.width <= 0 || srcRect.height <= 0) {
            if (this.setBackground) {
                ImageUtil.fillBackground(dest, destRect1, this.backgroundValues);
            }
            return dest;
        }
        if (!destRect1.equals(destRect)) {
            ImageUtil.fillBordersWithBackgroundValues(destRect1, destRect, dest, this.backgroundValues);
        }
        Raster[] sources = new Raster[1];
        PlanarImage srcIMG = this.getSourceImage(0);
        sources[0] = this.extender == null ? srcIMG.getData(srcRect) : (srcIMG.getBounds().contains(srcRect) ? srcIMG.getData(srcRect) : this.extendedIMG.getData(srcRect));
        this.computeRect(sources, dest, destRect);
        if (this.getSourceImage(0).overlapsMultipleTiles(srcRect)) {
            this.recycleTile(sources[0]);
        }
        return dest;
    }

    @Override
    protected abstract void computeRect(Raster[] var1, WritableRaster var2, Rectangle var3);

    @Override
    public synchronized void dispose() {
        if (this.srcROIImage != null) {
            this.srcROIImage.dispose();
        }
        if (this.extendedIMG != null) {
            this.extendedIMG.dispose();
        }
        super.dispose();
    }

    protected javax.media.jai.util.Range performScanlineClipping(float src_rect_x1, float src_rect_y1, float src_rect_x2, float src_rect_y2, int s_ix, int s_iy, int ifracx, int ifracy, int dst_min_x, int dst_max_x, int lpad, int rpad, int tpad, int bpad) {
        int clipMinX = dst_min_x;
        int clipMaxX = dst_max_x;
        long xdenom = this.incx * 0x100000 + this.ifracdx;
        if (xdenom != 0L) {
            long clipx1 = (long)src_rect_x1 + (long)lpad;
            long clipx2 = (long)src_rect_x2 - (long)rpad;
            long x1 = (clipx1 - (long)s_ix) * 0x100000L - (long)ifracx + (long)dst_min_x * xdenom;
            long x2 = (clipx2 - (long)s_ix) * 0x100000L - (long)ifracx + (long)dst_min_x * xdenom;
            if (xdenom < 0L) {
                long tmp = x1;
                x1 = x2;
                x2 = tmp;
            }
            int dx1 = AffineOpImage.ceilRatio(x1, xdenom);
            clipMinX = Math.max(clipMinX, dx1);
            int dx2 = AffineOpImage.floorRatio(x2, xdenom) + 1;
            clipMaxX = Math.min(clipMaxX, dx2);
        } else if ((float)s_ix < src_rect_x1 || (float)s_ix >= src_rect_x2) {
            clipMinX = clipMaxX = dst_min_x;
            return new javax.media.jai.util.Range(Integer.class, new Integer(clipMinX), new Integer(clipMaxX));
        }
        long ydenom = this.incy * 0x100000 + this.ifracdy;
        if (ydenom != 0L) {
            long clipy1 = (long)src_rect_y1 + (long)tpad;
            long clipy2 = (long)src_rect_y2 - (long)bpad;
            long y1 = (clipy1 - (long)s_iy) * 0x100000L - (long)ifracy + (long)dst_min_x * ydenom;
            long y2 = (clipy2 - (long)s_iy) * 0x100000L - (long)ifracy + (long)dst_min_x * ydenom;
            if (ydenom < 0L) {
                long tmp = y1;
                y1 = y2;
                y2 = tmp;
            }
            int dx1 = AffineOpImage.ceilRatio(y1, ydenom);
            clipMinX = Math.max(clipMinX, dx1);
            int dx2 = AffineOpImage.floorRatio(y2, ydenom) + 1;
            clipMaxX = Math.min(clipMaxX, dx2);
        } else if ((float)s_iy < src_rect_y1 || (float)s_iy >= src_rect_y2) {
            clipMinX = clipMaxX = dst_min_x;
        }
        if (clipMinX > dst_max_x) {
            clipMinX = dst_max_x;
        }
        if (clipMaxX < dst_min_x) {
            clipMaxX = dst_min_x;
        }
        return new javax.media.jai.util.Range(Integer.class, new Integer(clipMinX), new Integer(clipMaxX));
    }

    protected Point[] advanceToStartOfScanline(int dst_min_x, int clipMinX, int s_ix, int s_iy, int ifracx, int ifracy) {
        long skip = clipMinX - dst_min_x;
        long dx = ((long)ifracx + skip * (long)this.ifracdx) / 0x100000L;
        long dy = ((long)ifracy + skip * (long)this.ifracdy) / 0x100000L;
        s_ix = (int)((long)s_ix + (skip * (long)this.incx + (long)((int)dx)));
        s_iy = (int)((long)s_iy + (skip * (long)this.incy + (long)((int)dy)));
        long lfracx = (long)ifracx + skip * (long)this.ifracdx;
        ifracx = lfracx >= 0L ? (int)(lfracx % 0x100000L) : (int)(-(-lfracx % 0x100000L));
        long lfracy = (long)ifracy + skip * (long)this.ifracdy;
        ifracy = lfracy >= 0L ? (int)(lfracy % 0x100000L) : (int)(-(-lfracy % 0x100000L));
        return new Point[]{new Point(s_ix, s_iy), new Point(ifracx, ifracy)};
    }
}

