/*
 * Decompiled with CFR 0.152.
 */
package indoor_sweepline;

import indoor_sweepline.Beam;
import indoor_sweepline.BeamGeography;
import indoor_sweepline.CorridorGeography;
import indoor_sweepline.CorridorPart;
import indoor_sweepline.IndoorSweeplineModel;
import indoor_sweepline.Strip;
import java.util.List;
import java.util.Vector;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;

public class ModelGeography {
    private Vector<BeamGeography> beamsGeography = new Vector();
    private DataSet dataSet;
    private LatLon center;
    private Vector<Way> wayPool;
    private int wayPoolCount;
    private Vector<Node> nodePool;
    private int nodePoolCount;
    private Vector<Node> nodes;
    private Relation multipolygon;
    private Vector<RelationMember> members;

    public ModelGeography(DataSet dataSet, LatLon center) {
        this.dataSet = dataSet;
        this.center = center;
        this.wayPool = new Vector();
        this.wayPoolCount = 0;
        this.nodePool = new Vector();
        this.nodePoolCount = 0;
        this.nodes = null;
        this.multipolygon = null;
        this.members = null;
    }

    public void appendNode(Node node) {
        this.nodes.add(node);
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public BeamGeography beamAt(int i) {
        return this.beamsGeography.elementAt(i);
    }

    public void startGeographyBuild(Vector<Beam> beams, Vector<Strip> strips) {
        if (this.beamsGeography.size() < beams.size()) {
            this.beamsGeography.setSize(beams.size());
        }
        double offset = 0.0;
        for (int i = 0; i < beams.size(); ++i) {
            if (this.beamsGeography.elementAt(i) == null) {
                this.beamsGeography.setElementAt(new BeamGeography(this.dataSet, this), i);
            }
            this.beamsGeography.elementAt(i).adjustNodes(new LatLon(this.center.lat(), ModelGeography.addMetersToLon(this.center, offset)), beams.elementAt(i).getBeamParts(), beams.elementAt(i).getBeamOffset());
            if (i >= strips.size()) continue;
            offset += strips.elementAt((int)i).width;
        }
        this.nodePoolCount = 0;
        this.wayPoolCount = 0;
        this.members = new Vector();
        if (this.multipolygon != null) {
            this.multipolygon.setMembers(this.members);
        }
    }

    public void startWay() {
        this.nodes = new Vector();
    }

    public void finishWay(Strip strip, int partIndex, boolean isOuter, String level) {
        if (!this.nodes.isEmpty()) {
            CorridorPart part = strip.partAt(partIndex);
            strip.geographyAt(partIndex).appendNodes(part.getType(), part.getSide(), level, (ILatLon)this.nodes.elementAt(this.nodes.size() - 1), (ILatLon)this.nodes.elementAt(0), this);
            this.nodes.add(this.nodes.elementAt(0));
        }
        this.assignNds(this.nodes);
        this.members.add(new RelationMember(isOuter ? "outer" : "inner", (OsmPrimitive)this.wayPool.elementAt(this.wayPoolCount)));
        ++this.wayPoolCount;
    }

    public void appendCorridorPart(CorridorPart part, CorridorGeography partGeography, int beamIndex, int partIndex, String level) {
        if (!this.nodes.isEmpty()) {
            partGeography.appendNodes(part.getType(), part.getSide(), level, (ILatLon)this.nodes.elementAt(this.nodes.size() - 1), (ILatLon)this.beamsGeography.elementAt(beamIndex).coorAt(partIndex), this);
        }
    }

    public void appendUturnNode(Strip strip, int partIndex, int stripIndex, int beamNodeIndex, boolean toTheLeft, String level) {
        if (toTheLeft) {
            this.assignCoor(ModelGeography.addMeterOffset(this.beamsGeography.elementAt(stripIndex + 1).coorAt(beamNodeIndex), 0.0, -strip.width / 2.0));
        } else {
            this.assignCoor(ModelGeography.addMeterOffset(this.beamsGeography.elementAt(stripIndex).coorAt(beamNodeIndex), 0.0, strip.width / 2.0));
        }
        if (!this.nodes.isEmpty()) {
            CorridorPart part = strip.partAt(partIndex);
            strip.geographyAt(partIndex).appendNodes(part.getType(), part.getSide(), level, (ILatLon)this.nodes.elementAt(this.nodes.size() - 1), (ILatLon)this.nodePool.elementAt(this.nodePoolCount), this);
        }
        this.nodes.add(this.nodePool.elementAt(this.nodePoolCount));
        ++this.nodePoolCount;
    }

    public void finishGeographyBuild(IndoorSweeplineModel.Type type, String level) {
        int i;
        for (i = this.nodePoolCount; i < this.nodePool.size(); ++i) {
            this.nodePool.elementAt(i).setDeleted(true);
        }
        this.nodePool.setSize(this.nodePoolCount);
        for (i = this.wayPoolCount; i < this.wayPool.size(); ++i) {
            this.wayPool.elementAt(i).setDeleted(true);
        }
        this.wayPool.setSize(this.wayPoolCount);
        this.adjustMultipolygonRelation(type, level);
    }

    private static LatLon addMeterOffset(LatLon latLon, double south, double east) {
        double scale = Math.cos(latLon.lat() * (Math.PI / 180));
        return new LatLon(latLon.lat() - south * 9.0E-6, latLon.lon() + east / scale * 9.0E-6);
    }

    private static double addMetersToLon(LatLon latLon, double east) {
        double scale = Math.cos(latLon.lat() * (Math.PI / 180));
        return latLon.lon() + east / scale * 9.0E-6;
    }

    private void assignCoor(LatLon latLon) {
        if (this.nodePoolCount < this.nodePool.size()) {
            this.nodePool.elementAt(this.nodePoolCount).setCoor(latLon);
        } else {
            Node node = new Node(latLon);
            this.dataSet.addPrimitive((OsmPrimitive)node);
            this.nodePool.add(node);
        }
    }

    private void assignNds(List<Node> nodes) {
        if (this.wayPoolCount < this.wayPool.size()) {
            this.wayPool.elementAt(this.wayPoolCount).setNodes(nodes);
        } else {
            Way way = new Way();
            way.setNodes(nodes);
            this.dataSet.addPrimitive((OsmPrimitive)way);
            this.wayPool.add(way);
        }
    }

    private static void addPolygonTags(IndoorSweeplineModel.Type type, String level, OsmPrimitive obj) {
        if (type == IndoorSweeplineModel.Type.PLATFORM) {
            obj.put("railway", "platform");
            obj.put("public_transport", "platform");
            obj.put("area", "yes");
            obj.put("level", level);
        } else {
            obj.put("highway", "pedestrian");
            obj.put("indoor", "corridor");
            obj.put("area", "yes");
            obj.put("level", level);
        }
    }

    private void adjustMultipolygonRelation(IndoorSweeplineModel.Type type, String level) {
        if (this.members.size() > 1) {
            if (!this.wayPool.isEmpty()) {
                this.wayPool.elementAt(0).removeAll();
            }
            if (this.multipolygon == null) {
                this.multipolygon = new Relation();
                this.dataSet.addPrimitive((OsmPrimitive)this.multipolygon);
            }
            this.multipolygon.removeAll();
            this.multipolygon.put("type", "multipolygon");
            ModelGeography.addPolygonTags(type, level, (OsmPrimitive)this.multipolygon);
            this.multipolygon.setMembers(this.members);
        } else {
            if (this.multipolygon != null) {
                this.multipolygon.setDeleted(true);
                this.multipolygon = null;
            }
            if (this.wayPool.size() == 1) {
                this.wayPool.elementAt(0).removeAll();
                ModelGeography.addPolygonTags(type, level, (OsmPrimitive)this.wayPool.elementAt(0));
            }
        }
    }
}

