/*
 * Decompiled with CFR 0.152.
 */
package indoor_sweepline;

import indoor_sweepline.Beam;
import indoor_sweepline.CorridorPart;
import indoor_sweepline.ModelGeography;
import indoor_sweepline.Strip;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class IndoorSweeplineModel {
    private ModelGeography target;
    private Vector<Beam> beams;
    private Vector<Strip> strips;
    private Type type;
    private String level;
    DefaultComboBoxModel<String> structureBox;

    public IndoorSweeplineModel(OsmDataLayer activeLayer, LatLon center) {
        this.target = new ModelGeography(activeLayer.getDataSet(), center);
        this.beams = new Vector();
        this.strips = new Vector();
        this.type = Type.CORRIDOR;
        this.level = "-1";
        this.addBeam();
        this.addStrip();
        this.addBeam();
        this.structureBox = new DefaultComboBoxModel();
    }

    public void addBeam() {
        CorridorPart.ReachableSide side = CorridorPart.ReachableSide.LEFT;
        if (this.beams.size() == 0) {
            side = CorridorPart.ReachableSide.RIGHT;
        }
        if (this.strips.size() == 0) {
            Vector<Double> blueprint = new Vector<Double>();
            blueprint.addElement(0.0);
            blueprint.addElement(10.0);
            this.beams.add(new Beam(blueprint, 0.0, side));
        } else {
            this.beams.add(new Beam(this.strips.elementAt((int)(this.strips.size() - 1)).lhs, this.beams.elementAt(this.beams.size() - 1).getBeamOffset(), side));
        }
        if (this.strips.size() > 0) {
            this.strips.elementAt((int)(this.beams.size() - 2)).rhs = this.beams.elementAt(this.beams.size() - 1).leftHandSideStrips();
        }
        this.updateOsmModel();
    }

    public void addStrip() {
        this.strips.add(new Strip(this.target.getDataSet()));
        if (this.beams.size() > 1) {
            this.beams.elementAt(this.beams.size() - 1).setDefaultSide(CorridorPart.ReachableSide.ALL);
            this.strips.elementAt((int)(this.strips.size() - 2)).rhs = this.beams.elementAt(this.strips.size() - 1).leftHandSideStrips();
        }
        this.strips.elementAt((int)(this.strips.size() - 1)).lhs = this.beams.elementAt(this.strips.size() - 1).rightHandSideStrips();
        this.updateOsmModel();
    }

    public int leftRightCount() {
        return this.beams.size() + this.strips.size();
    }

    public DefaultComboBoxModel<String> structures() {
        this.structureBox.removeAllElements();
        double offset = 0.0;
        for (int i = 0; i < this.strips.size(); ++i) {
            if (i < this.beams.size()) {
                this.structureBox.addElement(Double.toString(offset));
            }
            this.structureBox.addElement(Double.toString(offset) + " - " + Double.toString(offset + this.strips.elementAt((int)i).width));
            offset += this.strips.elementAt((int)i).width;
        }
        if (this.strips.size() < this.beams.size()) {
            this.structureBox.addElement(Double.toString(offset));
        }
        return this.structureBox;
    }

    public Strip getStrip(int index) {
        return this.strips.elementAt(index / 2);
    }

    public double getStripWidth(int index) {
        return this.strips.elementAt((int)(index / 2)).width;
    }

    public void setStripWidth(int index, double value) {
        this.strips.elementAt((int)(index / 2)).width = value;
        this.updateOsmModel();
    }

    public double getBeamOffset(int index) {
        return this.beams.elementAt(index / 2).getBeamOffset();
    }

    public void setBeamOffset(int index, double beamOffset) {
        this.beams.elementAt(index / 2).setBeamOffset(beamOffset);
        this.updateOsmModel();
    }

    public List<CorridorPart> getBeamParts(int index) {
        return this.beams.elementAt(index / 2).getBeamParts();
    }

    public void addCorridorPart(int beamIndex, boolean append, double value) {
        this.beams.elementAt(beamIndex / 2).addCorridorPart(append, value);
        if (beamIndex / 2 > 0) {
            this.strips.elementAt((int)(beamIndex / 2 - 1)).rhs = this.beams.elementAt(beamIndex / 2).leftHandSideStrips();
        }
        if (beamIndex / 2 < this.strips.size()) {
            this.strips.elementAt((int)(beamIndex / 2)).lhs = this.beams.elementAt(beamIndex / 2).rightHandSideStrips();
        }
        this.updateOsmModel();
    }

    public void setCorridorPartWidth(int beamIndex, int partIndex, double value) {
        this.beams.elementAt(beamIndex / 2).setCorridorPartWidth(partIndex, value);
        if (beamIndex / 2 > 0) {
            this.strips.elementAt((int)(beamIndex / 2 - 1)).rhs = this.beams.elementAt(beamIndex / 2).leftHandSideStrips();
        }
        if (beamIndex / 2 < this.strips.size()) {
            this.strips.elementAt((int)(beamIndex / 2)).lhs = this.beams.elementAt(beamIndex / 2).rightHandSideStrips();
        }
        this.updateOsmModel();
    }

    public void setCorridorPartType(int beamIndex, int partIndex, CorridorPart.Type type) {
        if (beamIndex % 2 == 0) {
            this.beams.elementAt(beamIndex / 2).setCorridorPartType(partIndex, type);
            if (beamIndex / 2 > 0) {
                this.strips.elementAt((int)(beamIndex / 2 - 1)).rhs = this.beams.elementAt(beamIndex / 2).leftHandSideStrips();
            }
            if (beamIndex / 2 < this.strips.size()) {
                this.strips.elementAt((int)(beamIndex / 2)).lhs = this.beams.elementAt(beamIndex / 2).rightHandSideStrips();
            }
        } else if (type != CorridorPart.Type.PASSAGE && type != CorridorPart.Type.VOID) {
            this.strips.elementAt(beamIndex / 2).setCorridorPartType(partIndex, type);
        }
        this.updateOsmModel();
    }

    public void setCorridorPartSide(int beamIndex, int partIndex, CorridorPart.ReachableSide side) {
        this.beams.elementAt(beamIndex / 2).setCorridorPartSide(partIndex, side);
        if (beamIndex / 2 > 0) {
            this.strips.elementAt((int)(beamIndex / 2 - 1)).rhs = this.beams.elementAt(beamIndex / 2).leftHandSideStrips();
        }
        if (beamIndex / 2 < this.strips.size()) {
            this.strips.elementAt((int)(beamIndex / 2)).lhs = this.beams.elementAt(beamIndex / 2).rightHandSideStrips();
        }
        this.updateOsmModel();
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
        this.updateOsmModel();
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
        this.updateOsmModel();
    }

    private void updateOsmModel() {
        this.distributeWays();
        MainApplication.getMap().mapView.repaint();
    }

    private void distributeWays() {
        Vector refs;
        this.target.startGeographyBuild(this.beams, this.strips);
        Vector<Vector> stripRefs = new Vector<Vector>();
        for (Strip strip : this.strips) {
            refs = new Vector();
            if (strip.lhs.size() < strip.rhs.size()) {
                refs.setSize(strip.rhs.size());
            } else {
                refs.setSize(strip.lhs.size());
            }
            stripRefs.add(refs);
        }
        Boolean truePtr = Boolean.TRUE;
        for (int i = 0; i < stripRefs.size(); ++i) {
            refs = (Vector)stripRefs.elementAt(i);
            for (int j = 0; j < refs.size(); ++j) {
                if (refs.elementAt(j) != null) continue;
                this.target.startWay();
                SweepPolygonCursor cursor = new SweepPolygonCursor(i, j);
                boolean toTheLeft = true;
                while (((Vector)stripRefs.elementAt(cursor.stripIndex)).elementAt(cursor.partIndex) == null) {
                    ((Vector)stripRefs.elementAt(cursor.stripIndex)).setElementAt(truePtr, cursor.partIndex);
                    if (toTheLeft && cursor.partIndex < this.strips.elementAt((int)cursor.stripIndex).lhs.size()) {
                        this.target.appendCorridorPart(this.strips.elementAt(cursor.stripIndex).partAt(cursor.partIndex), this.strips.elementAt(cursor.stripIndex).geographyAt(cursor.partIndex), cursor.stripIndex, this.beams.elementAt(cursor.stripIndex).getBeamPartIndex(!toTheLeft, cursor.partIndex), this.level);
                        toTheLeft = this.beams.elementAt(cursor.stripIndex).appendNodes(cursor, toTheLeft, this.target.beamAt(cursor.stripIndex), this.level);
                        continue;
                    }
                    if (!toTheLeft && cursor.partIndex < this.strips.elementAt((int)cursor.stripIndex).rhs.size()) {
                        this.target.appendCorridorPart(this.strips.elementAt(cursor.stripIndex).partAt(cursor.partIndex), this.strips.elementAt(cursor.stripIndex).geographyAt(cursor.partIndex), cursor.stripIndex + 1, this.beams.elementAt(cursor.stripIndex + 1).getBeamPartIndex(!toTheLeft, cursor.partIndex), this.level);
                        toTheLeft = this.beams.elementAt(cursor.stripIndex + 1).appendNodes(cursor, toTheLeft, this.target.beamAt(cursor.stripIndex + 1), this.level);
                        continue;
                    }
                    toTheLeft = this.appendUturn(cursor, toTheLeft);
                }
                this.target.finishWay(this.strips.elementAt(cursor.stripIndex), cursor.partIndex, j % 2 == 0, this.level);
            }
        }
        this.target.finishGeographyBuild(this.type, this.level);
    }

    private boolean appendUturn(SweepPolygonCursor cursor, boolean toTheLeft) {
        Strip strip = this.strips.elementAt(cursor.stripIndex);
        this.target.appendUturnNode(strip, cursor.partIndex, cursor.stripIndex, this.beams.elementAt(toTheLeft ? cursor.stripIndex + 1 : cursor.stripIndex).getBeamPartIndex(toTheLeft, cursor.partIndex), toTheLeft, this.level);
        cursor.partIndex = cursor.partIndex % 2 == 0 ? ++cursor.partIndex : --cursor.partIndex;
        return !toTheLeft;
    }

    public static enum Type {
        CORRIDOR,
        PLATFORM;

    }

    public static class SweepPolygonCursor {
        public int stripIndex;
        public int partIndex;

        public SweepPolygonCursor(int stripIndex, int partIndex) {
            this.stripIndex = stripIndex;
            this.partIndex = partIndex;
        }

        public int hashCode() {
            return Objects.hash(this.stripIndex, this.partIndex);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            SweepPolygonCursor other = (SweepPolygonCursor)obj;
            return Objects.equals(this.partIndex, other.partIndex) && Objects.equals(this.stripIndex, other.stripIndex);
        }
    }
}

